/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wikiwizard.WikiTag;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WikiTagManager {
    public ArrayList samePairTags;
    public ArrayList monoTags;
    public ArrayList differentPairTagsNotBackgrounded;
    public ArrayList differentPairTagsBackgrounded;
    public ArrayList differentPair;
    public int charactersPerTab;
    public ArrayList pairTags;
    public ArrayList allTags;
    private int counter = 0;

    public WikiTagManager(int charactersPerTab) {
        this.charactersPerTab = charactersPerTab;
        this.samePairTags = new ArrayList();
        this.monoTags = new ArrayList();
        this.differentPair = new ArrayList();
        this.differentPairTagsNotBackgrounded = new ArrayList();
        this.differentPairTagsBackgrounded = new ArrayList();
        this.pairTags = new ArrayList();
        this.allTags = new ArrayList();
    }

    public int getNumber() {
        return ++this.counter;
    }

    public void addTag(WikiTag theTag) {
        theTag.tagNr = this.getNumber();
        if (!theTag.startTag.equals("") && !theTag.endTag.equals("")) {
            this.pairTags.add(theTag);
        }
        if (theTag.startTag.equals(theTag.endTag)) {
            this.samePairTags.add(theTag);
        }
        if (theTag.fontFamily.equals("Courier")) {
            this.monoTags.add(theTag);
        }
        if (!theTag.startTag.equals(theTag.endTag) && !theTag.hasBackground()) {
            this.differentPairTagsNotBackgrounded.add(theTag);
        }
        if (!theTag.startTag.equals(theTag.endTag) && !theTag.endTag.equals("")) {
            this.differentPair.add(theTag);
        }
        if (!theTag.startTag.equals(theTag.endTag) && theTag.hasBackground()) {
            this.differentPairTagsBackgrounded.add(theTag);
        }
    }

    public String createCompleteRegExTerm() {
        return this.createCompleteRegExTerm(this.allTags);
    }

    public String createCompleteRegExTerm(ArrayList tagList) {
        String term = "";
        if (tagList.size() > 0) {
            term = ((WikiTag)tagList.get((int)0)).regEx;
        }
        for (int i = 1; i < tagList.size(); ++i) {
            term = term + "|" + ((WikiTag)tagList.get((int)i)).regEx;
        }
        return term;
    }

    public boolean loadFile(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = null;
        try {
            document = builder.parse(new InputSource(new StringReader(xml)));
            Element nl = document.getDocumentElement();
            NodeList list = nl.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element) || !((Element)list.item(i)).getTagName().equals("TAG")) continue;
                this.createTag(list.item(i).getChildNodes());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    private void createTag(NodeList tagAttributes) {
        NodeList list = tagAttributes;
        String startTag = "";
        String endTag = "";
        Color backgroundColor = Color.WHITE;
        boolean bold = false;
        boolean italic = false;
        int tagFontSize = 12;
        int textFontSize = 12;
        Color tagColor = Color.BLACK;
        Color textColor = Color.BLACK;
        Color startLineColor = Color.BLACK;
        String fontFamily = "";
        int headerTag = 0;
        boolean atBeginning = false;
        boolean tagFirstRow = false;
        boolean table = false;
        String separator = "";
        Color separatorColor = Color.BLACK;
        Color separateTextColor = Color.BLACK;
        boolean isCode = false;
        boolean isCodeRight = false;
        for (int i = 0; i < list.getLength(); ++i) {
            int j;
            Color tempColor;
            String itemColor;
            NodeList list2;
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("STARTTAG")) {
                startTag = ((Text)list.item(i).getFirstChild()).getData().trim();
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("ENDTAG")) {
                endTag = ((Text)list.item(i).getFirstChild()).getData().trim();
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("BACKGROUND")) {
                list2 = list.item(i).getChildNodes();
                itemColor = "000000";
                tempColor = new Color(0, 0, 0);
                for (j = 0; j < list2.getLength(); ++j) {
                    if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                    itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                    tempColor = this.hexToColor(itemColor);
                }
                backgroundColor = tempColor;
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("BOLD")) {
                bold = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("ITALIC")) {
                italic = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TAGFONTSIZE")) {
                tagFontSize = Integer.parseInt(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TEXTFONTSIZE")) {
                textFontSize = Integer.parseInt(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getChildNodes() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TAGCOLOR")) {
                list2 = list.item(i).getChildNodes();
                itemColor = "000000";
                tempColor = new Color(0, 0, 0);
                for (j = 0; j < list2.getLength(); ++j) {
                    if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                    itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                    tempColor = this.hexToColor(itemColor);
                }
                tagColor = tempColor;
                continue;
            }
            if (list.item(i).getChildNodes() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("STARTLINECOLOR")) {
                list2 = list.item(i).getChildNodes();
                itemColor = "000000";
                tempColor = new Color(0, 0, 0);
                for (j = 0; j < list2.getLength(); ++j) {
                    if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                    itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                    tempColor = this.hexToColor(itemColor);
                }
                startLineColor = tempColor;
                continue;
            }
            if (list.item(i).getChildNodes() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TEXTCOLOR")) {
                list2 = list.item(i).getChildNodes();
                itemColor = "000000";
                tempColor = new Color(0, 0, 0);
                for (j = 0; j < list2.getLength(); ++j) {
                    if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                    itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                    tempColor = this.hexToColor(itemColor);
                }
                textColor = tempColor;
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("FONTFAMILY")) {
                fontFamily = ((Text)list.item(i).getFirstChild()).getData().trim();
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("HEADERTAG")) {
                headerTag = Integer.parseInt(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("ATBEGINNING")) {
                atBeginning = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TAGFIRSTROW")) {
                tagFirstRow = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("TABLE")) {
                table = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("CODERIGHT")) {
                isCodeRight = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("CODE")) {
                isCode = this.parseBoolean(((Text)list.item(i).getFirstChild()).getData().trim());
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("SEPERATOR")) {
                separator = ((Text)list.item(i).getFirstChild()).getData().trim();
                continue;
            }
            if (list.item(i).getFirstChild() != null && list.item(i) instanceof Element && ((Element)list.item(i)).getTagName().equals("SEPERATORCOLOR")) {
                list2 = list.item(i).getChildNodes();
                itemColor = "000000";
                tempColor = new Color(0, 0, 0);
                for (j = 0; j < list2.getLength(); ++j) {
                    if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                    itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                    tempColor = this.hexToColor(itemColor);
                }
                separatorColor = tempColor;
                continue;
            }
            if (list.item(i).getFirstChild() == null || !(list.item(i) instanceof Element) || !((Element)list.item(i)).getTagName().equals("DESCRIPTIONCOLOR")) continue;
            list2 = list.item(i).getChildNodes();
            itemColor = "000000";
            tempColor = new Color(0, 0, 0);
            for (j = 0; j < list2.getLength(); ++j) {
                if (list2.item(j).getFirstChild() == null || !(list2.item(j) instanceof Element) || !((Element)list2.item(j)).getTagName().equals("COLOR")) continue;
                itemColor = ((Text)list2.item(j).getFirstChild()).getData().trim();
                tempColor = this.hexToColor(itemColor);
            }
            separateTextColor = tempColor;
        }
        this.allTags.add(new WikiTag(this, startTag, endTag, backgroundColor, bold, italic, tagFontSize, textFontSize, tagColor, textColor, fontFamily, headerTag, atBeginning, tagFirstRow, table, separator, separatorColor, separateTextColor, isCode, isCodeRight, startLineColor));
    }

    public Color hexToColor(String hexColor) {
        if (hexColor.length() == 3) {
            hexColor = hexColor.substring(0, 1) + hexColor.substring(0, 1) + hexColor.substring(1, 2) + hexColor.substring(1, 2) + hexColor.substring(2, 3) + hexColor.substring(2, 3);
        }
        if (hexColor.length() == 6) {
            int r = Integer.parseInt(hexColor.substring(0, 2), 16);
            int g = Integer.parseInt(hexColor.substring(2, 4), 16);
            int b = Integer.parseInt(hexColor.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        return new Color(0, 0, 0);
    }

    public boolean parseBoolean(String input) {
        return input.equals("true") || input.equals("True");
    }
}

