/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import org.wikiwizard.EditorDocument;

public class RemoveAction
extends AbstractUndoableEdit {
    protected int offset;
    protected String text;
    protected EditorDocument doc;
    protected int length;
    protected JTextPane textPane;

    public RemoveAction(JTextPane textPane, EditorDocument doc, int offset, int length, String text) {
        this.offset = offset;
        this.textPane = textPane;
        this.text = text;
        this.doc = doc;
        this.length = length;
    }

    public String getPresentationName() {
        return "Text Change";
    }

    public void undo() {
        super.undo();
        try {
            this.doc.stopUndo = true;
            if (this.text.length() > 1) {
                this.doc.stopNext = true;
                this.doc.insertString(this.offset, this.text, this.doc.normal);
                this.doc.highlightSyntax(3);
            } else {
                this.doc.insertString(this.offset, this.text, this.doc.normal);
            }
            this.textPane.setCaretPosition(this.offset + this.text.length());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void redo() {
        super.redo();
        try {
            this.doc.stopUndo = true;
            if (this.text.length() > 1) {
                this.doc.remove(this.offset, this.length);
                this.doc.highlightSyntax(3);
                this.doc.stopNext = true;
            } else {
                this.doc.remove(this.offset, this.length);
            }
            this.textPane.setCaretPosition(this.offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

