/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import java.security.Provider;
import java.security.Security;

public abstract class HttpsProtocolSupport {
    private static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final String SunJSSE_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    private static final String SSL_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private static Class _httpsProviderClass;
    private static boolean _httpsSupportVerified;
    private static boolean _httpsProtocolSupportEnabled;

    static boolean hasHttpsSupport() {
        if (!_httpsSupportVerified) {
            try {
                HttpsProtocolSupport.getHttpsProviderClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _httpsSupportVerified = true;
        }
        return _httpsProviderClass != null;
    }

    static void verifyProtocolSupport(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            return;
        }
        if (protocol.equalsIgnoreCase("https")) {
            HttpsProtocolSupport.validateHttpsProtocolSupport();
        }
    }

    private static void validateHttpsProtocolSupport() {
        if (!_httpsProtocolSupportEnabled) {
            HttpsProtocolSupport.verifyHttpsSupport();
            _httpsProtocolSupportEnabled = true;
        }
    }

    private static void verifyHttpsSupport() {
        try {
            Class providerClass = HttpsProtocolSupport.getHttpsProviderClass();
            if (!HttpsProtocolSupport.hasProvider(providerClass)) {
                Security.addProvider((Provider)providerClass.newInstance());
            }
            HttpsProtocolSupport.registerSSLProtocolHandler();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("https support requires the Java Secure Sockets Extension. See http://java.sun.com/products/jsse");
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to enable https support. Make sure that you have installed JSSE as described in http://java.sun.com/products/jsse/install.html: " + e);
        }
    }

    private static Class getHttpsProviderClass() throws ClassNotFoundException {
        if (_httpsProviderClass == null) {
            _httpsProviderClass = Class.forName(SunJSSE_PROVIDER_CLASS);
        }
        return _httpsProviderClass;
    }

    private static boolean hasProvider(Class providerClass) {
        Provider[] list = Security.getProviders();
        int i = 0;
        while (i < list.length) {
            if (list[i].getClass().equals(providerClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void registerSSLProtocolHandler() {
        String list = System.getProperty(PROTOCOL_HANDLER_PKGS);
        if (list == null || list.length() == 0) {
            System.setProperty(PROTOCOL_HANDLER_PKGS, SSL_PROTOCOL_HANDLER);
        } else if (list.indexOf(SSL_PROTOCOL_HANDLER) < 0) {
            System.setProperty(PROTOCOL_HANDLER_PKGS, "com.sun.net.ssl.internal.www.protocol | " + list);
        }
    }

    static {
        PROTOCOL_HANDLER_PKGS = PROTOCOL_HANDLER_PKGS;
        SunJSSE_PROVIDER_CLASS = SunJSSE_PROVIDER_CLASS;
        SSL_PROTOCOL_HANDLER = SSL_PROTOCOL_HANDLER;
    }
}

