/*
 * Decompiled with CFR 0.152.
 */
package java.dyn.util;

import java.dyn.MethodHandle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

class RewriteFakeMethodHandles {
    static final boolean TESTING = false;
    private static final int[] cpSize = new int[]{0, -1, 0, 4, 4, 8, 8, 2, 2, 4, 4, 4, 4};
    private static final String mhSuffixS = "FakeMethodHandle";
    private static final String mhSuffixDotClass = "FakeMethodHandle.class";
    private static final String mhNameS = MethodHandle.class.getName().replace('.', '/');
    private static Charset utf8CS = Charset.forName("UTF8");
    private static final byte[] mhSuffixA = "FakeMethodHandle".getBytes(utf8CS);
    private static final byte[] mhNameA = mhNameS.getBytes(utf8CS);

    RewriteFakeMethodHandles() {
    }

    public static void main(String ... stringArray) throws Exception {
        if (stringArray.length == 0) {
            throw new RuntimeException("Usage: FoldMethodHandleReferences file...");
        }
        int n = 0;
        for (String string : stringArray) {
            n += RewriteFakeMethodHandles.fold(new File(string));
        }
        System.out.println("Changed " + n + " files.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fold(File file) throws IOException {
        int n = 0;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if ((!file2.getName().endsWith(".class") || file2.getName().endsWith(mhSuffixDotClass)) && !file2.isDirectory()) continue;
                n += RewriteFakeMethodHandles.fold(file2);
            }
            return n;
        }
        InputStream inputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        inputStream = new BufferedInputStream(inputStream);
        try {
            boolean bl = RewriteFakeMethodHandles.fold(inputStream, byteArrayOutputStream);
            if (bl) {
                ++n;
            }
        }
        finally {
            inputStream.close();
        }
        File file3 = File.createTempFile("cls", "dat", file.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        try {
            ((OutputStream)fileOutputStream).write(byteArrayOutputStream.toByteArray());
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
        if (!file3.renameTo(file)) {
            throw new IOException("rename failed on " + file);
        }
        return n;
    }

    public static byte[] fold(byte[] byArray) {
        return RewriteFakeMethodHandles.fold(byArray, 0, byArray.length);
    }

    public static byte[] fold(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        try {
            boolean bl = RewriteFakeMethodHandles.fold(byteArrayInputStream, byteArrayOutputStream);
            if (!bl && n == 0 && n2 == byArray.length) {
                return byArray;
            }
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean fold(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = RewriteFakeMethodHandles.copyU2(inputStream, outputStream) << 16 | RewriteFakeMethodHandles.copyU2(inputStream, outputStream);
        if (n3 != -889275714) {
            bl = true;
        }
        if ((RewriteFakeMethodHandles.copyU2(inputStream, outputStream) | RewriteFakeMethodHandles.copyU2(inputStream, outputStream)) < 0) {
            bl = true;
        }
        int n4 = n2 = bl ? -1 : RewriteFakeMethodHandles.copyU2(inputStream, outputStream);
        if (n2 <= 0) {
            bl = true;
        }
        for (n = 1; n < n2; ++n) {
            int n5;
            int n6;
            int n7 = RewriteFakeMethodHandles.copyU1(inputStream, outputStream);
            if (n7 == 1) {
                n6 = RewriteFakeMethodHandles.copyU2(inputStream, byteArrayOutputStream);
                byteArrayOutputStream.reset();
                n5 = RewriteFakeMethodHandles.copyN(n6, inputStream, byteArrayOutputStream);
                if (n5 >= 0) {
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byte[] byArray2 = RewriteFakeMethodHandles.foldName(byArray);
                    outputStream.write(byArray2.length >> 8);
                    outputStream.write(byArray2.length >> 0);
                    outputStream.write(byArray2);
                    if (byArray2 != byArray) {
                        bl2 = true;
                    }
                }
            } else {
                n6 = n7 >= 0 && n7 < cpSize.length ? cpSize[n7] : 0;
                n5 = n6 > 0 ? RewriteFakeMethodHandles.copyN(n6, inputStream, outputStream) : -1;
            }
            if (n5 >= 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            throw new IOException("bad class file format");
        }
        while ((n = inputStream.read()) >= 0) {
            outputStream.write(n);
        }
        return bl2;
    }

    private static int copyU1(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = inputStream.read();
        if (n >= 0) {
            outputStream.write(n);
        }
        return n;
    }

    private static int copyU2(InputStream inputStream, OutputStream outputStream) throws IOException {
        return RewriteFakeMethodHandles.copyU1(inputStream, outputStream) << 8 | RewriteFakeMethodHandles.copyU1(inputStream, outputStream);
    }

    private static int copyN(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        for (int i = 0; i < n; ++i) {
            int n2 = RewriteFakeMethodHandles.copyU1(inputStream, outputStream);
            if (n2 >= 0) continue;
            return n2;
        }
        return n;
    }

    public static String foldName(String string) {
        if (string.endsWith(mhSuffixS)) {
            return mhNameS;
        }
        return string;
    }

    public static byte[] foldName(byte[] byArray) {
        int n = byArray.length - mhSuffixA.length;
        if (n <= 0) {
            return byArray;
        }
        for (int i = 0; i < mhSuffixA.length; ++i) {
            if (mhSuffixA[i] == byArray[n + i]) continue;
            return byArray;
        }
        return mhNameA;
    }
}

