/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodType;
import java.dyn.Wrappers;
import java.dyn.impl.Access;
import java.dyn.impl.MTForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTypeForm
extends MTForm {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final boolean varargs;
    final MethodType erase;
    final MethodType wrap;
    private static final Access TOKEN = Access.getToken();
    static final MethodTypeForm[] FAKE = new MethodTypeForm[]{new MethodTypeForm(false), new MethodTypeForm(true)};
    static final int ERASE = 1;
    static final int WRAP = 2;
    static final int UNWRAP = 4;
    static final int ARGS_ONLY = 8;
    static final int KEEP_VARARG = 16;

    public static MethodTypeForm of(MethodType methodType) {
        return methodType.form;
    }

    private MethodTypeForm(MethodType methodType, boolean bl) {
        super(TOKEN);
        int n;
        int n2;
        int n3;
        this.erase = methodType;
        this.varargs = bl;
        MethodType methodType2 = MethodTypeForm.canonType(methodType, 2);
        this.wrap = methodType2 == null ? methodType : methodType2;
        int n4 = n3 = methodType.ptypes.length;
        int n5 = 1;
        int n6 = 1;
        assert (bl == (n3 != 0 && methodType.ptypes[n3 - 1].isArray()));
        int[] nArray = null;
        int[] nArray2 = null;
        if (methodType2 != null) {
            n2 = 0;
            n = 0;
            int n7 = 0;
            int n8 = 0;
            Class<?>[] classArray = methodType.ptypes;
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                if (clazz == Object.class) continue;
                assert (clazz.isPrimitive());
                ++n2;
                if (!MethodTypeForm.hasTwoArgSlots(clazz)) continue;
                ++n;
            }
            n4 += n;
            Class<?> clazz = methodType.rtype;
            if (clazz != Object.class) {
                ++n7;
                if (MethodTypeForm.hasTwoArgSlots(clazz)) {
                    ++n8;
                }
                if (clazz == Void.TYPE) {
                    n6 = 0;
                    n5 = 0;
                } else {
                    n6 += n8;
                }
            }
            if (n != 0) {
                int n9 = n3 + n;
                nArray2 = new int[n9 + 1];
                nArray = new int[n3];
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz2 = classArray[i];
                    if (MethodTypeForm.hasTwoArgSlots(clazz2)) {
                        --n9;
                    }
                    nArray2[--n9] = i + 1;
                    nArray[i] = n9;
                }
                assert (n9 == 0);
            }
            this.primCounts = MethodTypeForm.pack(n8, n7, n, n2);
        } else {
            this.primCounts = 0L;
        }
        this.argCounts = MethodTypeForm.pack(n6, n5, n4, n3);
        if (nArray2 == null) {
            n2 = n3;
            nArray2 = new int[n2 + 1];
            nArray = new int[n3];
            for (n = 0; n < n3; ++n) {
                nArray2[--n2] = n + 1;
                nArray[n] = n2;
            }
        }
        this.argToSlotTable = nArray;
        this.slotToArgTable = nArray2;
        if (n4 >= 256) {
            throw new IllegalArgumentException("too many arguments");
        }
        super.init(methodType, this.parameterSlotCount());
    }

    private static boolean hasTwoArgSlots(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Double.TYPE;
    }

    private static long pack(int n, int n2, int n3, int n4) {
        assert (((n | n2 | n3 | n4) & 0xFFFF0000) == 0);
        long l = n << 16 | n2;
        long l2 = n3 << 16 | n4;
        return l << 32 | l2;
    }

    private static char unpack(long l, int n) {
        assert (n <= 3);
        return (char)(l >> (3 - n) * 16);
    }

    private MethodTypeForm(boolean bl) {
        super(TOKEN);
        this.varargs = bl;
        this.argCounts = -1L;
        this.primCounts = -1L;
        this.wrap = null;
        this.erase = null;
        this.slotToArgTable = null;
        this.argToSlotTable = null;
    }

    public int parameterCount() {
        return MethodTypeForm.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeForm.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 0);
    }

    public int parameterToArgSlot(int n) {
        return this.argToSlotTable[n];
    }

    public int argSlotToParameter(int n) {
        return this.slotToArgTable[n] - 1;
    }

    static MethodTypeForm findForm(MethodType methodType, boolean bl) {
        MethodType methodType2 = MethodTypeForm.canonType(methodType, 1 | (bl ? 16 : 0));
        if (methodType2 == null) {
            return new MethodTypeForm(methodType, bl);
        }
        return methodType2.form;
    }

    static MethodType canonType(MethodType methodType, int n) {
        Class<?>[] classArray = MethodTypeForm.canonTypes(methodType.ptypes, n);
        Class<?> clazz = null;
        if ((n & 8) == 0) {
            clazz = MethodTypeForm.canonType(methodType.rtype, n);
        }
        if (classArray == null && clazz == null) {
            return null;
        }
        if (clazz == null) {
            clazz = methodType.rtype;
        }
        if (classArray == null) {
            classArray = methodType.ptypes;
        }
        return MethodType.makeImpl(clazz, classArray, methodType.isVarArgs(), true);
    }

    static Class<?> canonType(Class<?> clazz, int n) {
        if (clazz != Object.class) {
            if (!clazz.isPrimitive()) {
                Class<?> clazz2;
                if ((n & 4) != 0 && (clazz2 = Wrappers.asPrimitiveType(clazz)) != clazz) {
                    return clazz2;
                }
                if ((n & 1) != 0) {
                    return Object.class;
                }
            } else if ((n & 2) != 0) {
                if ((n & 1) != 0) {
                    return Object.class;
                }
                return Wrappers.asWrapperType(clazz);
            }
        }
        return null;
    }

    static Class<?>[] canonTypes(Class<?>[] classArray, int n) {
        Class[] classArray2 = null;
        int n2 = classArray.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = MethodTypeForm.canonType(classArray[i], n);
            if (clazz == null) continue;
            if ((n & 0x10) != 0 && i + 1 == n2 && classArray[i].isArray()) break;
            if (classArray2 == null) {
                classArray2 = (Class[])classArray.clone();
            }
            classArray2[i] = clazz;
        }
        return classArray2;
    }
}

