/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodTypeForm;
import java.dyn.Wrappers;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodType {
    final Class<?> rtype;
    final Class<?>[] ptypes;
    MethodTypeForm form;
    MethodType wrapAlt;
    static final HashMap<MethodType, MethodType> internTable = new HashMap();
    static final Class<?>[] NO_PTYPES = new Class[0];
    private static final MethodType[] objectOnlyTypes = new MethodType[20];

    private MethodType(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        this.rtype = clazz;
        this.ptypes = classArray;
        if (!bl) {
            this.form = MethodTypeForm.FAKE[0];
        } else {
            this.form = MethodTypeForm.FAKE[1];
            this.checkVarargs();
        }
        assert (this.isVarArgs() == bl);
    }

    private void checkVarargs() {
        if (this.ptypes.length == 0 || !this.ptypes[this.ptypes.length - 1].isArray()) {
            throw new IllegalArgumentException("not varargs: " + this);
        }
    }

    public static MethodType make(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, false, false);
    }

    public static MethodType make(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        return MethodType.makeImpl(clazz, classArray, bl, false);
    }

    public static MethodType make(Class<?> clazz, List<Class<?>> list) {
        return MethodType.makeImpl(clazz, list.toArray(NO_PTYPES), false, true);
    }

    public static MethodType make(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        return MethodType.makeImpl(clazz, MethodType.append(clazz2, classArray), false, true);
    }

    public static MethodType make(Class<?> clazz) {
        return MethodType.makeImpl(clazz, NO_PTYPES, false, true);
    }

    public static MethodType make(Class<?> clazz, Class<?> clazz2) {
        return MethodType.makeImpl(clazz, new Class[]{clazz2}, false, true);
    }

    public static MethodType make(Class<?> clazz, MethodType methodType) {
        return MethodType.makeImpl(clazz, methodType.ptypes, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl, boolean bl2) {
        MethodType methodType;
        MethodType methodType2 = new MethodType(clazz, classArray, bl);
        HashMap<MethodType, MethodType> hashMap = internTable;
        synchronized (hashMap) {
            methodType = internTable.get(methodType2);
            if (methodType != null) {
                return methodType;
            }
        }
        if (!bl2) {
            classArray = (Class[])classArray.clone();
        }
        methodType2.form = MethodTypeForm.findForm(methodType2, bl);
        assert (methodType2.isVarArgs() == bl);
        hashMap = internTable;
        synchronized (hashMap) {
            methodType = internTable.get(methodType2);
            if (methodType != null) {
                return methodType;
            }
            internTable.put(methodType2, methodType2);
        }
        return methodType2;
    }

    public static MethodType make(String string, ClassLoader classLoader) {
        Class<?> clazz;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string2 = string;
        int[] nArray = new int[]{0};
        ArrayList arrayList = new ArrayList();
        if (nArray[0] < string2.length() && string2.charAt(nArray[0]) == '(') {
            nArray[0] = nArray[0] + 1;
            while (nArray[0] < string2.length() && string2.charAt(nArray[0]) != ')') {
                clazz = MethodType.parseSig(string2, nArray, classLoader);
                if (clazz == null || clazz == Void.TYPE) {
                    MethodType.parseError(string2, "bad argument type");
                }
                arrayList.add(clazz);
            }
            nArray[0] = nArray[0] + 1;
        }
        if ((clazz = MethodType.parseSig(string2, nArray, classLoader)) == null || nArray[0] != string2.length()) {
            MethodType.parseError(string2, "bad return type");
        }
        return MethodType.make(clazz, arrayList);
    }

    public String toBytecodeString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : this.ptypes) {
            this.unparseSig(clazz, stringBuilder);
        }
        stringBuilder.append(')');
        this.unparseSig(this.rtype, stringBuilder);
        return stringBuilder.toString();
    }

    private static void parseError(String string, String string2) {
        throw new IllegalArgumentException("bad signature: " + string + ": " + string2);
    }

    private static Class<?> parseSig(String string, int[] nArray, ClassLoader classLoader) {
        if (nArray[0] == string.length()) {
            return null;
        }
        int n = nArray[0];
        nArray[0] = n + 1;
        char c = string.charAt(n);
        if (c == 'L') {
            int n2 = nArray[0];
            int n3 = string.indexOf(59, n2);
            if (n3 < 0) {
                return null;
            }
            nArray[0] = n3 + 1;
            String string2 = string.substring(n2, n3).replace('/', '.');
            try {
                return classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MethodType.parseError(string, classNotFoundException.toString());
                return null;
            }
        }
        if (c == '[') {
            Class<?> clazz = MethodType.parseSig(string, nArray, classLoader);
            if (clazz != null) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }
        return Wrappers.basicTypeFromChar(c);
    }

    private void unparseSig(Class<?> clazz, StringBuilder stringBuilder) {
        char c = Wrappers.basicTypeChar(clazz);
        if (c != 'L') {
            stringBuilder.append(c);
        } else {
            boolean bl;
            boolean bl2 = bl = !clazz.isArray();
            if (bl) {
                stringBuilder.append('L');
            }
            stringBuilder.append(clazz.getName().replace('.', '/'));
            if (bl) {
                stringBuilder.append(';');
            }
        }
    }

    public static MethodType makeGeneric(int n, boolean bl) {
        MethodType methodType;
        int n2 = !bl ? 0 : 1;
        int n3 = n * 2 + n2;
        if (n3 < objectOnlyTypes.length && (methodType = objectOnlyTypes[n3]) != null) {
            return methodType;
        }
        Object[] objectArray = new Class[n + n2];
        Arrays.fill(objectArray, Object.class);
        if (n2 != 0) {
            objectArray[n] = Object[].class;
        }
        methodType = MethodType.makeImpl(Object.class, objectArray, bl, true);
        if (n3 < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[n3] = methodType;
        }
        return methodType;
    }

    public static MethodType makeGeneric(int n) {
        return MethodType.makeGeneric(n, false);
    }

    public static MethodType make(Method method) {
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        if (!Modifier.isStatic(method.getModifiers())) {
            classArray = MethodType.append(method.getDeclaringClass(), classArray);
        }
        return MethodType.makeImpl(clazz, classArray, method.isVarArgs(), true);
    }

    static Class<?>[] append(Class<?> clazz, Class<?> ... classArray) {
        Class[] classArray2 = new Class[1 + classArray.length];
        classArray2[0] = clazz;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return classArray2;
    }

    public MethodType newParameterType(int n, Class<?> clazz) {
        if (this.parameterType(n) == clazz) {
            return this;
        }
        Class[] classArray = (Class[])this.ptypes.clone();
        classArray[n] = clazz;
        return MethodType.makeImpl(this.rtype, classArray, this.isVarArgs(), true);
    }

    public MethodType newReturnType(Class<?> clazz) {
        if (this.returnType() == clazz) {
            return this;
        }
        return MethodType.makeImpl(clazz, this.ptypes, this.isVarArgs(), true);
    }

    public MethodType newVarArgs(boolean bl) {
        if (this.isVarArgs() == bl) {
            return this;
        }
        return MethodType.makeImpl(this.rtype, this.ptypes, bl, true);
    }

    public boolean hasPrimitives() {
        return this.form.primCounts != 0L;
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erase;
    }

    public MethodType eraseWrap() {
        return this.form.wrap;
    }

    public MethodType generic() {
        return this.form.wrap.erase();
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType methodType = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(methodType);
    }

    private static MethodType wrapWithPrims(MethodType methodType) {
        assert (methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonType(methodType, 2);
            assert (methodType2 != null);
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    private static MethodType unwrapWithNoPrims(MethodType methodType) {
        assert (!methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonType(methodType, 4);
            if (methodType2 == null) {
                methodType2 = methodType;
            }
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    public Class<?> parameterType(int n) {
        return this.ptypes[n];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public boolean isVarArgs() {
        return this.form.varargs;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList(this.ptypes));
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof MethodType && this.equals((MethodType)object);
    }

    private boolean equals(MethodType methodType) {
        return this.rtype == methodType.rtype && this.isVarArgs() == methodType.isVarArgs() && Arrays.equals(this.ptypes, methodType.ptypes);
    }

    public int hashCode() {
        int n = 31 + this.rtype.hashCode();
        for (Class<?> clazz : this.ptypes) {
            n = 31 * n + clazz.hashCode();
        }
        if (this.isVarArgs()) {
            n = 31 * n + Void.TYPE.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int n = this.isVarArgs() ? this.ptypes.length - 1 : -1;
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            if (i == n) {
                MethodType.putName(stringBuilder, this.ptypes[i].getComponentType());
                stringBuilder.append("...");
                break;
            }
            MethodType.putName(stringBuilder, this.ptypes[i]);
        }
        stringBuilder.append(")");
        MethodType.putName(stringBuilder, this.rtype);
        return stringBuilder.toString();
    }

    static void putName(StringBuilder stringBuilder, Class<?> clazz) {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        String string = clazz.getName();
        stringBuilder.append(string);
        while (n > 0) {
            stringBuilder.append("[]");
            --n;
        }
    }
}

