require 'benchmark'

def bench_array(bm)
  bm.report("control, empty loop") { 1_000_000.times { self } }
  bm.report("control, loop with 100 fixnums") do
    1_000_000.times do
      1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0
      1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0
    end
  end
  bm.report("1m loops, 10 empty arrays") { 1_000_000.times { []; []; []; []; []; []; []; []; []; [] } }
  bm.report("1m loops, 10 10-fixnum arrays") do
    1_000_000.times do
      [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]
      [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]; [1,2,3,4,5,6,7,8,9,0]
    end
  end
end

if $0 == __FILE__
  (ARGV[0] || 10).to_i.times { Benchmark.bm(30) {|bm| bench_array(bm)} }
end