/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.webdav.lib.WebdavResource;

public class WebdavResources {
    Hashtable hrefTable = new Hashtable();

    public WebdavResources() {
    }

    public WebdavResources(WebdavResource resource) {
        this.addResource(resource);
    }

    public boolean isEmpty() {
        return this.hrefTable.isEmpty();
    }

    public boolean isThereResourceName(String resourceName) {
        return this.hrefTable.containsKey(resourceName);
    }

    public boolean isThereResource(WebdavResource resource) {
        return this.hrefTable.contains(resource);
    }

    public Enumeration getResourceNames() {
        return this.hrefTable.keys();
    }

    public Enumeration getResources() {
        return this.hrefTable.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() {
        Hashtable hashtable = this.hrefTable;
        synchronized (hashtable) {
            int num = this.hrefTable.size();
            String[] resourceNames = new String[num];
            Enumeration resources = this.getResourceNames();
            int i = 0;
            while (resources.hasMoreElements()) {
                resourceNames[i++] = (String)resources.nextElement();
            }
            return resourceNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebdavResource[] listResources() {
        Hashtable hashtable = this.hrefTable;
        synchronized (hashtable) {
            int num = this.hrefTable.size();
            WebdavResource[] WebdavResources2 = new WebdavResource[num];
            Enumeration resources = this.getResources();
            int i = 0;
            while (resources.hasMoreElements()) {
                WebdavResources2[i++] = (WebdavResource)resources.nextElement();
            }
            return WebdavResources2;
        }
    }

    public WebdavResource getResource(String resourceName) {
        return (WebdavResource)this.hrefTable.get(resourceName);
    }

    public void addResource(String resourceName, WebdavResource resource) {
        this.hrefTable.put(resourceName, resource);
    }

    public void addResource(WebdavResource resource) {
        String displayName = resource.getDisplayName();
        if (displayName == null || displayName.trim().equals("")) {
            displayName = resource.getName();
        }
        this.hrefTable.put(displayName, resource);
    }

    public WebdavResource removeResource(String resourceName) {
        return (WebdavResource)this.hrefTable.remove(resourceName);
    }

    public void removeAll() {
        this.hrefTable.clear();
    }

    public String toString() {
        return this.hrefTable.toString();
    }
}

