/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net;

import java.io.File;
import java.util.Vector;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.DataConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.Transfer;
import net.sf.jftp.system.logging.Log;

public class FtpTransfer
extends Transfer
implements Runnable {
    private String host;
    private int port;
    private String localPath;
    private String remotePath;
    private String file;
    private String user;
    private String pass;
    private FtpConnection con = null;
    private String type;
    public Thread runner;
    private int stat = 0;
    private boolean started = false;
    private ConnectionHandler handler;
    private Vector<ConnectionListener> listeners;
    private String newName = null;
    private int transferStatus = 0;
    private String crlf = null;

    public FtpTransfer(String host, int port, String localPath, String remotePath, String file, String user, String pass, String type, ConnectionHandler handler, Vector<ConnectionListener> listeners, String newName, String crlf) {
        this.host = host;
        this.port = port;
        this.localPath = localPath;
        this.remotePath = remotePath;
        this.file = file;
        this.user = user;
        this.pass = pass;
        this.type = type;
        this.handler = handler;
        this.listeners = listeners;
        this.newName = newName;
        this.crlf = crlf;
        if (handler == null) {
            handler = new ConnectionHandler();
        }
        this.prepare();
    }

    public FtpTransfer(String host, int port, String localPath, String remotePath, String file, String user, String pass, String type, ConnectionHandler handler, Vector<ConnectionListener> listeners, String crlf) {
        this.host = host;
        this.port = port;
        this.localPath = localPath;
        this.remotePath = remotePath;
        this.file = file;
        this.user = user;
        this.pass = pass;
        this.type = type;
        this.handler = handler;
        this.listeners = listeners;
        this.crlf = crlf;
        if (handler == null) {
            handler = new ConnectionHandler();
        }
        this.prepare();
    }

    @Override
    public void prepare() {
        this.runner = new Thread(this);
        this.runner.setPriority(1);
        this.runner.start();
    }

    @Override
    public void run() {
        if (this.handler.getConnections().get(this.file) == null) {
            this.handler.addConnection(this.file, this);
        } else if (!this.pause) {
            Log.debug("Transfer already in progress: " + this.file);
            this.work = false;
            this.stat = 2;
            return;
        }
        boolean hasPaused = false;
        while (this.pause) {
            try {
                int i;
                Thread.sleep(100L);
                if (this.listeners != null) {
                    for (i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.elementAt(i).updateProgress(this.file, "STOPPED", -1L);
                    }
                }
                if (!this.work && this.listeners != null) {
                    for (i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.elementAt(i).updateProgress(this.file, "REMOVED", -1L);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            hasPaused = true;
        }
        while (this.handler.getConnectionSize() >= Settings.getMaxConnections() && this.handler.getConnectionSize() > 0 && this.work) {
            try {
                this.stat = 4;
                Thread.sleep(400L);
                if (hasPaused || this.listeners == null) break;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.elementAt(i).updateProgress(this.file, "QUEUED", -1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!this.work) {
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.elementAt(i).updateProgress(this.file, "REMOVED", -1L);
                }
            }
            this.handler.removeConnection(this.file);
            this.stat = 3;
            return;
        }
        this.started = true;
        try {
            Thread.sleep(Settings.ftpTransferThreadPause);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.con = new FtpConnection(this.host, this.port, this.remotePath, this.crlf);
        this.con.setConnectionHandler(this.handler);
        this.con.setConnectionListeners(this.listeners);
        int status = this.con.login(this.user, this.pass);
        if (status == 2) {
            File f = new File(this.localPath);
            this.con.setLocalPath(f.getAbsolutePath());
            this.transferStatus = this.type.equals("UPLOAD") ? (this.newName != null ? this.con.upload(this.file, this.newName) : this.con.upload(this.file)) : this.con.download(this.file);
        }
        if (!this.pause) {
            this.handler.removeConnection(this.file);
        }
    }

    @Override
    public int getStatus() {
        return this.stat;
    }

    public int getTransferStatus() {
        return this.transferStatus;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public FtpConnection getFtpConnection() {
        return this.con;
    }

    @Override
    public DataConnection getDataConnection() {
        return this.con.getDataConnection();
    }
}

