/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.hostchooser;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.framework.HInsetPanel;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.gui.tasks.ExternalDisplayer;
import net.sf.jftp.net.wrappers.StartConnection;
import net.sf.jftp.system.logging.Log;

public class NfsHostChooser
extends HFrame
implements ActionListener,
WindowListener {
    public static HTextField host = new HTextField("URL:", "nfs://localhost:v2m/tmp", 20);
    public static HTextField user = new HTextField("Username:", "<anonymous>", 15);
    public static HPasswordField pass = new HPasswordField("Password:", "nopasswd");
    public static HButton info = new HButton("Read me!");
    private HPanel okP = new HPanel();
    private HButton ok = new HButton("Connect");
    private ComponentListener listener = null;
    private boolean useLocal = false;

    public NfsHostChooser(ComponentListener l, boolean local) {
        this.listener = l;
        this.useLocal = local;
        this.init();
    }

    public NfsHostChooser(ComponentListener l) {
        this.listener = l;
        this.init();
    }

    public NfsHostChooser() {
        this.init();
    }

    public void init() {
        this.setLocation(100, 150);
        this.setTitle("NFS Connection...");
        this.setBackground(this.okP.getBackground());
        JPanel p = new JPanel();
        p.add(info);
        try {
            File f = new File(Settings.appHomeDir);
            f.mkdir();
            File f1 = new File(Settings.login);
            f1.createNewFile();
            File f2 = new File(Settings.login_def_nfs);
            f2.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        LoadSet l = new LoadSet();
        String[] login = LoadSet.loadSet(Settings.login_def_nfs);
        if (login[0] != null && login.length > 1) {
            host.setText(login[0]);
            user.setText(login[1]);
        }
        if (Settings.getStorePasswords()) {
            if (login[0] != null && login.length > 2 && login[2] != null) {
                pass.setText(login[2]);
            }
        } else {
            pass.setText("");
        }
        HInsetPanel root = new HInsetPanel();
        root.setLayout(new GridLayout(4, 2, 5, 3));
        root.add(host);
        root.add(p);
        root.add(user);
        root.add(pass);
        root.add(new JLabel(""));
        root.add(this.okP);
        this.okP.add(this.ok);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add("Center", root);
        this.ok.addActionListener(this);
        info.addActionListener(this);
        this.setDefaultCloseOperation(0);
        NfsHostChooser.pass.text.addActionListener(this);
        this.pack();
        this.setModal(false);
        this.setVisible(false);
        this.addWindowListener(this);
    }

    public void update() {
        this.fixLocation();
        this.setVisible(true);
        this.toFront();
        host.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == info) {
            URL url = ClassLoader.getSystemResource("docs/doc/nfsinfo");
            if (url == null) {
                url = HImage.class.getResource("/docs/doc/nfsinfo");
            }
            ExternalDisplayer d = new ExternalDisplayer(url);
        } else if (e.getSource() == this.ok || e.getSource() == NfsHostChooser.pass.text) {
            this.setCursor(new Cursor(3));
            Object con = null;
            String htmp = host.getText().trim();
            String utmp = user.getText().trim();
            String ptmp = pass.getText();
            int potmp = 0;
            String userName = NfsHostChooser.user.text.getText();
            try {
                boolean status = StartConnection.startCon("NFS", htmp, userName, ptmp, potmp, "", this.useLocal);
            }
            catch (Exception ex) {
                Log.debug("Could not create NfsConnection!");
            }
            this.setCursor(new Cursor(0));
            this.dispose();
            JFtp.mainFrame.setVisible(true);
            JFtp.mainFrame.toFront();
            if (this.listener != null) {
                this.listener.componentResized(new ComponentEvent(this, 0));
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

