/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.Oid;
import java.util.Enumeration;
import java.util.Vector;

public class GSSCredential {
    public static final int INITIATE_AND_ACCEPT = 0;
    public static final int INITIATE_ONLY = 1;
    public static final int ACCEPT_ONLY = 2;
    public static final int INDEFINITE = Integer.MAX_VALUE;
    Vector m_mechCreds = new Vector(3, 3);

    public GSSCredential(int n) throws GSSException {
        this.add(null, Integer.MAX_VALUE, Integer.MAX_VALUE, null, n);
    }

    GSSCredential(GSSCredSpi gSSCredSpi) {
        this.m_mechCreds.addElement(gSSCredSpi);
    }

    public GSSCredential(GSSName gSSName, int n) throws GSSException {
        this.add(gSSName, Integer.MAX_VALUE, Integer.MAX_VALUE, null, n);
    }

    public GSSCredential(GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        this.add(gSSName, n, n, oid, n2);
    }

    public GSSCredential(GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        int n3 = 0;
        while (n3 < oidArray.length) {
            this.add(gSSName, n, n, oidArray[n3], n2);
            ++n3;
        }
    }

    public synchronized void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        if (oid == null) {
            oid = GSSManager.getDefaultMech();
        }
        if (this.getMechCred(oid, false) != null) {
            throw new GSSException(17);
        }
        GSSCredSpi gSSCredSpi = GSSManager.getCredInstance(oid);
        gSSCredSpi.init(gSSName.canonicalizeInPlace(oid), n, n2, n3);
        this.m_mechCreds.addElement(gSSCredSpi);
    }

    public void dispose() throws GSSException {
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            ((GSSCredSpi)enumeration.nextElement()).dispose();
        }
        this.m_mechCreds.removeAllElements();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GSSCredential)) {
            return false;
        }
        GSSCredential gSSCredential = (GSSCredential)object;
        if (gSSCredential.m_mechCreds.size() != this.m_mechCreds.size()) {
            return false;
        }
        try {
            Enumeration enumeration = this.m_mechCreds.elements();
            while (enumeration.hasMoreElements()) {
                GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
                GSSCredSpi gSSCredSpi2 = gSSCredential.getMechCred(gSSCredSpi.getMechanism(), false);
                if (gSSCredSpi2 == null) {
                    return false;
                }
                if (gSSCredSpi.equals(gSSCredSpi2)) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        return true;
    }

    public GSSName getGSSName() throws GSSException {
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        GSSName gSSName = new GSSName();
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            gSSName.addMechName(((GSSCredSpi)enumeration.nextElement()).getName());
        }
        return gSSName;
    }

    public GSSName getGSSName(Oid oid) throws GSSException {
        GSSName gSSName = new GSSName();
        gSSName.addMechName(this.getMechCred(oid, true).getName());
        return gSSName;
    }

    GSSCredSpi getMechCred(Oid oid, boolean bl) throws GSSException {
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (!gSSCredSpi.getMechanism().equals(oid)) continue;
            return gSSCredSpi;
        }
        if (bl) {
            throw new GSSException(2);
        }
        return null;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[this.m_mechCreds.size()];
        int n = 0;
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            oidArray[n++] = ((GSSCredSpi)enumeration.nextElement()).getMechanism();
        }
        return oidArray;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        GSSCredSpi gSSCredSpi = this.getMechCred(oid, true);
        return gSSCredSpi.getAcceptLifetime();
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        GSSCredSpi gSSCredSpi = this.getMechCred(oid, true);
        return gSSCredSpi.getInitLifetime();
    }

    public int getRemainingLifetime() throws GSSException {
        int n = Integer.MAX_VALUE;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (gSSCredSpi.getLifetime() >= n) continue;
            n = gSSCredSpi.getLifetime();
        }
        return n;
    }

    public int getUsage() throws GSSException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration enumeration = this.m_mechCreds.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredSpi gSSCredSpi = (GSSCredSpi)enumeration.nextElement();
            if (gSSCredSpi.getUsage() == 0) {
                return 0;
            }
            if (gSSCredSpi.getUsage() == 1) {
                bl = true;
            } else if (gSSCredSpi.getUsage() == 2) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return 0;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    public int getUsage(Oid oid) throws GSSException {
        GSSCredSpi gSSCredSpi = this.getMechCred(oid, true);
        return gSSCredSpi.getUsage();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(super.toString());
        stringBuffer.append("\nOver mechs:\t");
        try {
            Oid[] oidArray = this.getMechs();
            int n = 0;
            while (n < oidArray.length) {
                stringBuffer.append(String.valueOf(oidArray[n].toString()) + " ");
                ++n;
            }
            stringBuffer.append("\nFor principal:\t" + this.getGSSName().toString());
            stringBuffer.append("\nUsage:\t" + this.getUsage());
            if (this.getUsage() == 2) {
                stringBuffer.append(" (ACCEPT_ONLY)");
            } else if (this.getUsage() == 1) {
                stringBuffer.append(" (INITIATE_ONLY)");
            } else {
                stringBuffer.append(" (INITIATE and ACCEPT)");
            }
            stringBuffer.append("\nRemaining Lifetime:\t" + this.getRemainingLifetime());
        }
        catch (GSSException gSSException) {
            stringBuffer.append("\n***ERROR getting info:\t" + gSSException.toString());
        }
        return stringBuffer.toString();
    }
}

