/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

class DERParser {
    DERParser() {
    }

    static Vector decodeOid(InputStream inputStream) throws GSSException {
        try {
            if (inputStream.read() != 6) {
                throw new GSSException(10);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return DERParser.decodeOidOctets(inputStream, DERParser.readLength(inputStream));
    }

    static Vector decodeOidOctets(InputStream inputStream, int n) throws GSSException {
        Vector<Integer> vector = new Vector<Integer>(9, 3);
        try {
            int n2 = inputStream.read();
            int n3 = n2 < 40 ? 0 : (n2 < 80 ? 1 : 2);
            vector.addElement(new Integer(n3));
            vector.addElement(new Integer(n2 - 40 * n3));
            int n4 = 1;
            while (n4 < n) {
                n3 = 0;
                int n5 = 0;
                while (n5 < 4) {
                    n3 <<= 7;
                    n2 = inputStream.read();
                    n3 |= n2 & 0x7F;
                    if ((n2 & 0x80) == 0) break;
                    ++n4;
                    ++n5;
                }
                vector.addElement(new Integer(n3));
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return vector;
    }

    static byte[] encodeOid(Vector vector) throws GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 1;
        try {
            byteArrayOutputStream.write(6);
            if (vector.size() < 2) {
                throw new IllegalArgumentException();
            }
            int n2 = 2;
            while (n2 < vector.size()) {
                int n3 = 0;
                int n4 = (Integer)vector.elementAt(n2);
                n3 = 0;
                while (n4 > 0) {
                    n4 >>= 7;
                    ++n3;
                }
                n = n3 == 0 ? ++n : (n += n3);
                ++n2;
            }
            DERParser.writeLength(byteArrayOutputStream, n);
            DERParser.writeOidOctets(byteArrayOutputStream, vector);
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static int readLength(InputStream inputStream) throws GSSException {
        int n;
        try {
            int n2 = inputStream.read();
            if ((n2 & 0x80) == 0) {
                n = n2;
            } else {
                n2 &= 0x7F;
                n = 0;
                while (n2 > 0) {
                    n <<= 8;
                    n += 0xFF & inputStream.read();
                    --n2;
                }
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10);
        }
        return n;
    }

    static void writeLength(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else if (n < 256) {
            outputStream.write(129);
            outputStream.write(n);
        } else if (n < 524288) {
            outputStream.write(130);
            outputStream.write(n >> 8);
            outputStream.write(n & 0xFF);
        } else if (n < 0x1000000) {
            outputStream.write(131);
            outputStream.write(n >> 16);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        } else {
            outputStream.write(132);
            outputStream.write(n >>> 24);
            outputStream.write(n >> 16 & 0xFF);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
    }

    static void writeOidOctets(OutputStream outputStream, Vector vector) throws IOException {
        outputStream.write((Integer)vector.elementAt(0) * 40 + (Integer)vector.elementAt(1));
        int n = 2;
        while (n < vector.size()) {
            int n2 = (Integer)vector.elementAt(n);
            int n3 = 0;
            while (n3 < 4) {
                int n4 = n2 & 0x7F;
                if ((n2 >>>= 7) <= 0) {
                    outputStream.write(n4);
                    break;
                }
                outputStream.write(n4 | 0x80);
                ++n3;
            }
            ++n;
        }
    }
}

