/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$util$ExtensionClassLoader == null ? (class$com$sshtools$j2ssh$util$ExtensionClassLoader = ExtensionClassLoader.class$("com.sshtools.j2ssh.util.ExtensionClassLoader")) : class$com$sshtools$j2ssh$util$ExtensionClassLoader);
    Vector classpath = new Vector();
    private Hashtable cache = new Hashtable();
    private HashMap packages = new HashMap();
    static /* synthetic */ Class class$com$sshtools$j2ssh$util$ExtensionClassLoader;

    public ExtensionClassLoader() {
    }

    public ExtensionClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void add(String string) {
        this.add(new File(string));
    }

    public void add(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this.add(fileArray[i]);
        }
    }

    public void add(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Classpath " + file.getAbsolutePath() + " doesn't exist!");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Don't have read access for file " + file.getAbsolutePath());
        }
        if (!file.isDirectory() && !this.isJarArchive(file)) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or jar file" + " or if it's a jar file then it is corrupted.");
        }
        log.info("Adding " + file.getAbsolutePath() + " to the extension classpath");
        this.classpath.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var6_4 = null;
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (ZipException zipException) {
                bl = false;
                Object var6_5 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            catch (IOException iOException) {
                bl = false;
                Object var6_6 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public URL getResource(String string, File file) {
        if (this.isJarArchive(file)) {
            return this.findResourceInZipfile(file, string);
        }
        return this.findResourceInDirectory(file, string);
    }

    protected URL findResource(String string) {
        URL uRL = null;
        Iterator iterator = this.classpath.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            uRL = file.isDirectory() ? this.findResourceInDirectory(file, string) : this.findResourceInZipfile(file, string);
            if (uRL != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found resource " + uRL.toExternalForm());
                }
                return uRL;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Could not find resource " + string);
        }
        return null;
    }

    protected Enumeration findResources(String string) {
        HashSet<URL> hashSet = new HashSet<URL>();
        URL uRL = null;
        Iterator iterator = this.classpath.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            uRL = file.isDirectory() ? this.findResourceInDirectory(file, string) : this.findResourceInZipfile(file, string);
            if (uRL == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found resource " + uRL.toExternalForm());
            }
            hashSet.add(uRL);
        }
        return new ResourceEnumeration(hashSet);
    }

    public byte[] loadClassData(String string) throws ClassNotFoundException {
        Iterator iterator = this.classpath.iterator();
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        while (iterator.hasNext()) {
            byte[] byArray;
            File file = (File)iterator.next();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, null) : this.loadClassFromZipfile(file, string, null);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            return byArray;
        }
        throw new ClassNotFoundException(string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + string + " from cache");
            }
            clazz = classCacheEntry.loadedClass;
            this.resolveClass(clazz);
            return clazz;
        }
        Iterator iterator = this.classpath.iterator();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (iterator.hasNext()) {
            byte[] byArray;
            File file = (File)iterator.next();
            try {
                byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
            }
            catch (IOException iOException) {
                byArray = null;
            }
            if (byArray == null) continue;
            String string2 = "";
            if (string.lastIndexOf(".") > 0) {
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            if (!string2.equals("") && !this.packages.containsKey(string2)) {
                this.packages.put(string2, this.definePackage(string2, "", "", "", "", "", "", null));
            }
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            this.resolveClass(clazz);
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + string + " adding to cache and returning");
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            if (classCacheEntry != null) {
                classCacheEntry.origin = file2;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                return byArray;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        String string2 = string.replace('.', '/') + ".class";
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry != null) {
                if (classCacheEntry != null) {
                    classCacheEntry.origin = file;
                }
                byte[] byArray = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipFile.close();
        }
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    private URL findResourceInDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return file2.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private URL findResourceInZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return new URL("jar:" + file.toURL() + "!" + (string.startsWith("/") ? "" : "/") + string);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private InputStream loadResourceFromZipfile(File file, String string) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipFile.getInputStream(zipEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        Set resources;
        Iterator it;

        ResourceEnumeration(Set set) {
            this.resources = set;
            this.it = set.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

