/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.dir.DirCellRenderer;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.wrappers.SmbConnection;
import net.sf.jftp.system.logging.Log;

public class InsomniacClient
extends HPanel
implements Runnable,
ActionListener {
    private HTextField host = new HTextField("URL:", "http://canofsleep.com:8180/Insomniac/test.jsp?keywords=", 40);
    private HTextField search = new HTextField("Search term:", "mp3", 20);
    private HTextField user = new HTextField("User:", "guest", 10);
    private HPasswordField pass = new HPasswordField("Password:", "none");
    private HTextField dir = new HTextField("Download to:", Settings.defaultWorkDir, 20);
    private JPanel p1 = new JPanel();
    private JPanel p2 = new JPanel();
    private JButton ok = new JButton("Search");
    private JList list = new JList();
    private JButton load = new JButton("Download file");
    private Vector files;
    private Vector sizes;
    private Thread runner;
    private boolean doSearch;
    private Vector fileNames;

    public InsomniacClient() {
        this.setLayout(new BorderLayout());
        JPanel x1 = new JPanel();
        x1.setLayout(new FlowLayout(0));
        x1.add(this.host);
        x1.add(this.search);
        JPanel x2 = new JPanel();
        x2.setLayout(new FlowLayout(0));
        x2.add(this.search);
        x2.add(this.dir);
        JPanel x3 = new JPanel();
        x3.setLayout(new FlowLayout(0));
        x3.add(this.user);
        x3.add(this.pass);
        this.p1.setLayout(new BoxLayout(this.p1, 1));
        this.p1.add(x1);
        this.p1.add(x2);
        this.p1.add(x3);
        JPanel okP = new JPanel();
        okP.setLayout(new FlowLayout(1));
        okP.add(this.ok);
        okP.add(new JLabel("   "));
        okP.add(this.load);
        this.list.setFixedCellWidth(720);
        this.list.setVisibleRowCount(12);
        this.list.setCellRenderer(new DirCellRenderer());
        JScrollPane pane = new JScrollPane(this.list);
        this.p2.add(new JScrollPane(pane));
        this.add("North", this.p1);
        this.add("Center", this.p2);
        this.add("South", okP);
        this.load.addActionListener(this);
        this.load.setEnabled(false);
        this.ok.addActionListener(this);
        this.setVisible(true);
        this.validate();
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok || e.getSource() instanceof DirEntry) {
            this.doSearch = true;
            this.runner = new Thread(this);
            this.runner.start();
        } else if (e.getSource() == this.load) {
            this.doSearch = false;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    @Override
    public void run() {
        if (this.doSearch) {
            this.search.setEnabled(false);
            String url = this.host.getText().trim() + this.search.getText().trim();
            this.search(url);
            this.load.setEnabled(true);
            this.search.setEnabled(true);
        } else {
            this.download((String)this.fileNames.elementAt(this.list.getSelectedIndex()));
        }
    }

    private void download(String url) {
        try {
            Log.debug("Insomniac: Download started: " + url);
            String host = url.substring(6);
            host = host.substring(0, host.indexOf("/"));
            Log.debug("Insomniac: Trying to connect to remote host: " + host);
            JFtp.statusP.jftp.ensureLogging();
            SmbConnection con = new SmbConnection(host, this.user.getText().trim(), this.pass.getText().trim(), "WORKGROUP", (ConnectionListener)((Object)JFtp.remoteDir));
            Log.debug("Insomniac: Connected, downloading to: " + Settings.defaultWorkDir);
            JFtp.statusP.jftp.ensureLogging();
            con.setLocalPath(this.dir.getText().trim());
            if (con.download(url) >= 0) {
                Log.debug("Insomniac: Finished download.");
            } else {
                Log.debug("Insomniac: Download failed.");
            }
            JFtp.statusP.jftp.ensureLogging();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Insomniac: Error: " + ex);
        }
    }

    private void search(String url) {
        this.files = new Vector();
        this.sizes = new Vector();
        this.fileNames = new Vector();
        try {
            URL u = new URL(url);
            DataInputStream in = new DataInputStream(u.openStream());
            String tmp = null;
            while (true) {
                if ((tmp = in.readLine()) == null) {
                    return;
                }
                if (tmp.indexOf("X-File") < 0) continue;
                tmp = this.parse(tmp);
                this.fileNames.add(tmp);
                DirEntry entry = new DirEntry(tmp.substring(tmp.lastIndexOf("/") + 1), this);
                entry.setFile();
                tmp = in.readLine();
                if (tmp.indexOf("X-Size") >= 0) {
                    tmp = this.parse(tmp);
                    entry.setFileSize(Long.parseLong(tmp));
                } else if (tmp == null) {
                    return;
                }
                this.files.add(entry);
                this.list.setListData(this.files);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Insomniac: Error: " + ex);
            return;
        }
    }

    private String parse(String tmp) {
        if (tmp == null) {
            return "-1";
        }
        tmp.trim();
        tmp = tmp.substring(8);
        tmp = tmp.substring(0, tmp.length() - 1);
        return tmp;
    }

    @Override
    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top + 5, in.left + 5, in.bottom + 5, in.right + 5);
    }
}

