/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.Getter;

public class FileSearch {
    private int currentDepth = 0;
    private Hashtable checked = new Hashtable();
    public static boolean quiet = true;
    public static boolean ultraquiet = false;
    String localDir = ".";
    int MAX = 999999;
    int MIN_TERM = 1;
    int MIN_FACTOR = 1;
    boolean LOAD = false;
    String[] typeArray = new String[]{""};
    String[] termArray = new String[]{""};
    String[] optArray = new String[]{""};
    String[] ignoreArray = new String[]{""};
    String[] scanArray = new String[]{""};

    public static void main(String[] argv) {
        String[] typeArray = new String[]{".gz", ".bz2", ".zip", ".rar"};
        String[] termArray = new String[]{"linux", "kernel"};
        String[] optArray = new String[]{"download", "file", "mirror", "location"};
        String[] ignoreArray = new String[]{".gif", ".jpg", ".png", ".swf", ".jar", ".class", ".google."};
        String[] scanArray = new String[]{".html", ".htm", "/", ".jsp", ".jhtml", ".phtml", ".asp", ".xml", ".js", ".cgi"};
        String url = "http://www.google.de/search?hl=de&q=";
        for (int i = 0; i < termArray.length; ++i) {
            url = url + termArray[i] + "+";
        }
        FileSearch search = new FileSearch();
        search.typeArray = typeArray;
        search.termArray = termArray;
        search.optArray = optArray;
        search.ignoreArray = ignoreArray;
        search.scanArray = scanArray;
        search.MIN_TERM = 1;
        search.spider(url);
    }

    private void spider(String url) {
        try {
            if (url.indexOf("/") < 0) {
                url = url + "/";
            }
            url = this.clear(url);
            Log.out(">>> URL: " + url);
            Log.out(">>> Scanning for ");
            for (int i = 0; i < this.typeArray.length; ++i) {
                Log.out(this.typeArray[i] + " ");
            }
            Log.out("");
            Log.out("Fetching initial HTML file...");
            Getter urlGetter = new Getter(this.localDir);
            urlGetter.fetch(url, true);
            Log.out("Searching for links...");
            LocalIO.pause(500);
            this.crawl(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String clear(String url) {
        int idx = url.indexOf("http://");
        if (idx >= 0) {
            url = url.substring(7);
        }
        return url;
    }

    private Vector addVector(Vector v, Vector x) {
        Enumeration e = x.elements();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            v.add(next);
        }
        return v;
    }

    private int rate(String content) {
        int i;
        int score = 0;
        for (i = 0; i < this.termArray.length; ++i) {
            if (content.indexOf(this.termArray[i]) < 0) continue;
            score += 3;
        }
        if (score < this.MIN_TERM) {
            return 0;
        }
        for (i = 0; i < this.optArray.length; ++i) {
            if (content.indexOf(this.optArray[i]) < 0) continue;
            ++score;
        }
        return score;
    }

    private int checkForResult(String url) {
        for (int i = 0; i < this.ignoreArray.length; ++i) {
            if (url.indexOf(this.ignoreArray[i]) < 0) continue;
            return -1;
        }
        if (!this.checkForScanableUrl(url)) {
            return -1;
        }
        return 1;
    }

    private boolean checkForScanableUrl(String url) {
        if (this.checked.containsKey(url)) {
            return false;
        }
        this.checked.put(url, "");
        if (url.indexOf("/") > 0) {
            String tmp = url.substring(0, url.indexOf("/"));
        }
        for (int i = 0; i < this.scanArray.length; ++i) {
            if (!url.endsWith(this.scanArray[i])) continue;
            return true;
        }
        return false;
    }

    private void crawl(String url) throws Exception {
        url = this.clear(url);
        int urlRating = this.checkForResult(url);
        if (!quiet) {
            Log.out("URL-Rating: " + url + " -> " + urlRating + " @" + this.currentDepth);
        }
        if (urlRating <= 0 && urlRating < 0 && this.currentDepth > 0) {
            if (!quiet) {
                Log.out("SKIP " + url);
            }
            return;
        }
        Getter urlGetter = new Getter(this.localDir);
        String content = urlGetter.fetch(url);
        int factor = this.rate(content);
        if (!quiet) {
            Log.out("Content-Rating: " + url + " -> " + factor + " @" + this.currentDepth);
        }
        if (factor < this.MIN_FACTOR) {
            if (!quiet) {
                Log.out("DROP: " + url);
            }
            return;
        }
        if (!ultraquiet) {
            Log.out("Url: " + url + " -> " + urlRating + ":" + factor + "@" + this.currentDepth);
        }
        Vector m = this.sort(content, url.substring(0, url.lastIndexOf("/")), "href=\"");
        m = this.addVector(m, this.sort(content, url.substring(0, url.lastIndexOf("/")), "src=\""));
        m = this.addVector(m, this.sort(content, url.substring(0, url.lastIndexOf("/")), "HREF=\""));
        m = this.addVector(m, this.sort(content, url.substring(0, url.lastIndexOf("/")), "SRC=\""));
        Enumeration links = m.elements();
        while (links.hasMoreElements()) {
            int x;
            String next = (String)links.nextElement();
            if (!quiet) {
                Log.out("PROCESS: " + next);
            }
            boolean skip = false;
            while (!skip) {
                for (int i = 0; i < this.typeArray.length; ++i) {
                    int x2;
                    if (!next.endsWith(this.typeArray[i]) && !this.typeArray[i].trim().equals("*")) continue;
                    Log.out("HIT: " + url + " -> " + next);
                    if (!this.LOAD || !this.checkForScanableUrl(url) || (x2 = next.indexOf("/")) <= 0 || next.substring(0, x2).indexOf(".") <= 0) continue;
                    Getter urlGetter2 = new Getter(this.localDir);
                    urlGetter2.fetch(next, false);
                }
                skip = true;
            }
            if (this.currentDepth >= this.MAX || (x = next.indexOf("/")) <= 0 || next.substring(0, x).indexOf(".") <= 0) continue;
            ++this.currentDepth;
            this.crawl(next);
            --this.currentDepth;
        }
    }

    private Vector sort(String content, String url, String index) {
        Vector<String> res = new Vector<String>();
        int wo = 0;
        while ((wo = content.indexOf(index)) >= 0) {
            content = content.substring(wo + index.length());
            String was = content.substring(0, content.indexOf("\""));
            was = this.createAbsoluteUrl(was, url);
            res.add(was);
            if (quiet) continue;
            Log.out("ADD: " + was);
        }
        return res;
    }

    private String[] check(String auswahl) {
        StringTokenizer tokenizer = new StringTokenizer(auswahl, "-", false);
        String[] strArr = new String[tokenizer.countTokens()];
        int tmp = 0;
        while (tokenizer.hasMoreElements()) {
            strArr[tmp] = (String)tokenizer.nextElement();
            ++tmp;
        }
        return strArr;
    }

    private String createAbsoluteUrl(String newLink, String baseUrl) {
        if ((newLink = this.clear(newLink)).startsWith(baseUrl)) {
            return newLink;
        }
        if (newLink.startsWith("/") && baseUrl.indexOf("/") > 0) {
            newLink = baseUrl.substring(0, baseUrl.indexOf("/")) + newLink;
        } else if (newLink.startsWith("/") && baseUrl.indexOf("/") < 0) {
            newLink = baseUrl + newLink;
        } else if (newLink.indexOf(".") > 0) {
            int idx = newLink.indexOf("/");
            String tmp = "";
            if (idx >= 0) {
                tmp = newLink.substring(0, idx);
            }
            if (tmp.indexOf(".") > 0) {
                return this.clear(newLink);
            }
            newLink = baseUrl.endsWith("/") ? baseUrl + newLink : baseUrl + "/" + newLink;
        }
        return newLink;
    }
}

