/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import com.sun.nfs.XFileExtensionAccessor;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class NfsConnection
implements BasicConnection {
    public static int buffer = 128000;
    private String url = "";
    private String host = "";
    private String path = "";
    private String pwd = "";
    private Vector listeners = new Vector();
    private String[] files;
    private String[] size = new String[0];
    private int[] perms = null;
    private String baseFile;
    private int fileCount;
    private boolean isDirUpload = false;
    private boolean shortProgress = false;
    private boolean dummy = false;

    public NfsConnection(String url) {
        this.url = url;
        this.host = url.substring(6);
        int x = this.host.indexOf("/");
        if (x >= 0) {
            this.host = this.host.substring(0, x);
        }
        Log.out("nfs host is: " + this.host);
    }

    public boolean login(String user, String pass) {
        Log.out("nfs login called: " + this.url);
        try {
            XFile xf = new XFile(this.url);
            if (xf.exists()) {
                Log.out("nfs url ok");
            } else {
                Log.out("WARNING: nfs url not found, cennection will fail!");
            }
            XFileExtensionAccessor nfsx = (XFileExtensionAccessor)xf.getExtensionAccessor();
            if (!nfsx.loginPCNFSD(this.host, user, pass)) {
                Log.out("login failed!");
                return false;
            }
            Log.debug("Login successful...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String[] getExports() throws Exception {
        XFile xf = new XFile(this.url);
        XFileExtensionAccessor nfsx = (XFileExtensionAccessor)xf.getExtensionAccessor();
        String[] tmp = nfsx.getExports();
        if (tmp == null) {
            return new String[0];
        }
        for (int i = 0; i < tmp.length; ++i) {
            Log.out("nfs export found: " + tmp[i]);
        }
        return tmp;
    }

    @Override
    public int removeFileOrDir(String file) {
        try {
            String tmp = this.toNFS(file);
            XFile f = new XFile(tmp);
            if (!f.getAbsolutePath().equals(f.getCanonicalPath())) {
                Log.debug("WARNING: Skipping symlink, remove failed.");
                Log.debug("This is necessary to prevent possible data loss when removing those symlinks.");
                return -1;
            }
            if (f.exists() && f.isDirectory()) {
                this.cleanLocalDir(tmp);
            }
            if (!f.delete()) {
                return -1;
            }
            return 1;
        }
        catch (IOException ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return -1;
        }
    }

    private void cleanLocalDir(String dir) {
        XFile f2;
        String[] tmp;
        if ((dir = this.toNFS(dir)).endsWith("\\")) {
            Log.out("need to fix \\-problem!!!");
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if ((tmp = (f2 = new XFile(dir)).list()) == null) {
            return;
        }
        for (int i = 0; i < tmp.length; ++i) {
            XFile f3 = new XFile(dir + tmp[i]);
            if (f3.isDirectory()) {
                this.cleanLocalDir(dir + tmp[i]);
                f3.delete();
                continue;
            }
            f3.delete();
        }
    }

    @Override
    public void sendRawCommand(String cmd) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getPWD() {
        String tmp = this.toNFS(this.pwd);
        if (!tmp.endsWith("/")) {
            tmp = tmp + "/";
        }
        return tmp;
    }

    @Override
    public boolean cdup() {
        String tmp = this.pwd;
        if (this.pwd.endsWith("/") && !this.pwd.equals("nfs://")) {
            tmp = this.pwd.substring(0, this.pwd.lastIndexOf("/"));
        }
        return this.chdir(tmp.substring(0, tmp.lastIndexOf("/") + 1));
    }

    @Override
    public boolean mkdir(String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        dirName = this.toNFS(dirName);
        File f = new File(dirName);
        boolean x = f.mkdir();
        this.fireDirectoryUpdate();
        return x;
    }

    @Override
    public void list() throws IOException {
    }

    @Override
    public boolean chdir(String p) {
        return this.chdir(p, true);
    }

    public boolean chdir(String p, boolean refresh) {
        if (p.endsWith("..")) {
            return this.cdup();
        }
        String tmp = this.toNFS(p);
        if (!tmp.endsWith("/")) {
            tmp = tmp + "/";
        }
        if (this.check(tmp) < 3) {
            return false;
        }
        this.pwd = tmp;
        if (refresh) {
            this.fireDirectoryUpdate();
        }
        return true;
    }

    private int check(String url) {
        int x = 0;
        for (int j = 0; j < url.length(); ++j) {
            if (url.charAt(j) != '/') continue;
            ++x;
        }
        return x;
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        return this.chdir(p, false);
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    private String toNFS(String f) {
        if (f.lastIndexOf("nfs://") > 0) {
            f = f.substring(f.lastIndexOf("nfs://"));
        }
        String file = f.startsWith("nfs://") ? f : this.getPWD() + f;
        file = file.replace('\\', '/');
        Log.out("nfs url: " + file);
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLocalPath(String p) {
        File f;
        if (!p.startsWith("/") && !p.startsWith(":", 1)) {
            p = this.path + p;
        }
        if ((f = new File(p)).exists()) {
            try {
                this.path = f.getCanonicalPath();
                this.path = this.path.replace('\\', '/');
                if (this.path.endsWith("/")) return true;
                this.path = this.path + "/";
                return true;
            }
            catch (IOException ex) {
                Log.debug("Error: can not get pathname (local)!");
                return false;
            }
        } else {
            Log.debug("(local) No such path: \"" + p + "\"");
            return false;
        }
    }

    @Override
    public String[] sortLs() {
        String dir = this.getPWD();
        if (this.check(this.toNFS(dir)) == 3) {
            try {
                this.files = this.getExports();
            }
            catch (Exception ex) {
                Log.debug("Can not list exports:" + ex.toString());
                ex.printStackTrace();
            }
        } else {
            XFile f = new XFile(dir);
            this.files = f.list();
        }
        if (this.files == null) {
            return new String[0];
        }
        this.size = new String[this.files.length];
        this.perms = new int[this.files.length];
        int accessible = 0;
        for (int i = 0; i < this.files.length; ++i) {
            XFile f2 = new XFile(dir + this.files[i]);
            if (f2.isDirectory() && !this.files[i].endsWith("/")) {
                this.files[i] = this.files[i] + "/";
            }
            this.size[i] = "" + f2.length();
            accessible = f2.canWrite() ? 42 : (f2.canRead() ? 23 : -666);
            this.perms[i] = accessible;
        }
        return this.files;
    }

    @Override
    public String[] sortSize() {
        return this.size;
    }

    @Override
    public int[] getPermissions() {
        return this.perms;
    }

    @Override
    public int handleUpload(String f) {
        this.upload(f);
        return 0;
    }

    @Override
    public int handleDownload(String f) {
        this.download(f);
        return 0;
    }

    @Override
    public int upload(String f) {
        String file = this.toNFS(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.uploadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(this.getLocalPath() + outfile, file);
            this.fireActionFinished(this);
        }
        return 0;
    }

    @Override
    public int download(String f) {
        String file = this.toNFS(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.downloadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(file, this.getLocalPath() + outfile);
            this.fireActionFinished(this);
        }
        return 0;
    }

    private void downloadDir(String dir, String out) {
        try {
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            XFile f2 = new XFile(dir);
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            File fx = new File(out);
            fx.mkdir();
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].replace('\\', '/');
                XFile f3 = new XFile(dir + tmp[i]);
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.downloadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DGET:" + this.fileCount, -1);
                this.work(dir + tmp[i], out + tmp[i]);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.shortProgress = false;
    }

    private void uploadDir(String dir, String out) {
        try {
            this.isDirUpload = true;
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            File f2 = new File(out);
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            XFile fx = new XFile(dir);
            fx.mkdir();
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].replace('\\', '/');
                File f3 = new File(out + tmp[i]);
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.uploadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DPUT:" + this.fileCount, -1);
                this.work(out + tmp[i], dir + tmp[i]);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.isDirUpload = false;
        this.shortProgress = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file, String outfile) {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            boolean outflag = false;
            if (outfile.startsWith("nfs://")) {
                outflag = true;
                out = new BufferedOutputStream(new XFileOutputStream(outfile));
            } else {
                out = new BufferedOutputStream(new FileOutputStream(outfile));
            }
            in = file.startsWith("nfs://") ? new BufferedInputStream(new XFileInputStream(file)) : new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[buffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                reallen += len;
                if (outflag) {
                    this.fireProgressUpdate(StringUtils.getFile(outfile), "PUT", reallen);
                    continue;
                }
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void update(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            listener.updateProgress(file, type, bytes);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
    }

    public void setConnectionListeners(Vector l) {
        this.listeners = l;
    }

    public void fireDirectoryUpdate() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).updateRemoteDirectory(this);
        }
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                    continue;
                }
                if (this.isDirUpload) {
                    listener.updateProgress(this.baseFile, "DPUT:" + this.fileCount, bytes);
                    continue;
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    public void fireActionFinished(NfsConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).actionFinished(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String file, InputStream i) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            file = this.toNFS(file);
            out = new BufferedOutputStream(new XFileOutputStream(file));
            in = new BufferedInputStream(i);
            byte[] buf = new byte[buffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "PUT", reallen += len);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
            int n = -1;
            return n;
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        file = this.toNFS(file);
        Log.debug(file);
        try {
            return new BufferedInputStream(new XFileInputStream(file));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @NfsConnection::getDownloadInputStream");
            return null;
        }
    }

    @Override
    public Date[] sortDates() {
        return null;
    }

    @Override
    public boolean rename(String from, String to) {
        Log.debug("Not implemented!");
        return false;
    }
}

