/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.hostchooser;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import jcifs.Config;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HInsetPanel;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.net.wrappers.StartConnection;
import net.sf.jftp.system.logging.Log;

public class SmbHostChooser
extends HFrame
implements ActionListener,
WindowListener {
    public static HTextField host = new HTextField("URL:", "smb://localhost/");
    public static HTextField user = new HTextField("Username:", "guest");
    public static HPasswordField pass = new HPasswordField("Password:", "nopasswd");
    JCheckBox lan = new JCheckBox("Browse LAN", true);
    public HTextField domain = new HTextField("Domain:    ", "WORKGROUP");
    public HTextField broadcast = new HTextField("Broadcast IP:    ", "AUTO");
    public HTextField wins = new HTextField("WINS Server IP:    ", "NONE");
    public JComboBox ip = new JComboBox();
    private HPanel okP = new HPanel();
    private HButton ok = new HButton("Connect");
    private ComponentListener listener = null;
    private boolean useLocal = false;

    public SmbHostChooser(ComponentListener l, boolean local) {
        this.listener = l;
        this.useLocal = local;
        this.init();
    }

    public SmbHostChooser(ComponentListener l) {
        this.listener = l;
        this.init();
    }

    public SmbHostChooser() {
        this.init();
    }

    public void init() {
        this.setLocation(100, 150);
        this.setTitle("Smb Connection...");
        this.setBackground(this.okP.getBackground());
        try {
            File f = new File(Settings.appHomeDir);
            f.mkdir();
            File f1 = new File(Settings.login);
            f1.createNewFile();
            File f2 = new File(Settings.login_def_smb);
            f2.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String[] login = LoadSet.loadSet(Settings.login_def_smb);
        if (login[0] != null && login.length > 1) {
            host.setText(login[0]);
            user.setText(login[1]);
            this.domain.setText(login[5]);
        }
        if (Settings.getStorePasswords()) {
            if (login != null && login.length > 2 && login[2] != null) {
                pass.setText(login[2]);
            }
        } else {
            pass.setText("");
        }
        this.ip.setEditable(true);
        HInsetPanel root = new HInsetPanel();
        root.setLayout(new GridLayout(5, 2, 5, 3));
        root.add(host);
        root.add(this.lan);
        root.add(user);
        root.add(pass);
        root.add(this.ip);
        root.add(this.domain);
        root.add(this.broadcast);
        root.add(this.okP);
        root.add(this.wins);
        JTextArea t = new JTextArea();
        t.setLineWrap(true);
        t.setText("Note: URL is in form \"smb://host/\"\nand most people do not need WINS.");
        root.add(t);
        this.okP.add(this.ok);
        this.ok.addActionListener(this);
        host.setEnabled(!this.lan.isSelected());
        this.setDefaultCloseOperation(0);
        this.lan.addActionListener(this);
        SmbHostChooser.pass.text.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add("Center", root);
        this.setModal(false);
        this.setVisible(false);
        this.addWindowListener(this);
        this.ip.addItem("<default>");
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> f = e.nextElement().getInetAddresses();
                while (f.hasMoreElements()) {
                    this.ip.addItem(f.nextElement().getHostAddress());
                }
            }
        }
        catch (Exception ex) {
            Log.debug("Error determining default network interface: " + ex);
        }
        this.domain.setEnabled(false);
        this.broadcast.setEnabled(false);
        this.wins.setEnabled(false);
        this.ip.addActionListener(this);
        this.pack();
        this.setVisible(true);
    }

    private void setBCast() {
        try {
            String tmp = ((String)this.ip.getSelectedItem()).trim();
            String x = tmp.substring(0, tmp.lastIndexOf(".") + 1) + "255";
            this.broadcast.setText(x);
        }
        catch (Exception ex) {
            Log.out("Error (SMBHostChooser): " + ex);
        }
    }

    public void update() {
        this.fixLocation();
        this.setVisible(true);
        this.toFront();
        host.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.lan) {
            host.setEnabled(!this.lan.isSelected());
        } else if (e.getSource() == this.ip) {
            if (this.ip.getSelectedItem().equals("<default>")) {
                this.domain.setEnabled(false);
                this.broadcast.setEnabled(false);
                this.wins.setEnabled(false);
            } else {
                this.domain.setEnabled(true);
                this.broadcast.setEnabled(true);
                this.wins.setEnabled(true);
                this.setBCast();
            }
        } else if (e.getSource() == this.ok || e.getSource() == SmbHostChooser.pass.text) {
            this.setCursor(new Cursor(3));
            Object con = null;
            String tmp = ((String)this.ip.getSelectedItem()).trim();
            if (!tmp.equals("") && !tmp.equals("<default>")) {
                String x = tmp.trim().substring(0, tmp.lastIndexOf(".") + 1) + "255";
                String bcast = this.broadcast.getText().trim();
                if (!bcast.equals("AUTO")) {
                    x = bcast;
                }
                Log.debug("Setting LAN interface to: " + tmp + "/" + x);
                Config.setProperty("jcifs.netbios.laddr", tmp);
                Config.setProperty("jcifs.smb.client.laddr", tmp);
                Config.setProperty("jcifs.netbios.baddr", x);
                String y = this.wins.getText().trim();
                if (!y.equals("NONE")) {
                    Log.debug("Setting WINS server IP to: " + y);
                    Config.setProperty("jcifs.netbios.wins", y);
                }
            }
            String htmp = host.getText().trim();
            String utmp = user.getText().trim();
            String ptmp = pass.getText();
            String dtmp = this.domain.getText().trim();
            if (dtmp.equals("")) {
                dtmp = "NONE";
            }
            if (this.lan.isSelected()) {
                htmp = "(LAN)";
            }
            SaveSet s = new SaveSet(Settings.login_def_smb, htmp, utmp, ptmp, "", "", dtmp);
            int potmp = 0;
            boolean status = StartConnection.startCon("SMB", htmp, utmp, ptmp, potmp, dtmp, this.useLocal);
            this.setCursor(new Cursor(0));
            this.dispose();
            JFtp.mainFrame.setVisible(true);
            JFtp.mainFrame.toFront();
            if (this.listener != null) {
                this.listener.componentResized(new ComponentEvent(this, 0));
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

