/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.AppMenuBar;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.base.dir.DirPanel;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.ProgressBarList;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.DataConnection;
import net.sf.jftp.net.Transfer;
import net.sf.jftp.net.wrappers.HttpTransfer;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.UpdateDaemon;
import net.sf.jftp.system.logging.Log;

public class DownloadList
extends HPanel
implements ActionListener {
    public Hashtable sizeCache = new Hashtable();
    private ProgressBarList list = new ProgressBarList();
    private Hashtable downloads = new Hashtable();
    private long oldtime = 0L;
    private HImageButton resume = new HImageButton(Settings.resumeImage, "resume", "Resume selected transfer...", this);
    private HImageButton pause = new HImageButton(Settings.pauseImage, "pause", "Pause selected transfer...", this);
    private HImageButton cancel = new HImageButton(Settings.deleteImage, "delete", "Cancel selected transfer...", this);
    private HImageButton clear = new HImageButton(Settings.clearImage, "clear", "Remove old/stalled items from output...", this);

    public DownloadList() {
        this.setLayout(new BorderLayout());
        this.resume.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.resumeImage2)));
        this.resume.setRolloverEnabled(true);
        this.pause.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.pauseImage2)));
        this.pause.setRolloverEnabled(true);
        this.clear.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.clearImage2)));
        this.clear.setRolloverEnabled(true);
        this.cancel.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.deleteImage2)));
        this.cancel.setRolloverEnabled(true);
        HPanel cmdP = new HPanel();
        cmdP.add(this.clear);
        cmdP.add(new JLabel("   "));
        cmdP.add(this.resume);
        cmdP.add(this.pause);
        cmdP.add(new JLabel("   "));
        cmdP.add(this.cancel);
        this.clear.setSize(24, 24);
        this.clear.setBorder(true);
        this.cancel.setSize(24, 24);
        this.cancel.setBorder(true);
        this.resume.setSize(24, 24);
        this.resume.setBorder(true);
        this.pause.setSize(24, 24);
        this.pause.setBorder(true);
        this.clear.setToolTipText("Remove old/stalled items from output...");
        this.resume.setToolTipText("Resume selected transfer...");
        this.pause.setToolTipText("Pause selected transfer...");
        this.cancel.setToolTipText("Cancel selected transfer...");
        JScrollPane dP = new JScrollPane(this.list);
        this.add("South", cmdP);
        this.add("Center", dP);
    }

    public void fresh() {
        this.downloads = new Hashtable();
        this.updateArea();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            this.deleteCon();
        } else if (e.getActionCommand().equals("clear") || e.getSource() == AppMenuBar.clearItems) {
            this.fresh();
        } else if (e.getActionCommand().equals("pause")) {
            this.pauseCon();
        } else if (e.getActionCommand().equals("resume")) {
            this.resumeCon();
        }
    }

    private void deleteCon() {
        block10: {
            try {
                String cmd = this.getActiveItem();
                if (cmd == null) {
                    return;
                }
                if (cmd.indexOf("QUEUED") >= 0 || cmd.indexOf("STOPPED") >= 0) {
                    cmd = this.getFile(cmd);
                    try {
                        Transfer d = JFtp.getConnectionHandler().getConnections().get(cmd);
                        if (d == null) {
                            return;
                        }
                        d.work = false;
                        d.pause = false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break block10;
                }
                cmd = this.getFile(cmd);
                ConnectionHandler h = JFtp.getConnectionHandler();
                Transfer o = h.getConnections().get(cmd);
                Log.out("aborting  transfer: " + cmd);
                Log.out("connection handler present: " + h + ", pool size: " + h.getConnections().size());
                if (o instanceof HttpTransfer) {
                    Transfer d = o;
                    d.work = false;
                    this.updateList(cmd, "FAILED", -1L, -1L);
                    return;
                }
                Transfer d = o;
                DataConnection con = d.getDataConnection();
                con.getCon().work = false;
                try {
                    con.sock.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                LocalIO.pause(500);
                this.updateList(this.getRawFile(this.getActiveItem()), "FAILED", -1L, -1L);
            }
            catch (Exception ex) {
                Log.debug("Action is not supported for this connection.");
                ex.printStackTrace();
            }
        }
    }

    private void pauseCon() {
        block6: {
            try {
                String cmd = this.getActiveItem();
                if (cmd == null) {
                    return;
                }
                if (cmd.indexOf("GET") < 0 && cmd.indexOf("PUT") < 0) break block6;
                cmd = this.getFile(cmd);
                Transfer o = JFtp.getConnectionHandler().getConnections().get(cmd);
                if (o == null) {
                    return;
                }
                Transfer d = o;
                d.pause = true;
                DataConnection con = d.getDataConnection();
                try {
                    con.sock.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                d.prepare();
            }
            catch (Exception ex) {
                Log.debug("Action is not supported for this connection.");
            }
        }
    }

    private void resumeCon() {
        try {
            String cmd = this.getActiveItem();
            if (cmd == null) {
                return;
            }
            if (cmd.indexOf("STOPPED") >= 0 || cmd.indexOf("QUEUED") >= 0) {
                cmd = this.getFile(cmd);
                try {
                    Transfer o = JFtp.getConnectionHandler().getConnections().get(cmd);
                    if (o == null) {
                        return;
                    }
                    Transfer d = o;
                    d.work = true;
                    d.pause = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            Log.debug("Action is not supported for this connection.");
        }
    }

    private String getActiveItem() {
        String tmp = this.list.getSelectedValue().getDirEntry().toString();
        if (tmp == null) {
            return "";
        }
        return tmp;
    }

    public synchronized void updateList(String file, String type, long bytes, long size) {
        long s;
        String tmp;
        String message = type + ": <" + file + "> ";
        if (!(this.safeUpdate() || type.startsWith("DFINISHED") || type.startsWith("FINISHED") || type.startsWith("FAILED") || type.startsWith("STOPPED") || type.startsWith("REMOVED"))) {
            return;
        }
        int count = 0;
        if (type.startsWith("DGET") || type.startsWith("DPUT") || type.startsWith("DPUT") || type.startsWith("DFINISHED")) {
            tmp = type.substring(type.indexOf(":") + 1);
            type = type.substring(0, type.indexOf(":"));
            count = Integer.parseInt(tmp);
            message = type + ": <" + file + "> ";
        }
        if (type.equals("GET")) {
            DirEntry[] e = ((DirPanel)JFtp.remoteDir).dirEntry;
            for (int i = 0; i < e.length; ++i) {
                if (!e[i].file.equals(file)) continue;
                size = e[i].getRawSize();
            }
        }
        tmp = (s = size / 1024L) > 0L ? Long.toString(s) : "?";
        if (type.equals("GET") || type.equals("PUT")) {
            message = message + bytes / 1024L + " / " + tmp + " kb";
            this.list.setTransferred(file, bytes / 1024L, message, s);
        } else if (type.equals("DGET") || type.equals("DPUT")) {
            message = message + bytes / 1024L + " kb of file #" + count;
            this.list.setTransferred(file, bytes / 1024L, message, -1L);
        } else if (type.startsWith("DFINISHED")) {
            message = message + " " + count + " files.";
        }
        if (type.equals("FINISHED") || type.startsWith("DFINISHED")) {
            try {
                JFtp.getConnectionHandler().removeConnection(file);
            }
            catch (Exception ex) {
                // empty catch block
            }
            UpdateDaemon.updateCall();
        } else if (type.equals("FAILED")) {
            UpdateDaemon.updateCall();
        }
        DirEntry d = null;
        if (this.downloads.containsKey(message)) {
            d = (DirEntry)this.downloads.get(message);
        } else {
            d = new DirEntry(message, null);
            d.setNoRender();
            if (this.getFile(tmp).endsWith("/")) {
                d.setDirectory();
            }
            d.setFileSize(size);
        }
        d.setTransferred(bytes);
        this.downloads.put(file, d);
        this.updateArea();
    }

    private synchronized DirEntry[] toArray() {
        DirEntry[] f = new DirEntry[this.downloads.size()];
        int i = 0;
        Enumeration k = this.downloads.elements();
        while (k.hasMoreElements()) {
            Object o = k.nextElement();
            if (o instanceof DirEntry) {
                f[i] = (DirEntry)o;
            } else {
                String tmp = (String)o;
                DirEntry d = new DirEntry(tmp, null);
                if (this.getFile(tmp).endsWith("/")) {
                    d.setDirectory();
                }
                d.setNoRender();
                f[i] = d;
            }
            ++i;
        }
        return f;
    }

    private synchronized void updateArea() {
        int idx = this.list.getSelectedIndex();
        DirEntry[] f = this.toArray();
        this.list.setListData(f);
        if (f.length == 1 && idx < 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedIndex(idx);
        }
        this.list.revalidate();
        this.list.repaint();
    }

    private String getFile(String msg) {
        String f = msg;
        if (msg.indexOf("<") >= 0 && msg.indexOf(">") >= 0) {
            f = msg.substring(msg.indexOf("<") + 1);
            f = f.substring(0, f.lastIndexOf(">"));
        }
        return this.getRealName(f);
    }

    private String getRealName(String file) {
        try {
            Enumeration<String> e = JFtp.getConnectionHandler().getConnections().keys();
            while (e.hasMoreElements()) {
                String tmp = e.nextElement();
                if (!tmp.endsWith(file)) continue;
                return tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    private String getRawFile(String msg) {
        String f = msg.substring(msg.indexOf("<") + 1);
        f = f.substring(0, f.lastIndexOf(">"));
        return f;
    }

    private boolean safeUpdate() {
        long time = System.currentTimeMillis();
        if (time - this.oldtime < (long)Settings.refreshDelay) {
            return false;
        }
        this.oldtime = time;
        return true;
    }
}

