/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFileAccessor;
import com.sun.xfile.XFileExtensionAccessor;
import com.sun.xfile.XFilenameFilter;
import com.sun.xfile.XFurl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XFile {
    private XFileAccessor xfa;
    private XFurl url;
    private String urlStr;
    private File nativeFile;
    private boolean bound;
    static Hashtable cachedAccessors = new Hashtable();
    static Hashtable cachedExtensionAccessors = new Hashtable();

    public XFile(XFile xFile, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.url = new XFurl(string);
            this.xfa = this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            if (string.startsWith(".:")) {
                string = string.substring(2);
                xFile = null;
            }
            if (xFile == null) {
                this.nativeFile = new File(string);
                this.xfa = this.makeNative(this.nativeFile);
            }
            if (xFile.nativeFile != null) {
                this.nativeFile = new File(string).isAbsolute() ? new File(string) : new File(xFile.nativeFile, string);
                this.xfa = this.makeNative(this.nativeFile);
            }
            try {
                this.url = new XFurl(xFile.getURL(), string);
                this.xfa = this.loadAccessor(this.url);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + xFile.getURL() + " " + string);
            }
        }
        this.urlStr = this.url.toString();
    }

    public XFile(String string) {
        this.urlStr = string;
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.url = new XFurl(string);
            this.xfa = this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            if (string.startsWith(".:")) {
                string = string.substring(2);
            }
            this.nativeFile = new File(string);
            this.xfa = this.makeNative(this.nativeFile);
        }
    }

    private boolean bind() {
        if (this.bound) {
            return true;
        }
        this.bound = this.xfa.open(this, false, false);
        return this.bound;
    }

    public boolean canRead() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canRead();
    }

    public boolean canWrite() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.canWrite();
    }

    public boolean delete() {
        if (!this.bind()) {
            return false;
        }
        boolean bl = this.xfa.delete();
        this.bound = bl ^ true;
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XFile)) {
            return false;
        }
        return this.url.toString().equals(((XFile)object).getURL().toString());
    }

    public boolean exists() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.exists();
    }

    public String getAbsolutePath() {
        if (this.nativeFile != null) {
            return this.nativeFile.getAbsolutePath();
        }
        return this.urlStr;
    }

    private XFileAccessor getAccessor() {
        return this.xfa;
    }

    private boolean getBound() {
        return this.bound;
    }

    public String getCanonicalPath() throws IOException {
        if (this.nativeFile != null) {
            return this.nativeFile.getCanonicalPath();
        }
        return this.urlStr;
    }

    public XFileExtensionAccessor getExtensionAccessor() {
        try {
            String string = this.url.getProtocol().equals("nfs") ? "nfsXFileExtensionAccessor" : "XFileExtensionAccessor";
            Class clazz = this.loadClass(this.url.getProtocol(), string, cachedExtensionAccessors);
            Constructor constructor = clazz.getConstructor(this.getClass());
            return (XFileExtensionAccessor)constructor.newInstance(this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileSystemName() {
        return this.url.getProtocol();
    }

    public String getName() {
        if (this.nativeFile != null) {
            return this.nativeFile.getName();
        }
        return this.url.getName();
    }

    private File getNative() {
        return this.nativeFile;
    }

    public String getParent() {
        if (this.nativeFile != null) {
            return this.nativeFile.getParent();
        }
        return this.url.getParent();
    }

    public String getPath() {
        if (this.nativeFile != null) {
            return this.nativeFile.getPath();
        }
        return this.url.getPath();
    }

    private XFurl getURL() {
        return this.url;
    }

    public int hashCode() {
        return this.urlStr.hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        if (this.nativeFile != null) {
            return this.nativeFile.isAbsolute();
        }
        return true;
    }

    public boolean isDirectory() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.isDirectory();
    }

    public boolean isFile() {
        if (!this.bind()) {
            return false;
        }
        return this.xfa.isFile();
    }

    public long lastModified() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.lastModified();
    }

    public long length() {
        if (!this.bind()) {
            return 0L;
        }
        return this.xfa.exists() ? this.xfa.length() : 0L;
    }

    public String[] list() {
        if (!this.bind()) {
            return null;
        }
        return this.xfa.list();
    }

    public String[] list(XFilenameFilter xFilenameFilter) {
        if (!this.bind()) {
            return null;
        }
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (xFilenameFilter == null || xFilenameFilter.accept(this, stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private XFileAccessor loadAccessor(XFurl xFurl) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = this.loadClass(xFurl.getProtocol(), "XFileAccessor", cachedAccessors);
        if (clazz == null) {
            return null;
        }
        return (XFileAccessor)clazz.newInstance();
    }

    private Class loadClass(String string, String string2, Hashtable hashtable) throws ClassNotFoundException, IllegalAccessException {
        Class<?> clazz = (Class<?>)hashtable.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string3 = System.getProperty("java.protocol.xfile");
        string3 = string3 == null ? "" : String.valueOf(string3) + "|";
        string3 = String.valueOf(string3) + "com.sun";
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (clazz == null && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            String string5 = String.valueOf(string4) + "." + string + "." + string2;
            try {
                clazz = Class.forName(string5);
            }
            catch (Exception exception) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        hashtable.put(string, clazz);
        return clazz;
    }

    private XFileAccessor makeNative(File file) {
        char c = File.separatorChar;
        try {
            this.url = new XFurl("file:///" + file.getPath().replace(c, '/'));
            return this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            System.out.println("Error: makenative:" + file.getPath());
            return null;
        }
    }

    public boolean mkdir() {
        this.bind();
        return this.xfa.mkdir();
    }

    public boolean mkdirs() {
        this.bind();
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        String string = this.getParent();
        return string != null && new XFile(string).mkdirs() && this.mkdir();
    }

    protected XFileAccessor newAccessor() {
        try {
            return this.loadAccessor(this.url);
        }
        catch (Exception exception) {
            return this.makeNative(this.nativeFile);
        }
    }

    public boolean renameTo(XFile xFile) {
        if (xFile == null) {
            throw new NullPointerException();
        }
        if (!this.xfa.getClass().isInstance(xFile.getAccessor())) {
            return false;
        }
        if (!this.bind()) {
            return false;
        }
        boolean bl = this.xfa.renameTo(xFile);
        if (bl) {
            this.url = xFile.getURL();
            this.urlStr = xFile.getAbsolutePath();
            this.nativeFile = xFile.getNative();
            this.xfa = xFile.getAccessor();
            this.bound = xFile.getBound();
        }
        return bl;
    }

    public String toString() {
        if (this.nativeFile != null) {
            return this.nativeFile.toString();
        }
        return this.urlStr;
    }
}

