/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.keygen;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KeygenPanel
extends JPanel
implements DocumentListener,
ActionListener {
    public static final int GENERATE_KEY_PAIR = 0;
    public static final int CONVERT_IETF_SECSH_TO_OPENSSH = 1;
    public static final int CONVERT_OPENSSH_TO_IETF_SECSH = 2;
    public static final int CHANGE_PASSPHRASE = 3;
    private JButton browseInput;
    private JButton browseOutput;
    private JComboBox action;
    private JComboBox type;
    private JLabel bitsLabel;
    private JLabel inputFileLabel;
    private JLabel newPassphraseLabel;
    private JLabel oldPassphraseLabel;
    private JLabel outputFileLabel;
    private JLabel typeLabel;
    private JPasswordField newPassphrase;
    private JPasswordField oldPassphrase;
    private JProgressBar strength;
    private XTextField inputFile;
    private XTextField outputFile;
    private NumericTextField bits;

    public KeygenPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Key"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Insets insets = new Insets(0, 2, 4, 2);
        Insets insets2 = new Insets(0, 26, 4, 2);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel("Action"), (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.weightx = 1.0;
        this.action = new JComboBox<String>(new String[]{"Generate key pair", "Convert IETF SECSH to OpenSSH", "Convert OpenSSH to IETF SECSH", "Change passphrase"});
        this.action.addActionListener(this);
        gridBagConstraints.weightx = 2.0;
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.action, (GridBagConstraints)gridBagConstraints, (int)-1);
        gridBagConstraints.weightx = 0.0;
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel(), (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.inputFileLabel = new JLabel("Input File");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.inputFileLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.inputFile = new XTextField(20);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.inputFile, (GridBagConstraints)gridBagConstraints, (int)-1);
        this.inputFileLabel.setLabelFor((Component)this.inputFile);
        gridBagConstraints.weightx = 0.0;
        this.browseInput = new JButton("Browse");
        this.browseInput.setMnemonic('b');
        this.browseInput.addActionListener(this);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.browseInput, (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.outputFileLabel = new JLabel("Output File");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.outputFileLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.outputFile = new XTextField(20);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.outputFile, (GridBagConstraints)gridBagConstraints, (int)-1);
        gridBagConstraints.weightx = 0.0;
        this.outputFileLabel.setLabelFor((Component)this.outputFile);
        this.browseOutput = new JButton("Browse");
        this.browseOutput.setMnemonic('r');
        this.browseOutput.addActionListener(this);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.browseOutput, (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.oldPassphraseLabel = new JLabel("Old Passphrase");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.oldPassphraseLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 2.0;
        this.oldPassphrase = new JPasswordField(20);
        this.oldPassphrase.setBackground(Color.white);
        this.oldPassphrase.getDocument().addDocumentListener(this);
        this.oldPassphraseLabel.setLabelFor(this.oldPassphrase);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.oldPassphrase, (GridBagConstraints)gridBagConstraints, (int)-1);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel(), (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.newPassphraseLabel = new JLabel("New Passphrase");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.newPassphraseLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 2.0;
        this.newPassphrase = new JPasswordField(20);
        this.newPassphrase.setBackground(Color.white);
        this.newPassphrase.getDocument().addDocumentListener(this);
        this.newPassphraseLabel.setLabelFor(this.newPassphrase);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.newPassphrase, (GridBagConstraints)gridBagConstraints, (int)-1);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel(), (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.bitsLabel = new JLabel("Bits");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.bitsLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = insets;
        this.bits = new NumericTextField((Number)new Integer(512), (Number)new Integer(1024), (Number)new Integer(1024));
        this.bitsLabel.setLabelFor((Component)this.bits);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.bits, (GridBagConstraints)gridBagConstraints, (int)-1);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel(), (GridBagConstraints)gridBagConstraints, (int)0);
        gridBagConstraints.insets = insets2;
        this.typeLabel = new JLabel("Type");
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.typeLabel, (GridBagConstraints)gridBagConstraints, (int)1);
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 2.0;
        this.type = new JComboBox<String>(new String[]{"DSA", "RSA"});
        this.type.setFont(this.inputFile.getFont());
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.type, (GridBagConstraints)gridBagConstraints, (int)-1);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)new JLabel(), (GridBagConstraints)gridBagConstraints, (int)0);
        this.strength = new JProgressBar(0, 40);
        this.strength.setStringPainted(true);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Passphrase strength"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel2.add(this.strength);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.calculateStrength();
        this.setAvailableActions();
    }

    public int getAction() {
        return this.action.getSelectedIndex();
    }

    public int getBits() {
        return (Integer)this.bits.getValue();
    }

    public String getInputFilename() {
        return this.inputFile.getText();
    }

    public char[] getNewPassphrase() {
        return this.newPassphrase.getPassword();
    }

    public char[] getOldPassphrase() {
        return this.oldPassphrase.getPassword();
    }

    public String getOutputFilename() {
        return this.outputFile.getText();
    }

    public String getType() {
        return (String)this.type.getSelectedItem();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseOutput) {
            File file = new File(this.outputFile.getText());
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle("Choose output file ..");
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showSaveDialog(this) == 0) {
                this.outputFile.setText(jFileChooser.getSelectedFile().getPath());
            }
        } else if (actionEvent.getSource() == this.browseInput) {
            File file = new File(this.inputFile.getText());
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle("Choose input file ..");
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showOpenDialog(this) == 0) {
                this.inputFile.setText(jFileChooser.getSelectedFile().getPath());
            }
        } else {
            this.setAvailableActions();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.calculateStrength();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.calculateStrength();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.calculateStrength();
    }

    private void setAvailableActions() {
        this.inputFile.setEnabled(this.getAction() == 1 || this.getAction() == 2 || this.getAction() == 3);
        this.inputFileLabel.setEnabled(this.inputFile.isEnabled());
        this.browseInput.setEnabled(this.inputFile.isEnabled());
        this.bits.setEnabled(this.getAction() == 0);
        this.bitsLabel.setEnabled(this.bits.isEnabled());
        this.outputFile.setEnabled(this.getAction() == 1 || this.getAction() == 2 || this.getAction() == 0);
        this.outputFileLabel.setEnabled(this.outputFile.isEnabled());
        this.browseOutput.setEnabled(this.outputFile.isEnabled());
        this.newPassphrase.setEnabled(this.getAction() == 0 || this.getAction() == 3);
        this.newPassphraseLabel.setEnabled(this.newPassphrase.isEnabled());
        this.oldPassphrase.setEnabled(this.getAction() == 3);
        this.oldPassphraseLabel.setEnabled(this.oldPassphrase.isEnabled());
        this.type.setEnabled(this.getAction() == 0);
        this.typeLabel.setEnabled(this.type.isEnabled());
        if (this.inputFile.isEnabled()) {
            this.inputFile.requestFocus();
        } else {
            this.outputFile.requestFocus();
        }
    }

    private void calculateStrength() {
        String string;
        Color color;
        char[] cArray = this.newPassphrase.getPassword();
        this.strength.setValue(cArray.length < 40 ? cArray.length : 40);
        if (cArray.length == 0) {
            color = Color.red;
            string = "Empty!!";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray.length);
            stringBuffer.append(" characters - ");
            if (cArray.length < 10) {
                color = Color.red;
                stringBuffer.append("Weak!");
            } else if (cArray.length < 20) {
                color = Color.orange;
                stringBuffer.append("Ok");
            } else if (cArray.length < 30) {
                color = Color.green.darker();
                stringBuffer.append("Strong");
            } else {
                color = Color.green;
                stringBuffer.append("Very strong!");
            }
            string = stringBuffer.toString();
        }
        this.strength.setString(string);
        this.strength.setForeground(color);
    }
}

