/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PassphraseDialog
extends JDialog {
    static final String PASSPHRASE_ICON = "/com/sshtools/common/authentication/largepassphrase.png";
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    JLabel message = new JLabel("Enter passphrase");
    JPasswordField jPasswordField = new JPasswordField(20);
    boolean userCancelled = false;

    public PassphraseDialog() {
        super((Frame)null, "Passphrase", true);
        this.init(null);
    }

    public PassphraseDialog(Frame frame) {
        super(frame, "Passphrase", true);
        this.init(frame);
    }

    public PassphraseDialog(Frame frame, String string) {
        super(frame, "Passphrase", true);
        this.init(frame);
        this.setTitle(string + " - Identity");
    }

    public PassphraseDialog(Dialog dialog) {
        super(dialog, "Passphrase", true);
        this.init(dialog);
    }

    public boolean isCancelled() {
        return this.userCancelled;
    }

    public void setMessage(String string) {
        this.message.setText(string);
    }

    public void setMessageForeground(Color color) {
        this.message.setForeground(color);
    }

    public char[] getPassphrase() {
        return this.jPasswordField.getPassword();
    }

    void init(Window window) {
        this.getContentPane().setLayout(new GridLayout(1, 1));
        if (window != null) {
            this.setLocationRelativeTo(window);
        }
        try {
            this.jbInit();
            this.pack();
            UIUtil.positionComponent((int)0, (Component)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.userCancelled = true;
        this.hide();
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        this.userCancelled = false;
        this.hide();
    }

    void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PassphraseDialog.this.userCancelled = true;
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PassphraseDialog.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PassphraseDialog.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.message, (GridBagConstraints)gridBagConstraints, (int)0);
        UIUtil.jGridBagAdd((JComponent)jPanel, (Component)this.jPasswordField, (GridBagConstraints)gridBagConstraints, (int)0);
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel((Icon)new ResourceIcon(PASSPHRASE_ICON), (Component)jPanel);
        iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weighty = 1.0;
        UIUtil.jGridBagAdd((JComponent)jPanel2, (Component)this.jButtonOK, (GridBagConstraints)gridBagConstraints, (int)-1);
        UIUtil.jGridBagAdd((JComponent)jPanel2, (Component)this.jButtonCancel, (GridBagConstraints)gridBagConstraints, (int)0);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel4.add((Component)iconWrapperPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel4);
        this.jPasswordField.grabFocus();
    }
}

