/*
  Jar Jar Links - A utility to repackage and embed Java libraries
  Copyright (C) 2004  Tonic Systems, Inc.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  if not, write to
  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA 02111-1307 USA
*/

package com.tonicsystems.jarjar;

import java.util.*;

abstract public class PatternElement
{
    private String pattern;
    
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return pattern;
    }

    static Wildcard[] createWildcards(List patterns) {
        Wildcard[] wildcards = new Wildcard[patterns.size()];
        int i = 0;
        for (Iterator it = patterns.iterator(); it.hasNext();) {
            PatternElement pattern = (PatternElement)it.next();
            String result = (pattern instanceof Rule) ? ((Rule)pattern).getResult() : "";
            String expr = pattern.getPattern();
            if (expr.indexOf('/') >= 0)
                throw new IllegalArgumentException("Patterns cannot contain slashes");
            wildcards[i++] = new Wildcard(expr.replace('.', '/'), result);
        }
        return wildcards;
    }
}
