#ifndef CONJUGATE_FACTORY_H_
#define CONJUGATE_FACTORY_H_

#include "ConjugateSampler.h"

#include <sampler/SingletonFactory.h>
#include <map>
#include <string>
class StochasticNode;


/**
 * @short Factory object for conjugate samplers
 */
class ConjugateFactory : public SingletonFactory
{
    std::map<std::string, bool (*)(StochasticNode *,
					 Graph const &)> _func_table;
public:
    ConjugateFactory();
    /**
     * Provides a simple interface to the canSample member functions of
     * the various conjugate samplers.  The distribution of snode is found
     * and, if it has an associated conjugate sampler, the appropriate
     * canSample member function is dispatched
     */
    bool canSample(StochasticNode *snode, Graph const &graph) const;
    /**
     * Creates a ConjugateSampler for a stochastic node. 
     */
    Sampler *makeSingletonSampler(StochasticNode *snode, Graph const &graph)
                                  const;
};

#endif /* CONJUGATE_FACTORY_H_ */
