/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_autoshutdown.c,v $ -- automatically terminate irmp3d
 * $Id: mod_autoshutdown.c,v 1.6 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by David E. Potter
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <malloc.h>

#include "config.h"
#include "irmp3tools.h"
#include "irmp3config.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_autoshutdown.h"

#ifndef MOD_IDLE
#error mod_idle must be enabled for mod_autoshutdown to work
#endif

/*************************************************************************
 * GLOBALS AND STATICS
 */

static unsigned int	shutdown_seconds = 0;


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_autoshutdown = {
	"mod_autoshutdown",
	mod_autoshutdown_deinit,	// deinit
	NULL,				// reload
	&blank_fd,			// watch_fdset
	NULL,				// poll
	NULL,				// update
	mod_autoshutdown_message, 	// message
	NULL,				// SIGCHLD handler
	mod_autoshutdown_init,
	NULL,				// avoid warning
};

void mod_autoshutdown_message (int msgtype, char *msg,const char __attribute__((unused))*sender)
{
	unsigned long idle_time=0;
	
	if(msgtype == MSGTYPE_EVENT && !strncasecmp(msg,"idle",4)) {
		idle_time=strtol(msg+5,NULL,10);
		if (shutdown_seconds && (idle_time >= shutdown_seconds)) {
			log_printf(LOG_NORMAL, "mod_autoshutdown_alarm(): autoshutdown timeout reached. Shutting down...\n");
			terminate=1;
		}
	}
}


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_autoshutdown_init (void)
{
	char minutes[15];

	shutdown_seconds = 60 * config_getnum("autoshutdown_time",0);
	if (!shutdown_seconds) {
		log_printf(LOG_NORMAL, "mod_autoshutdown_init(): Cannot find autoshutdown_time, mod_autoshutdown disabled.\n");
	} else {

		if (shutdown_seconds > 60) 
			strcpy(minutes, "minutes");
		else 
			strcpy(minutes, "minute");

		log_printf(LOG_DEBUG, "mod_autoshutdown_init(): shutdown time is %d %s.\n",shutdown_seconds/60,minutes);
	}
	return NULL;
}

/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_autoshutdown_deinit (void)
{
	log_printf(LOG_DEBUG, "mod_autoshutdown_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */

