/*
 *  GNOME IrDA Monitor (girda)
 *  Copyright (C) 2001 Ragnar Henriksen <ragnar@juniks.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __IRDA_MISC_H__
#define __IRDA_MISC_H__

#include <sys/socket.h>
#include <linux/types.h>
#include <linux/irda.h>
struct _dev_info
{
        gchar *name;
        gint hints[2];
        struct _dev_info *next;
};

struct irda_device_list* irda_discover_device( int sfd );
struct _dev_info *irda_get_hints( gint *num );
int irda_check();

#ifdef ENABLE_OPENOBEX
gint irda_obex_init( obex_t *handle );
gint irda_obex_send_file( obex_t *handle );
gint irda_obex_recieve_file( obex_t *handle );
#endif

#endif
