/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IPODMOUNTPOINT_H
#define IPODMOUNTPOINT_H

#include <qvaluelist.h>
#include <qstringlist.h>

/**
Parses /proc/mounts and looks for mounted iPods

@author Michael Schulze
*/
class IPodMountPoint{
public:
    IPodMountPoint() {}
    ~IPodMountPoint();
    typedef QValueList<IPodMountPoint> List;
    
    const QString& getDevice() const;
    const QString& getMountPoint() const;
    const QString& getFsType() const;
    const QString& getOptions() const;
    
    static List mountedIPods();

private:
    IPodMountPoint(const QString& entry);
    
    const QString& getField(uint fieldnum) const;
    bool possiblyAnIpod() const;
    
    QStringList fields;
};

#endif
