/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EJECTUTILITY_H
#define EJECTUTILITY_H

#include "ipodutility.h"
#include "ipod.h"

/**
@author Michael Schulze
*/
class EjectUtility : public IPodUtility
{
public:
    EjectUtility();

    virtual ~EjectUtility();

    virtual const QString& getDefaultMimeType();
    virtual const QString& getName();
    virtual void handleRequest(IPod& ipod, const KURL& request, QByteArray& response, QString& mimeType);

private:
    static const QString defaultmimetype;
    static const QString name;
};

#endif
