#
# INFO: The setup-script for the screenlets-pack-all
#
# (c) Ketil W. Aanensen 2008
#     Based on the incredible work of RYX (Rico Pfaus) 2007, built upon by Whise
#

from distutils.core import setup
import os
import sys
import traceback

# current version of the package
VERSION	= open("VERSION").readline()

#----------------------------------------------------------------------------
# FUNCTIONS
#----------------------------------------------------------------------------

def create_desktop_file(genpath, destpath, podir, desktop_file, icon_addition, packname, files_list):
	"""Creates desktop file for a screenlet"""
	name = podir.lower() + "-screenlet"
	os.system('mkdir -p ' + genpath % packname)
	if len(icon_addition)>0:
		real_icon_addition=icon_addition % packname
	else:
		real_icon_addition=""
	write_file((genpath % packname) + ("/%s.desktop" % name), (desktop_file % (podir, packname, podir, podir)) + real_icon_addition)
	os.system('chmod a+x ' + (genpath % packname) + "/*")
	files_list.append ((destpath % packname, [(genpath % packname) + ("/%s.desktop" % name)] ))

def write_file(path, contents):
	"""Just write string to a file"""
	f = open(path, 'w')
	if f:
		f.write(contents)
		f.close()
	else:
		print "!!!", path
		raise Exception

def filter_filename_callback(filename):
	"""Called by make_file_list to determine which files to add/install 
	to the package and which files are to be ignored."""
	# skip temp-files
	if filename[-1] == '~':
		return False
	return True
	
def scan_dir_list(paths, addself=False):
	"""makes a list of all subdirectories of a path, option addself 
	also adds directories themselves"""
	out = []
	if addself:
		out.extend(paths)
	for path in paths:
		plen = len(path) + 1
		files = os.listdir(path)
		for f in files:
			if f != "po":
				full = path + '/' + f
				if (os.path.isdir(full)):
					out.append(full)
					out.extend(scan_dir_list([full]))
	return out

def make_file_list(dirlist, install_path, strip=''):
	"""Takes a list with dirnames and creates a list suitable for the 
	data_files-attribute for the setup-function that includes all files 
	within the dir. The string defined by strip will be replaced from 
	within the directory names. TODO: the strip-arg is not very secure 
	and could cause errors ... fix that!!!!!!!!!! """
	data_files = []
	for d in dirlist:
		dlst = []
		files = os.listdir(d)
		for f in files:
			full = d +'/' + f
			if os.path.isfile(full):
				if filter_filename_callback(f):
					dlst.append(full)
		data_files.append((install_path + '/' + d.replace(strip, ''), dlst))
	return data_files

# - screenlets-subdirs and all their data go into PREFIX/<name>/...
all_dirlist		= scan_dir_list(['src'])
all_files_list	= make_file_list(all_dirlist, 'share/screenlets/screenlets-pack-all', 
	strip='src/')	# to strip this string from filenames

basic_screenlets = [
	# we don't add random screenlets, less is better
	# we should add just one screenlet for each function (if possible)
	# the one which is most usable for general public
	# we should remove screenlets which do not work
	#
	# if there are too many basic screenlets, it's annoying for the new user
	#
	# usual desktop stuff
	'src/Ruler', # pixel ruler
	'src/Lipik', # sticky notes
	'src/Clock', # do we need also digital or text based?
	'src/Trash', # Trashbin
	'src/Calc', # Calculator
	'src/ClearCalendar', # calendar with some ics ability
	'src/FolderView', # it may be not too usable, but still basic
	
	# music/audio related stuff
	'src/NowPlaying', # Shows info for song currently playing
	'src/Lyrics', # Querys and shows lyrics for songs while playing
	
	# just visual candy, there has to be some
	'src/Flower', # some digital nature
	'src/Sticker', # we are for the Linux (Tux Screenlet would be fun too)
	
	# data from web
	'src/MailCheck', # IMAP and gmail
	'src/Slideshow', # Media RSS, Flickr, folder on disk
	'src/ClearRss', # Text RSS
	
	# weather, by now two options
	'src/ClearWeather', # source: weather.com
	'src/FreemeteoWeather', # source: freemeteo.com
	
	# system sensors
	'src/Meter', # bar meter
	'src/Sensors', # vertical graph and time graph
	'src/Sysmonitor', # various indicators
	
#	'src/',
	]
	
basic_dirlist		= scan_dir_list(basic_screenlets, addself=True)

basic_files_list	= make_file_list(basic_dirlist, 'share/screenlets/screenlets-pack-basic', 
	strip='src/')	# to strip this string from filenames

# Install translation files
buildcmd = "msgfmt -o build/locale/%s/LC_MESSAGES/%s.mo %s/%s.po"
mopath = "build/locale/%s/LC_MESSAGES/%s.mo"
destpath = "share/screenlets/%s/%s/mo/%s/LC_MESSAGES"
for podir in os.listdir("src"):
	full_po_path = "src/"+podir+"/po"
	if os.path.exists(full_po_path):
		for name in os.listdir (full_po_path):
			if name.endswith('.po'):
				dname = name.split('.')[0]
				name = podir.lower() + "-screenlet"
				if sys.argv[1] == "build" or sys.argv[1] == "install":
					print 'Creating language Binary for : ' + name
					if not os.path.isdir ("build/locale/%s/LC_MESSAGES" % dname):
						os.makedirs ("build/locale/%s/LC_MESSAGES" % dname)
					os.system (buildcmd % (dname, name, full_po_path, dname))
					all_files_list.append ((destpath % ("screenlets-pack-all", podir, dname), [mopath % (dname,name)]))
					if "src/"+podir in basic_screenlets:
						basic_files_list.append ((destpath % ("screenlets-pack-basic", podir, dname), [mopath % (dname,name)]))

# Generate and install desktop files
desktop_file = """[Desktop Entry]
Name=%s
Encoding=UTF-8
Version=1.0
Type=Application
Exec= python -u /usr/share/screenlets/%s/%s/%sScreenlet.py
"""
destpath = "share/applications/%s"
genpath = "build/applications/%s"
for podir in os.listdir("src"):
	try:
		icon_addition = ""
		icon = None
		if os.path.exists("src/%s/icon.svg" % podir):
			icon = "icon.svg"
		elif os.path.exists("src/%s/icon.png" % podir):
			icon = "icon.png"
		if icon is not None:
			icon_addition = "Icon=/usr/share/screenlets/%s/%s/%s" % ("%s", podir, icon)
		create_desktop_file(genpath, destpath, podir, desktop_file, icon_addition, "screenlets-pack-all", all_files_list)
		if "src/"+podir in basic_screenlets:
			create_desktop_file(genpath, destpath, podir, desktop_file, icon_addition, "screenlets-pack-basic", basic_files_list)
	except:
		traceback.print_exc()
		print "Error generating desktop file: " + podir
		exit(-1)
#exit(-1)

#print basic_files_list

setup(name = 'screenlets-pack-all',
	version			= VERSION,
	author			= 'Guido Tabbernuk',
	author_email	= 'boamaod@gmail.com',
	url				= 'http://www.screenlets.org',
	license			= 'GPL v3',
	description		= 'Package containing all Screenlets.',
	data_files		= all_files_list
	)

setup(name = 'screenlets-pack-basic',
	version			= VERSION,
	author			= 'Guido Tabbernuk',
	author_email	= 'boamaod@gmail.com',
	url				= 'http://www.screenlets.org',
	license			= 'GPL v3',
	description		= 'Package containing only basic screenlets.',
	data_files		= basic_files_list
	)

