/*
 * indicator-network - user interface for connman
 *
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "manager.h"
#include "mock-network-menu.h"
#include "mock-connman-manager.h"

#define DOMAIN "/Network/Backend/Manager"

static Manager *sm;

static void test_new(void)
{
  ConnmanManager *connman;
  NetworkMenu *menu;

  sm = manager_new();

  g_assert(sm != NULL);

  connman = manager_get_connman(sm);
  connman_manager_mock_set_connected(connman, TRUE);

  while (g_main_context_iteration(NULL, FALSE));

  menu = network_menu_mock_get_object();

  g_assert(network_menu_mock_get_enabled(menu) == TRUE);
}

static void test_destroyed_signal(void)
{
  ConnmanManager *connman;
  NetworkMenu *menu;

  connman = manager_get_connman(sm);
  connman_manager_mock_set_connected(connman, FALSE);

  while (g_main_context_iteration(NULL, FALSE));

  menu = network_menu_mock_get_object();
  g_assert(network_menu_mock_get_enabled(menu) == FALSE);

}

gint main (gint argc, gchar *argv[])
{
  g_type_init();

  g_test_init(&argc, &argv, NULL);

  g_test_add_func(DOMAIN "/New", test_new);
  g_test_add_func(DOMAIN "/DestroyedSignal", test_destroyed_signal);

  return g_test_run();
}

