/*
 * indicator-network - user interface for connman
 * Copyright 2011 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CONNMAN_IPV6_H_
#define _CONNMAN_IPV6_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CONNMAN_TYPE_IPV6 connman_ipv6_get_type()

#define CONNMAN_IPV6(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), CONNMAN_TYPE_IPV6, \
			      ConnmanIPv6))

#define CONNMAN_IPV6_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), CONNMAN_TYPE_IPV6, \
			   ConnmanIPv6Class))

#define CONNMAN_IS_IPV6(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), CONNMAN_TYPE_IPV6))

#define CONNMAN_IS_IPV6_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), CONNMAN_TYPE_IPV6))

#define CONNMAN_IPV6_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), CONNMAN_TYPE_IPV6, \
			     ConnmanIPv6Class))

typedef struct {
  GObject parent;
} ConnmanIPv6;

typedef struct {
  GObjectClass parent_class;
} ConnmanIPv6Class;

#define CONNMAN_IPV6_ERROR connman_ipv6_error_quark()

static inline GQuark connman_ipv6_error_quark(void)
{
  return g_quark_from_static_string ("connman-ipv6-error-quark");
}

typedef enum {
  CONNMAN_IPV6_ERROR_INVALID_METHOD,
  CONNMAN_IPV6_ERROR_INVALID_SETTINGS,
} ConnmanIPv6Error;

typedef enum {
  CONNMAN_IPV6_METHOD_OFF,
  CONNMAN_IPV6_METHOD_MANUAL,
  CONNMAN_IPV6_METHOD_FIXED,
  CONNMAN_IPV6_METHOD_AUTO,
} ConnmanIPv6Method;

GType connman_ipv6_get_type(void);

ConnmanIPv6Method connman_ipv6_get_method(ConnmanIPv6 *self);
const gchar *connman_ipv6_get_method_as_string(ConnmanIPv6 *self);
const gchar *connman_ipv6_get_address(ConnmanIPv6 *self);
guchar connman_ipv6_get_prefix_length(ConnmanIPv6 *self);
const gchar *connman_ipv6_get_gateway(ConnmanIPv6 *self);
ConnmanIPv6 *connman_ipv6_new(ConnmanIPv6Method method,
			      const gchar *address,
			      guchar prefix_length,
			      const gchar *gateway,
			      GError **error);
ConnmanIPv6 *connman_ipv6_new_with_strings(const gchar *method,
					   const gchar *address,
					   guchar prefix_length,
					   const gchar *gateway,
					   GError **error);

#endif
