#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2013 Kobe Lee kobe24_lixiang@126.com
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os, sys

#CONFIG_FILE = './weather.conf'
PROJECT_ROOT_DIRECTORY = os.path.abspath(
    os.path.dirname(os.path.dirname(os.path.realpath(sys.argv[0]))))
CONFIG_FILE = os.path.join(PROJECT_ROOT_DIRECTORY, 'src/weather.conf')

class Settings:
    # Get a value of the setting
    def get_value(self):
        fp = open(CONFIG_FILE, 'r')
        strings = fp.readlines()
        fp.close()
        dist = {}
        for str in strings:
            if 'city_id' or 'update_time' or 'show_temperature' in str:
                str = str.strip('\n')
                keys = str.split('=')[0]
                values = str.split('=')[1]
                dist[keys.strip()] = values.strip()
        return dist

    # set a value of the setting
    def set_value(self, city_id, update_time, show_temperature):
        """city_id = 101250101 update_time = 15 show_temperature = 1"""
        #print('start to set value***********')
        #print(city_id)
        #print(update_time)
        #print(show_temperature)
        city_flag = 'city_id = '
        time_flag = 'update_time = '
        temperature_flag = 'show_temperature = '
        config_strings = list()
        self.city_id = city_flag + city_id
        self.update_time = time_flag + update_time
        self.show_temperature = temperature_flag + show_temperature
        config_strings.append(self.city_id)
        config_strings.append('\n')
        config_strings.append(self.update_time)
        config_strings.append('\n')
        config_strings.append(self.show_temperature)
        #print(config_strings)
        fp = open(CONFIG_FILE, 'w')
        fp.writelines(config_strings)
        fp.close()
        print('set value success**************')
