#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2010 Sebastian MacDonald Sebas310@gmail.com
# Copyright (C) 2010 Mehdi Rejraji mehd36@gmail.com
# Copyright (C) 2011 Vadim Rutkovsky roignac@gmail.com
# Copyright (C) 2013 Zhang Zhao vaguedream@hotmail.com
# Copyright (C) 2013 Kobe Lee kobe24_lixiang@126.com
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os, sys, tempfile
import gtk, pygtk, gobject
import thread, threading
import appindicator
import logging, logging.handlers
import locale
import traceback
import string

import gettext
from gettext import gettext as _
from gettext import ngettext as __
gettext.textdomain('indicator-weather')

import commands, threading
import pycwapi
import forecastui
from settings import *
from helpers import *

# Add project root directory (enable symlink, and trunk execution).
PROJECT_ROOT_DIRECTORY = os.path.abspath(
    os.path.dirname(os.path.dirname(os.path.realpath(sys.argv[0]))))

CHN_CITY_LIST_FILE = os.path.join(PROJECT_ROOT_DIRECTORY, 'src/location.txt')

class indicator_weather(threading.Thread):
    """ Indicator class """
    last_update_time = None
    
    def __init__(self):
        log.debug("Indicator: creating")
        threading.Thread.__init__(self)
        self.main_icon = os.path.join
        self.winder = appindicator.Indicator ("indicator-china-weather", "weather-fog", appindicator.CATEGORY_OTHER)
        self.winder.set_status (appindicator.STATUS_ACTIVE)
        self.winder.set_attention_icon ("weather-indicator-error")
       
        self.weather_data={}
        #self.forecast_data={}
        self.icon = None
        self.menu = None
        self.place = None
        
        self.city_id = None
        self.rate = 10
        self.show_temperature = '0'
        self.update_setting()

        self.weather_icons={
             'd0.gif':'weather-clear',
            'd1.gif':'weather-few-clouds',
            'd2.gif':'weather-many-clouds',
            'd3.gif':'weather-showers-day',
            'd4.gif':'weather-showers',
            'd5.gif':'weather-showers',
            'd6.gif':'weather-snow-rain',
            'd7.gif':'weather-showers',
            'd8.gif':'weather-showers',
            'd9.gif':'weather-showers',
            'd10.gif':'weather-showers',
            'd11.gif':'weather-showers',
            'd12.gif':'weather-showers',
            'd13.gif':'weather-snow-scattered-day',
            'd14.gif':'weather-snow',
            'd15.gif':'weather-snow',
            'd16.gif':'weather-snow',
            'd17.gif':'weather-snow',
            'd18.gif':'weather-fog',
            'd19.gif':'weather-freezing-rain',
            'd20.gif':'weather-fog',
            'd21.gif':'weather-showers',
            'd22.gif':'weather-showers',
            'd23.gif':'weather-showers',
            'd24.gif':'weather-showers',
            'd25.gif':'weather-showers',
            'd26.gif':'weather-snow',
            'd27.gif':'weather-snow',
            'd28.gif':'weather-snow',
            'd29.gif':'weather-fog',
            'd30.gif':'weather-fog',
            'd31.gif':'weather-fog',
            'n0.gif':'weather-clear-night',
            'n1.gif':'weather-few-clouds-night',
            'n2.gif':'weather-many-clouds-night',
            'n3.gif':'weather-showers-night',
            'n4.gif':'weather-showers',
            'n5.gif':'weather-showers',
            'n6.gif':'weather-snow-rain',
            'n7.gif':'weather-showers',
            'n8.gif':'weather-showers',
            'n9.gif':'weather-showers',
            'n10.gif':'weather-showers',
            'n11.gif':'weather-showers',
            'n12.gif':'weather-showers',
            'n13.gif':'weather-snow-scattered-night',
            'n14.gif':'weather-snow',
            'n15.gif':'weather-snow',
            'n16.gif':'weather-snow',
            'n17.gif':'weather-snow',
            'n18.gif':'weather-snow',
            'n19.gif':'weather-freezing-rain',
            'n20.gif':'weather-snow',
            'n21.gif':'weather-showers',
            'n22.gif':'weather-showers',
            'n23.gif':'weather-showers',
            'n24.gif':'weather-showers',
            'n25.gif':'weather-showers',
            'n26.gif':'weather-snow',
            'n27.gif':'weather-snow',
            'n28.gif':'weather-snow',
            'n29.gif':'weather-snow',
            'n30.gif':'weather-snow',
            'n31.gif':'weather-snow'
        }


        if self.city_id == None:
            self.menu_noplace()
        else:
            self.menu_normal()
            self.update_weather()

    def update_setting(self):
        self.settings = Settings()
        dict = self.settings.get_value()
        if dict['city_id'] is not '':
            self.city_id = dict['city_id']
        if dict['update_time'] is not '':
            self.rate = dict['update_time']
        if dict['show_temperature'] is not '':
            self.show_temperature = dict['show_temperature']

    # Show a menu if no places specified
    def menu_noplace(self):
        log.debug("Indicator: making a menu for no places")
        menu_noplace = gtk.Menu()

        setup = gtk.MenuItem(_("配置地点..."))
        setup.connect("activate", self.prefs)
        menu_noplace.append(setup)
        setup.show()

        #about = gtk.MenuItem(_("关于..."))
        #about.connect("activate", self.about)
        #about.show()
        #menu_noplace.append(about)

        quit = gtk.ImageMenuItem(gtk.STOCK_QUIT)
        quit.connect("activate", self.quit)
        quit.show()
        menu_noplace.append(quit)

        self.winder.set_menu(menu_noplace)

    # Show menu with data
    def menu_normal(self):
        log.debug("Indicator: menu_normal: filling in a menu for found places")
        self.menu = gtk.Menu()

        ##City
        self.city_show = gtk.MenuItem()
        self.city_show.set_sensitive(True)
        self.city_show.show()
        self.menu.append(self.city_show)

        ##Weather
        self.weather_show = gtk.MenuItem()
        self.weather_show.set_sensitive(True)
        self.weather_show.show()
        self.menu.append(self.weather_show)
        
        ##Temperature
        self.temp_show = gtk.MenuItem()
        self.temp_show.set_sensitive(True)
        self.temp_show.show()
        self.menu.append(self.temp_show)

        ##HighTemp
        self.temp1_show = gtk.MenuItem()
        self.temp1_show.set_sensitive(True)
        self.temp1_show.show()
        self.menu.append(self.temp1_show)

        ##LowTemp
        self.temp2_show = gtk.MenuItem()
        self.temp2_show.set_sensitive(True)
        self.temp2_show.show()
        self.menu.append(self.temp2_show)
        
        ##Humidity
        self.SD_show = gtk.MenuItem()
        self.SD_show.set_sensitive(True)
        self.SD_show.show()
        self.menu.append(self.SD_show)

        ##Wind Direction
        self.WD_show = gtk.MenuItem()
        self.WD_show.set_sensitive(True)
        self.WD_show.show()
        self.menu.append(self.WD_show)

        ##Wind Strength
        self.WS_show = gtk.MenuItem()
        self.WS_show.set_sensitive(True)
        self.WS_show.show()
        self.menu.append(self.WS_show)
        
        ##Update Time
        self.time_show = gtk.MenuItem()
        self.time_show.set_sensitive(True)
        self.time_show.show()
        self.menu.append(self.time_show)

        ##Breaker
        breaker = gtk.SeparatorMenuItem()
        breaker.show()
        self.menu.append(breaker)

        #self.refresh_show = gtk.MenuItem()
        #self.refresh_show.connect("activate", self.update_weather)
        #self.refresh_show.show()
        #self.menu.append(self.refresh_show)

        ext_show = gtk.MenuItem(_("天气预报"))
        ext_show.connect("activate", self.forecast)
        ext_show.show()
        self.menu.append(ext_show)    
        
        ##Preferences
        prefs_show = gtk.MenuItem(_("配置..."))
        prefs_show.connect("activate", self.prefs)
        prefs_show.show()
        self.menu.append(prefs_show)

        ##About
        #about_show = gtk.MenuItem(_("关于..."))
        #about_show.connect("activate", self.about)
        #about_show.show()
        #self.menu.append(about_show)

        ##Quit
        quit = gtk.ImageMenuItem(gtk.STOCK_QUIT)
        quit.connect("activate", self.quit)
        quit.show()
        self.menu.append(quit)

        self.winder.set_menu(self.menu)
        self.update_label(" ")

    # Set a label of indicator
    def update_label(self, label):
        if (hasattr(self.winder, 'set_label')):
            log.debug("Indicator: update_label: setting label to '%s'" % label)
            self.previous_label_value = label
            self.winder.set_label(label)
            self.winder.set_status(appindicator.STATUS_ATTENTION)
            self.winder.set_status(appindicator.STATUS_ACTIVE)
    
    # Quit the applet
    def quit(self, widget, data=None):
        log.debug("Indicator: Quitting")
        gtk.main_quit()

    # Update weather
    def update_weather(self):
        log.debug("Indicator: updateWeather: updating weather for %s" % self.city_id)
        try:
            self.weather_data = pycwapi.get_weather_from_nmc(self.city_id, 0)
            print self.weather_data
            if self.weather_data is not None:
                log.debug("Indicator: loading weather from cache for %s" % self.city_id)
            
                self.ptime = self.weather_data['ptime']
                pint = string.atoi(self.ptime.split(':')[0])
                if pint > 7 or pint < 20:
                    self.icon = self.weather_icons[self.weather_data['img1']]
                else :
                    self.icon = self.weather_icons[self.weather_data['img2']]
                print self.icon
                self.menu_normal()
                self.winder.set_icon(self.icon)

                self.city_show.set_label(self.weather_data['city'])
                self.weather_show.set_label(_('天气:') + self.weather_data['weather'])
                self.temp_show.set_label(_('当前气温:') + self.weather_data['temp'] + '℃')
                self.temp1_show.set_label(_('最高气温:') + self.weather_data['temp1'])
                self.temp2_show.set_label(_('最低气温:') + self.weather_data['temp2'])
                self.SD_show.set_label(_('湿度:') + self.weather_data['SD'])
                self.WD_show.set_label(_('风向:') + self.weather_data['WD'])
                self.WS_show.set_label(_('风力:') + self.weather_data['WS'])
                self.time_show.set_label(_('更新时间:') + self.weather_data['time'])
                if self.show_temperature == '1':
                    self.update_label(self.weather_data['temp'] + '℃')
                self.winder.set_status(appindicator.STATUS_ATTENTION)
                self.winder.set_status(appindicator.STATUS_ACTIVE)
        except Exception, e:
            log.error(e)
            log.debug(traceback.format_exc(e))

        self.schedule_weather_update()

    # Menu callbacks
    # Open Preferences dialog
    def prefs(self, widget):
        #from preferences import PreferencesDialog
        log.debug("Indicator: open Preferences")
        if ((not hasattr(self, 'prefswindow')) or (not self.prefswindow.get_visible())):
            self.prefswindow = PreferencesDialog()
            self.prefswindow.show()

    # Schedule weather update
    def schedule_weather_update(self, rate_override = None):
        if hasattr(self, "rate_id"):
            gobject.source_remove(self.rate_id)
        if rate_override:
            self.rate_id = gobject.timeout_add(
                int(rate_override) * 60000, self.update_weather)
        else:
            self.rate_id = gobject.timeout_add(
                int(self.rate) * 60000, self.update_weather)

    def forecast(self, widget):
        #self.forecast_data = pycwapi.get_weather_from_nmc(self.city_id, 1)
        os.system(os.path.join(PROJECT_ROOT_DIRECTORY, "src/forecastui.py ") + self.city_id)
        #forecastui.show_forecast(self.forecast_data)

class PreferencesDialog(gtk.Dialog):
    """ Class for preferences dialog """
    __gtype_name__ = "PreferencesDialog"

    # Creating a new preferences dialog
    def __new__(cls):
        builder = get_builder('PreferencesDialog')
        new_object = builder.get_object("preferences_dialog")
        new_object.finish_initializing(builder)
        return new_object

	# Fill in preferences dialog with currect data
    def finish_initializing(self, builder):
        from pycwapi import get_location_from_cityid
        self.builder = builder
        self.settings = Settings()
        dict = self.settings.get_value()
        self.show_label = self.builder.get_object('show_label') #display temperature
        if dict['show_temperature'] == '1':
            print('temperature is 1........')
            self.show_label.set_active(True)
        else:
            print('temperature is not 1........')
            self.show_label.set_active(False)
        self.spinbutton_rate = self.builder.get_object('spinbutton_rate') #update_time
        self.spinbutton_rate.set_value(float(dict['update_time']))
        self.builder.get_object('show_label').get_active()
        location = get_location_from_cityid(dict['city_id'])
        newplace = list()
        newplace.append(location)#Label
        newplace.append(location)#City
        newplace.append(dict['city_id'])#Location
        self.builder.get_object('citieslist').append(newplace)
        self.builder.get_object('ok_button').set_sensitive(True)
        self.builder.get_object('show_label').set_visible(True)
        self.builder.connect_signals(self)

	# 'Remove' clicked - remove location from list
    #TODO: Update settings object
    def on_remove_location(self, widget):
        selection = self.builder.get_object('location_list').get_selection()
        model, iter = selection.get_selected()
        if iter != None:
            model.remove(iter)
            self.settings = Settings()
            dict = self.settings.get_value()
            dict['city_id'] = ''
            self.settings.set_value(dict['city_id'], dict['update_time'], dict['show_temperature'])

        if (self.builder.get_object('citieslist').get_iter_first() == None):
            self.builder.get_object('ok_button').set_sensitive(False)

    # 'Add' clicked - create a new Assistant
    def on_add_location(self, widget):
        if ((not hasattr(self, 'assistant')) or (not self.assistant.get_visible())):
		    self.assistant = Assistant()
		    self.assistant.show()

	# 'OK' clicked - save settings
    def ok(self, widget, data=None):
        #Show label near icon
        new_show_label = self.builder.get_object('show_label').get_active()
        self.settings = Settings()
        dict = self.settings.get_value()
        if new_show_label:
            dict['show_temperature'] = '1'
        else:
            dict['show_temperature'] = '0'
        dict['update_time'] = self.spinbutton_rate.get_text()
        self.settings.set_value(dict['city_id'], dict['update_time'], dict['show_temperature'])
        iw.update_setting()
        iw.update_weather()
        self.destroy()

    # 'Cancel' click - forget all changes
    def cancel(self, widget, data=None):
        self.destroy()

class Assistant(gtk.Assistant):
    """ Class for a wizard, which helps to add a new location in location list """
    __gtype_name__ = "Assistant"

    # Create new object
    def __new__(cls):
        builder = get_builder('Assistant')
        new_object = builder.get_object("assistant")
        new_object.finish_initializing(builder)
        return new_object

    # Finish UI initialization - prepare combobox
    def finish_initializing(self, builder):
        self.builder = builder
        self.builder.connect_signals(self)
        self.assistant = self.builder.get_object("assistant")
        self.assistant.set_page_complete(self.builder.get_object("label"),True)
        self.assistant.set_page_complete(self.builder.get_object("review"),True)

        # Set up combobox
        self.store = gtk.ListStore(str)
        self.location_input_combo = self.builder.get_object("combolocations")
        self.location_input_combo.set_model(self.store)
        self.location_input_combo.set_text_column(0)
        self.location_entry = self.builder.get_object("entrylocation")
        self.place_selected = None
        self.location = None
        self.cityid = ''
        self.dict = {}

        self.assistant.set_forward_page_func(self.next_page)

    # 'Get cities' button clicked - get suggested cities list
    def on_get_city_names(self, widget):
        new_text = self.location_entry.get_text()
        self.store.clear()
        f = open(CHN_CITY_LIST_FILE, 'r')
        self.dist = {}
        for line in f.readlines():
            if new_text in line:
                keys = line.split(':')[0]
                values = line.split(':')[1]
                self.store.append([keys])
                self.dict[keys] = values
                self.location_input_combo.popup()

    # A city is selected from suggested list
    def on_select_city(self, entry):
        if self.location_input_combo.get_active() != -1:
            self.place_selected = self.store[self.location_input_combo.get_active()]
            self.assistant.set_page_complete(self.builder.get_object("placeinput"),True)
            self.context = self.location_entry.get_text()
            for key in self.dict:
                if key == self.context:
                    self.cityid = self.dict[key]
                    break
        else:
            self.place_selected = None
            self.location = None
            self.assistant.set_page_complete(self.builder.get_object("placeinput"), False)

    # Create a location object out of a selected location
    def next_page(self, current_page):
        if (self.assistant.get_current_page() == 0) and not self.location and self.place_selected:
            text = self.place_selected[0]
            self.builder.get_object("entrylbl").set_text(text)
        elif self.assistant.get_current_page() == 1:
            # Confirmation page
            lbl = self.builder.get_object("entrylbl").get_text()
            # If empty label was input, set label to short city name
            if lbl == '':
                lbl = self.place_selected[0]
            self.builder.get_object("lbl3").set_label(_('标签:'))
            self.builder.get_object("labellbl").set_label('<b>%s</b>' % lbl)
            self.builder.get_object("placelbl").set_label('<b>%s</b>' % self.place_selected[0])
        return self.assistant.get_current_page() + 1

    # 'Cancel' clicked
    def on_cancel(self,widget):
        self.destroy()

    # 'Apply' clicked - save location details, add an entry in a location list
    def on_apply(self,widget):
        self.settings = Settings()
        dict = self.settings.get_value()
        dict['city_id'] = self.cityid
        self.settings.set_value(dict['city_id'], dict['update_time'], dict['show_temperature'])
        newplace = list()
        newplace.append(self.context)#Label
        newplace.append(self.context)#City
        newplace.append(dict['city_id'])#Location
        item = iw.prefswindow.builder.get_object('citieslist').get_iter_first()
        iw.prefswindow.builder.get_object('citieslist').clear()
        iw.prefswindow.builder.get_object('citieslist').append(newplace)
        # Enable 'OK' button in Preferences
        iw.prefswindow.builder.get_object('ok_button').set_sensitive(True)
        self.hide()

class SingleInstance(object):
    """ Class to ensure, that single instance of the applet is run for each user """

    # Initialize, specifying a path to store pids
    def __init__(self, pidPath):
        self.pidPath=pidPath
        # See if pidFile exists
        if os.path.exists(pidPath):
            log.debug("SingleInstance: pid file %s exists" % pidPath)
            # Make sure it is not a "stale" pidFile
            pid=open(pidPath, 'r').read().strip()
            # Check list of running pids, if not running it is stale so overwrite
            pidRunning = commands.getoutput('ls -1 /proc | grep ^%s$' % pid)
            log.debug("SingleInstance: pid running %s" % pidRunning)
            self.lasterror = True if pidRunning else False
        else:
            self.lasterror = False

        if not self.lasterror:
            log.debug("SingleInstance: writing new pid %s" % str(os.getpid()))
            # Create a temp file, copy it to pidPath and remove temporary file
            (fp, temp_path)=tempfile.mkstemp()
            try:
                os.fdopen(fp, "w+b").write(str(os.getpid()))
                shutil.copy(temp_path, pidPath)
                os.unlink(temp_path)
            except Exception as e:
                log.error("SingleInstance: exception while renaming '%s' to '%s':\n %s" % (temp_path, pidPath, str(e)))

    def is_already_running(self):
        return self.lasterror

    def __del__(self):
        if not self.lasterror:
            log.debug("SingleInstance: deleting %s" % self.pidPath)
            os.unlink(self.pidPath)

def main():
    gtk.main()
    return 0

if __name__ == "__main__":
    # Enable and configure logs
    global log
    cachedir = os.environ.get('XDG_CACHE_HOME','').strip()
    if not cachedir:
        cachedir = os.path.expanduser("~/.cache")
    log_filename = os.path.join(cachedir, "indicator-china-weather.log")
    log = logging.getLogger('ChineseIndicatorWeather')
    log.propagate = False
    log.setLevel(logging.DEBUG)
    log_handler = logging.handlers.RotatingFileHandler(log_filename, maxBytes=1024*1024, backupCount=5)
    log_formatter = logging.Formatter("[%(threadName)s] %(asctime)s - %(levelname)s - %(message)s")
    log_handler.setFormatter(log_formatter)
    log.addHandler(log_handler)

    log.info("------------------------------")
    #log.info("Started Weather Indicator from %s" % PROJECT_ROOT_DIRECTORY)
    #log.info("Weather Indicator version %s" % VERSION)

    # Single instance stuff for weather indicator
    myapp = SingleInstance("/tmp/indicator-china-weather-%d.pid" % os.getuid())
    # check is another instance of same program running
    if myapp.is_already_running():
        log.info("Another instance of this program is already running")
        sys.exit(_("Another instance of this program is already running"))

    # Set http proxy support
    ProxyMonitor.monitor_proxy(log)
    # Use date-time format as in indicator-datetime
    TimeFormatter.monitor_indicator_datetime(log)
    # not running, safe to continue...
    gtk.gdk.threads_init()
    gtk.gdk.threads_enter()
    # Remember locale name
    global locale_name
    locale_name = locale.getlocale()[0]
    if locale_name is not None:
        locale_name = locale_name.split('_')[0]
    else:
        locale.setlocale(locale.LC_ALL, 'C') # use default (C) locale
        locale_name = "en"

    iw = indicator_weather()
    main()
    gtk.gdk.threads_leave()
