/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIndex {
    private static final String MIN_CHAR = String.valueOf('\u0000');
    private static final String MAX_CHAR = String.valueOf('\uffff');
    public static final long NOT_MODIFIED = Long.MIN_VALUE;
    private static Map<File, ZipFileIndex> zipFileIndexCache = new HashMap<File, ZipFileIndex>();
    private static ReentrantLock lock = new ReentrantLock();
    private static boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private Map<RelativePath.RelativeDirectory, DirectoryEntry> directories = Collections.emptyMap();
    private Set<RelativePath.RelativeDirectory> allDirs = Collections.emptySet();
    private File zipFile;
    private Reference<File> absFileRef;
    private long zipFileLastModified = Long.MIN_VALUE;
    private RandomAccessFile zipRandomFile;
    private Entry[] entries;
    private boolean readFromIndex = false;
    private File zipIndexFile = null;
    private boolean triedToReadIndex = false;
    final RelativePath.RelativeDirectory symbolFilePrefix;
    private int symbolFilePrefixLength = 0;
    private boolean hasPopulatedData = false;
    private long lastReferenceTimeStamp = Long.MIN_VALUE;
    private boolean usePreindexedCache = false;
    private String preindexedCacheLocation = null;
    private boolean writeIndex = false;
    private Map<String, SoftReference<RelativePath.RelativeDirectory>> relativeDirectoryCache = new HashMap<String, SoftReference<RelativePath.RelativeDirectory>>();
    private static Inflater inflater;

    public static java.util.List<ZipFileIndex> getZipFileIndexes() {
        return ZipFileIndex.getZipFileIndexes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.List<ZipFileIndex> getZipFileIndexes(boolean bl) {
        ArrayList<ZipFileIndex> arrayList = new ArrayList<ZipFileIndex>();
        lock.lock();
        try {
            arrayList.addAll(zipFileIndexCache.values());
            if (bl) {
                for (ZipFileIndex zipFileIndex : arrayList) {
                    if (zipFileIndex.isOpen()) continue;
                    arrayList.remove(zipFileIndex);
                }
            }
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        lock.lock();
        try {
            boolean bl = this.zipRandomFile != null;
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getZipFileIndex(File file, RelativePath.RelativeDirectory relativeDirectory, boolean bl, String string, boolean bl2) throws IOException {
        ZipFileIndex zipFileIndex = null;
        lock.lock();
        try {
            zipFileIndex = ZipFileIndex.getExistingZipIndex(file);
            if (zipFileIndex == null || zipFileIndex != null && file.lastModified() != zipFileIndex.zipFileLastModified) {
                zipFileIndex = new ZipFileIndex(file, relativeDirectory, bl2, bl, string);
                zipFileIndexCache.put(file, zipFileIndex);
            }
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
        return zipFileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getExistingZipIndex(File file) {
        lock.lock();
        try {
            ZipFileIndex zipFileIndex = zipFileIndexCache.get(file);
            Object var3_2 = null;
            lock.unlock();
            return zipFileIndex;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        lock.lock();
        try {
            zipFileIndexCache.clear();
            Object var1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(long l) {
        lock.lock();
        try {
            for (File file : zipFileIndexCache.keySet()) {
                long l2;
                ZipFileIndex zipFileIndex = zipFileIndexCache.get(file);
                if (zipFileIndex == null || (l2 = zipFileIndex.lastReferenceTimeStamp + l) >= zipFileIndex.lastReferenceTimeStamp && System.currentTimeMillis() <= l2) continue;
                zipFileIndexCache.remove(file);
            }
            Object var8_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(File file) {
        lock.lock();
        try {
            zipFileIndexCache.remove(file);
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOpenedIndexes(java.util.List<ZipFileIndex> list) throws IllegalStateException {
        lock.lock();
        try {
            if (zipFileIndexCache.isEmpty()) {
                throw new IllegalStateException("Setting opened indexes should be called only when the ZipFileCache is empty. Call JavacFileManager.flush() before calling this method.");
            }
            for (ZipFileIndex zipFileIndex : list) {
                zipFileIndexCache.put(zipFileIndex.zipFile, zipFileIndex);
            }
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private ZipFileIndex(File file, RelativePath.RelativeDirectory relativeDirectory, boolean bl, boolean bl2, String string) throws IOException {
        this.zipFile = file;
        this.symbolFilePrefix = relativeDirectory;
        this.symbolFilePrefixLength = relativeDirectory == null ? 0 : relativeDirectory.getPath().getBytes("UTF-8").length;
        this.writeIndex = bl;
        this.usePreindexedCache = bl2;
        this.preindexedCacheLocation = string;
        if (file != null) {
            this.zipFileLastModified = file.lastModified();
        }
        this.checkIndex();
    }

    public String toString() {
        return "ZipFileIndex[" + this.zipFile + "]";
    }

    protected void finalize() {
        this.closeFile();
    }

    private boolean isUpToDate() {
        return this.zipFile != null && (!NON_BATCH_MODE || this.zipFileLastModified == this.zipFile.lastModified()) && this.hasPopulatedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        boolean bl = true;
        if (!this.isUpToDate()) {
            this.closeFile();
            bl = false;
        }
        if (this.zipRandomFile != null || bl) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.hasPopulatedData = true;
        if (this.readIndex()) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.directories = Collections.emptyMap();
        this.allDirs = Collections.emptySet();
        try {
            this.openFile();
            long l = this.zipRandomFile.length();
            ZipDirectory zipDirectory = new ZipDirectory(this.zipRandomFile, 0L, l, this);
            zipDirectory.buildIndex();
            Object var6_4 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
            throw throwable;
        }
        this.lastReferenceTimeStamp = System.currentTimeMillis();
    }

    private void openFile() throws FileNotFoundException {
        if (this.zipRandomFile == null && this.zipFile != null) {
            this.zipRandomFile = new RandomAccessFile(this.zipFile, "r");
        }
    }

    private void cleanupState() {
        this.entries = Entry.EMPTY_ARRAY;
        this.directories = Collections.emptyMap();
        this.zipFileLastModified = Long.MIN_VALUE;
        this.allDirs = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        lock.lock();
        try {
            this.writeIndex();
            this.closeFile();
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void closeFile() {
        if (this.zipRandomFile != null) {
            try {
                this.zipRandomFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipRandomFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getZipIndexEntry(RelativePath relativePath) {
        lock.lock();
        try {
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativePath.dirname());
            String string = relativePath.basename();
            Entry entry = directoryEntry == null ? null : directoryEntry.getEntry(string);
            Object var6_7 = null;
            lock.unlock();
            return entry;
        }
        catch (IOException iOException) {
            try {
                Entry entry = null;
                Object var6_8 = null;
                lock.unlock();
                return entry;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        List list;
        block5: {
            lock.lock();
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativeDirectory);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getFiles();
            if (list != null) break block5;
            List<String> list3 = List.nil();
            Object var6_7 = null;
            lock.unlock();
            return list3;
        }
        try {
            List list4 = list;
            Object var6_8 = null;
            lock.unlock();
            return list4;
        }
        catch (IOException iOException) {
            try {
                list = List.nil();
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<String> getDirectories(RelativePath.RelativeDirectory relativeDirectory) {
        List list;
        block5: {
            lock.lock();
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativeDirectory);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getDirectories();
            if (list != null) break block5;
            List<String> list3 = List.nil();
            Object var6_7 = null;
            lock.unlock();
            return list3;
        }
        try {
            List list4 = list;
            Object var6_8 = null;
            lock.unlock();
            return list4;
        }
        catch (IOException iOException) {
            try {
                list = List.nil();
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RelativePath.RelativeDirectory> getAllDirectories() {
        lock.lock();
        try {
            this.checkIndex();
            if (this.allDirs == Collections.EMPTY_SET) {
                this.allDirs = new HashSet<RelativePath.RelativeDirectory>(this.directories.keySet());
            }
            Set<RelativePath.RelativeDirectory> set = this.allDirs;
            Object var4_3 = null;
            lock.unlock();
            return set;
        }
        catch (IOException iOException) {
            try {
                Set<RelativePath.RelativeDirectory> set = Collections.emptySet();
                Object var4_4 = null;
                lock.unlock();
                return set;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RelativePath relativePath) {
        lock.lock();
        try {
            this.checkIndex();
            boolean bl = this.getZipIndexEntry(relativePath) != null;
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (IOException iOException) {
            try {
                boolean bl = false;
                Object var5_5 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(RelativePath relativePath) throws IOException {
        block3: {
            lock.lock();
            try {
                if (relativePath.getPath().length() != 0) break block3;
                this.lastReferenceTimeStamp = System.currentTimeMillis();
                boolean bl = true;
                Object var4_4 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
        this.checkIndex();
        boolean bl = this.directories.get(relativePath) != null;
        Object var4_5 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(RelativePath.RelativeFile relativeFile) throws IOException {
        lock.lock();
        try {
            Entry entry = this.getZipIndexEntry(relativeFile);
            if (entry == null) {
                throw new FileNotFoundException();
            }
            long l = entry.getLastModified();
            Object var6_4 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length(RelativePath.RelativeFile relativeFile) throws IOException {
        Entry entry;
        block6: {
            block5: {
                lock.lock();
                try {
                    entry = this.getZipIndexEntry(relativeFile);
                    if (entry == null) {
                        throw new FileNotFoundException();
                    }
                    if (!entry.isDir) break block5;
                    int n = 0;
                    Object var6_5 = null;
                    lock.unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            byte[] byArray = this.getHeader(entry);
            if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) != 0) break block6;
            int n = entry.compressedSize;
            Object var6_6 = null;
            lock.unlock();
            return n;
        }
        int n = entry.size;
        Object var6_7 = null;
        lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(RelativePath.RelativeFile relativeFile) throws IOException {
        lock.lock();
        try {
            Entry entry = this.getZipIndexEntry(relativeFile);
            if (entry == null) {
                throw new FileNotFoundException("Path not found in ZIP: " + relativeFile.path);
            }
            byte[] byArray = this.read(entry);
            Object var5_4 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] read(Entry entry) throws IOException {
        lock.lock();
        try {
            this.openFile();
            byte[] byArray = this.readBytes(entry);
            this.closeFile();
            byte[] byArray2 = byArray;
            Object var5_4 = null;
            lock.unlock();
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(RelativePath.RelativeFile relativeFile, byte[] byArray) throws IOException {
        lock.lock();
        try {
            Entry entry = this.getZipIndexEntry(relativeFile);
            if (entry == null) {
                throw new FileNotFoundException();
            }
            int n = this.read(entry, byArray);
            Object var6_5 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(Entry entry, byte[] byArray) throws IOException {
        lock.lock();
        try {
            int n;
            int n2 = n = this.readBytes(entry, byArray);
            Object var6_5 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private byte[] readBytes(Entry entry) throws IOException {
        byte[] byArray = this.getHeader(entry);
        int n = entry.compressedSize;
        byte[] byArray2 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray, 26) + ZipFileIndex.get2ByteLittleEndian(byArray, 28));
        this.zipRandomFile.readFully(byArray2, 0, n);
        if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) == 0) {
            return byArray2;
        }
        int n2 = entry.size;
        byte[] byArray3 = new byte[n2];
        if (this.inflate(byArray2, byArray3) != n2) {
            throw new ZipException("corrupted zip file");
        }
        return byArray3;
    }

    private int readBytes(Entry entry, byte[] byArray) throws IOException {
        byte[] byArray2 = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(byArray2, 8) == 0) {
            int n;
            this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
            int n2 = byArray.length;
            for (int i = 0; i < n2 && (n = this.zipRandomFile.read(byArray, i, n2 - i)) != -1; i += n) {
            }
            return entry.size;
        }
        int n = entry.compressedSize;
        byte[] byArray3 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
        this.zipRandomFile.readFully(byArray3, 0, n);
        int n3 = this.inflate(byArray3, byArray);
        if (n3 == -1) {
            throw new ZipException("corrupted zip file");
        }
        return entry.size;
    }

    private byte[] getHeader(Entry entry) throws IOException {
        this.zipRandomFile.seek(entry.offset);
        byte[] byArray = new byte[30];
        this.zipRandomFile.readFully(byArray);
        if (ZipFileIndex.get4ByteLittleEndian(byArray, 0) != 67324752) {
            throw new ZipException("corrupted zip file");
        }
        if ((ZipFileIndex.get2ByteLittleEndian(byArray, 6) & 1) != 0) {
            throw new ZipException("encrypted zip file");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inflate(byte[] byArray, byte[] byArray2) {
        if (inflater == null) {
            inflater = new Inflater(true);
        }
        Inflater inflater = ZipFileIndex.inflater;
        synchronized (inflater) {
            ZipFileIndex.inflater.reset();
            ZipFileIndex.inflater.setInput(byArray);
            try {
                return ZipFileIndex.inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                return -1;
            }
        }
    }

    private static int get2ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    private static int get4ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZipFileLastModified() throws IOException {
        lock.lock();
        try {
            this.checkIndex();
            long l = this.zipFileLastModified;
            Object var4_2 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean readIndex() {
        if (this.triedToReadIndex || !this.usePreindexedCache) {
            return false;
        }
        var1_1 = false;
        ZipFileIndex.lock.lock();
        try {
            block18: {
                this.triedToReadIndex = true;
                var2_2 = null;
                try {
                    block17: {
                        var3_3 = this.getIndexFile();
                        var2_2 = new RandomAccessFile(var3_3, "r");
                        var4_5 = var2_2.readLong();
                        if (this.zipFile.lastModified() != var4_5) {
                            var1_1 = false;
                            break block17;
                        }
                        this.directories = new HashMap<RelativePath.RelativeDirectory, DirectoryEntry>();
                        var6_6 = var2_2.readInt();
                        for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
                            var8_8 = var2_2.readInt();
                            var9_9 = new byte[var8_8];
                            var2_2.read(var9_9);
                            var10_10 = this.getRelativeDirectory(new String(var9_9, "UTF-8"));
                            var11_11 = new DirectoryEntry(var10_10, this);
                            DirectoryEntry.access$1502(var11_11, var2_2.readInt());
                            DirectoryEntry.access$1602(var11_11, var2_2.readLong());
                            this.directories.put(var10_10, var11_11);
                        }
                        var1_1 = true;
                        this.zipFileLastModified = var4_5;
                    }
                    var13_12 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var12_18) {
                    var13_14 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Throwable var14_17) {
                            // empty catch block
                        }
                    }
                    throw var12_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (Throwable var14_15) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (Throwable var3_4) {
                        var13_13 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (Throwable var14_16) {}
                        }
                    }
                }
            }
            if (var1_1) {
                this.readFromIndex = true;
            }
            var16_19 = null;
            ZipFileIndex.lock.unlock();
        }
        catch (Throwable var15_21) {
            var16_20 = null;
            ZipFileIndex.lock.unlock();
            throw var15_21;
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private boolean writeIndex() {
        boolean bl;
        block17: {
            bl = false;
            if (this.readFromIndex || !this.usePreindexedCache) {
                return true;
            }
            if (!this.writeIndex) {
                return true;
            }
            File file = this.getIndexFile();
            if (file == null) {
                return false;
            }
            RandomAccessFile randomAccessFile = null;
            long l = 0L;
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeLong(this.zipFileLastModified);
            l += 8L;
            ArrayList<DirectoryEntry> arrayList = new ArrayList<DirectoryEntry>();
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            randomAccessFile.writeInt(this.directories.keySet().size());
            l += 4L;
            for (Object object : this.directories.keySet()) {
                DirectoryEntry directoryEntry = this.directories.get(object);
                arrayList.add(directoryEntry);
                byte[] byArray = ((RelativePath)object).getPath().getBytes("UTF-8");
                int n = byArray.length;
                randomAccessFile.writeInt(n);
                l += 4L;
                randomAccessFile.write(byArray);
                l += (long)n;
                java.util.List<Entry> list = directoryEntry.getEntriesAsCollection();
                randomAccessFile.writeInt(list.size());
                hashMap.put(object, new Long(l += 4L));
                directoryEntry.writtenOffsetOffset = 0L;
                randomAccessFile.writeLong(0L);
                l += 8L;
            }
            for (Object object : arrayList) {
                long l2 = randomAccessFile.getFilePointer();
                long l3 = (Long)hashMap.get(((DirectoryEntry)object).dirName);
                randomAccessFile.seek(l3);
                randomAccessFile.writeLong(l);
                randomAccessFile.seek(l2);
                java.util.List<Entry> list = ((DirectoryEntry)object).getEntriesAsCollection();
                for (Entry entry : list) {
                    byte[] byArray = entry.name.getBytes("UTF-8");
                    int n = byArray.length;
                    randomAccessFile.writeInt(n);
                    l += 4L;
                    randomAccessFile.write(byArray);
                    l += (long)n;
                    randomAccessFile.writeByte(entry.isDir ? 1 : 0);
                    ++l;
                    randomAccessFile.writeInt(entry.offset);
                    l += 4L;
                    randomAccessFile.writeInt(entry.size);
                    l += 4L;
                    randomAccessFile.writeInt(entry.compressedSize);
                    l += 4L;
                    randomAccessFile.writeLong(entry.getLastModified());
                    l += 8L;
                }
            }
            Object var20_21 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block17;
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (Throwable throwable) {
                    Object var20_22 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeZipIndex() {
        lock.lock();
        try {
            boolean bl = this.writeIndex();
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private File getIndexFile() {
        if (this.zipIndexFile == null) {
            if (this.zipFile == null) {
                return null;
            }
            this.zipIndexFile = new File((this.preindexedCacheLocation == null ? "" : this.preindexedCacheLocation) + this.zipFile.getName() + ".index");
        }
        return this.zipIndexFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    File getAbsoluteFile() {
        File file;
        File file2 = file = this.absFileRef == null ? null : this.absFileRef.get();
        if (file == null) {
            file = this.zipFile.getAbsoluteFile();
            this.absFileRef = new SoftReference<File>(file);
        }
        return file;
    }

    private RelativePath.RelativeDirectory getRelativeDirectory(String string) {
        RelativePath.RelativeDirectory relativeDirectory;
        SoftReference<RelativePath.RelativeDirectory> softReference = this.relativeDirectoryCache.get(string);
        if (softReference != null && (relativeDirectory = softReference.get()) != null) {
            return relativeDirectory;
        }
        relativeDirectory = new RelativePath.RelativeDirectory(string);
        this.relativeDirectoryCache.put(string, new SoftReference<RelativePath.RelativeDirectory>(relativeDirectory));
        return relativeDirectory;
    }

    static /* synthetic */ Entry[] access$802(ZipFileIndex zipFileIndex, Entry[] entryArray) {
        zipFileIndex.entries = entryArray;
        return entryArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry
    implements Comparable<Entry> {
        public static final Entry[] EMPTY_ARRAY = new Entry[0];
        RelativePath.RelativeDirectory dir;
        boolean isDir;
        String name;
        int offset;
        int size;
        int compressedSize;
        long javatime;
        private int nativetime;

        public Entry(RelativePath relativePath) {
            this(relativePath.dirname(), relativePath.basename());
        }

        public Entry(RelativePath.RelativeDirectory relativeDirectory, String string) {
            this.dir = relativeDirectory;
            this.name = string;
        }

        public String getName() {
            return new RelativePath.RelativeFile(this.dir, this.name).getPath();
        }

        public String getFileName() {
            return this.name;
        }

        public long getLastModified() {
            if (this.javatime == 0L) {
                this.javatime = Entry.dosToJavaTime(this.nativetime);
            }
            return this.javatime;
        }

        private static long dosToJavaTime(int n) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, (n >> 25 & 0x7F) + 1980);
            calendar.set(2, (n >> 21 & 0xF) - 1);
            calendar.set(5, n >> 16 & 0x1F);
            calendar.set(11, n >> 11 & 0x1F);
            calendar.set(12, n >> 5 & 0x3F);
            calendar.set(13, n << 1 & 0x3E);
            calendar.set(14, 0);
            return calendar.getTimeInMillis();
        }

        void setNativeTime(int n) {
            this.nativetime = n;
        }

        public boolean isDirectory() {
            return this.isDir;
        }

        @Override
        public int compareTo(Entry entry) {
            int n;
            RelativePath.RelativeDirectory relativeDirectory = entry.dir;
            if (this.dir != relativeDirectory && (n = this.dir.compareTo(relativeDirectory)) != 0) {
                return n;
            }
            return this.name.compareTo(entry.name);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.dir.equals(entry.dir) && this.name.equals(entry.name);
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.dir != null ? this.dir.hashCode() : 0);
            n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.isDir ? "Dir:" + this.dir + " : " + this.name : this.dir + ":" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DirectoryEntry {
        private boolean filesInited = false;
        private boolean directoriesInited = false;
        private boolean zipFileEntriesInited;
        private boolean entriesInited = false;
        private long writtenOffsetOffset = 0L;
        private RelativePath.RelativeDirectory dirName;
        private List<String> zipFileEntriesFiles = List.nil();
        private List<String> zipFileEntriesDirectories = List.nil();
        private List<Entry> zipFileEntries = List.nil();
        private java.util.List<Entry> entries = new ArrayList<Entry>();
        private ZipFileIndex zipFileIndex;
        private int numEntries;

        DirectoryEntry(RelativePath.RelativeDirectory relativeDirectory, ZipFileIndex zipFileIndex) {
            this.dirName = relativeDirectory;
            this.zipFileIndex = zipFileIndex;
        }

        private List<String> getFiles() {
            if (!this.filesInited) {
                this.initEntries();
                for (Entry entry : this.entries) {
                    if (entry.isDir) continue;
                    this.zipFileEntriesFiles = this.zipFileEntriesFiles.append(entry.name);
                }
                this.filesInited = true;
            }
            return this.zipFileEntriesFiles;
        }

        private List<String> getDirectories() {
            if (!this.directoriesInited) {
                this.initEntries();
                for (Entry entry : this.entries) {
                    if (!entry.isDir) continue;
                    this.zipFileEntriesDirectories = this.zipFileEntriesDirectories.append(entry.name);
                }
                this.directoriesInited = true;
            }
            return this.zipFileEntriesDirectories;
        }

        private List<Entry> getEntries() {
            if (!this.zipFileEntriesInited) {
                this.initEntries();
                this.zipFileEntries = List.nil();
                for (Entry entry : this.entries) {
                    this.zipFileEntries = this.zipFileEntries.append(entry);
                }
                this.zipFileEntriesInited = true;
            }
            return this.zipFileEntries;
        }

        private Entry getEntry(String string) {
            this.initEntries();
            int n = Collections.binarySearch(this.entries, new Entry(this.dirName, string));
            if (n < 0) {
                return null;
            }
            return this.entries.get(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void initEntries() {
            block15: {
                block16: {
                    if (this.entriesInited) {
                        return;
                    }
                    if (this.zipFileIndex.readFromIndex) break block16;
                    int n = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MIN_CHAR)) - 1;
                    int n2 = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MAX_CHAR)) - 1;
                    for (int i = n; i < n2; ++i) {
                        this.entries.add(this.zipFileIndex.entries[i]);
                    }
                    break block15;
                }
                File file = this.zipFileIndex.getIndexFile();
                if (file != null) {
                    RandomAccessFile randomAccessFile = null;
                    randomAccessFile = new RandomAccessFile(file, "r");
                    randomAccessFile.seek(this.writtenOffsetOffset);
                    for (int i = 0; i < this.numEntries; ++i) {
                        int n = randomAccessFile.readInt();
                        byte[] byArray = new byte[n];
                        randomAccessFile.read(byArray);
                        String string = new String(byArray, "UTF-8");
                        boolean bl = randomAccessFile.readByte() != 0;
                        int n3 = randomAccessFile.readInt();
                        int n4 = randomAccessFile.readInt();
                        int n5 = randomAccessFile.readInt();
                        long l = randomAccessFile.readLong();
                        Entry entry = new Entry(this.dirName, string);
                        entry.isDir = bl;
                        entry.offset = n3;
                        entry.size = n4;
                        entry.compressedSize = n5;
                        entry.javatime = l;
                        this.entries.add(entry);
                    }
                    Object var15_17 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {}
                    break block15;
                    {
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            try {
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                                break block15;
                            }
                            catch (Throwable throwable2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            this.entriesInited = true;
        }

        java.util.List<Entry> getEntriesAsCollection() {
            this.initEntries();
            return this.entries;
        }

        static /* synthetic */ int access$1502(DirectoryEntry directoryEntry, int n) {
            directoryEntry.numEntries = n;
            return directoryEntry.numEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZipDirectory {
        private RelativePath.RelativeDirectory lastDir;
        private int lastStart;
        private int lastLen;
        byte[] zipDir;
        RandomAccessFile zipRandomFile = null;
        ZipFileIndex zipFileIndex = null;

        public ZipDirectory(RandomAccessFile randomAccessFile, long l, long l2, ZipFileIndex zipFileIndex2) throws IOException {
            this.zipRandomFile = randomAccessFile;
            this.zipFileIndex = zipFileIndex2;
            this.findCENRecord(l, l2);
        }

        private void findCENRecord(long l, long l2) throws IOException {
            long l3 = l2 - l;
            int n = 1024;
            byte[] byArray = new byte[n];
            long l4 = l2 - l;
            while (l4 >= 22L) {
                int n2;
                if (l4 < (long)n) {
                    n = (int)l4;
                }
                long l5 = l4 - (long)n;
                this.zipRandomFile.seek(l + l5);
                this.zipRandomFile.readFully(byArray, 0, n);
                for (n2 = n - 22; n2 >= 0 && (byArray[n2] != 80 || byArray[n2 + 1] != 75 || byArray[n2 + 2] != 5 || byArray[n2 + 3] != 6 || l5 + (long)n2 + 22L + (long)ZipFileIndex.get2ByteLittleEndian(byArray, n2 + 20) != l3); --n2) {
                }
                if (n2 >= 0) {
                    this.zipDir = new byte[ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 12) + 2];
                    this.zipDir[0] = byArray[n2 + 10];
                    this.zipDir[1] = byArray[n2 + 11];
                    this.zipRandomFile.seek(l + (long)ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 16));
                    this.zipRandomFile.readFully(this.zipDir, 2, this.zipDir.length - 2);
                    return;
                }
                l4 = l5 + 21L;
            }
            throw new ZipException("cannot read zip file");
        }

        private void buildIndex() throws IOException {
            int n = ZipFileIndex.get2ByteLittleEndian(this.zipDir, 0);
            if (n > 0) {
                ZipFileIndex.this.directories = new HashMap();
                ArrayList<Entry> arrayList = new ArrayList<Entry>();
                int n2 = 2;
                for (int i = 0; i < n; ++i) {
                    n2 = this.readEntry(n2, arrayList, ZipFileIndex.this.directories);
                }
                for (RelativePath.RelativeDirectory relativeDirectory : ZipFileIndex.this.directories.keySet()) {
                    RelativePath.RelativeDirectory relativeDirectory2 = ZipFileIndex.this.getRelativeDirectory(relativeDirectory.dirname().getPath());
                    String string = relativeDirectory.basename();
                    Entry entry = new Entry(relativeDirectory2, string);
                    entry.isDir = true;
                    arrayList.add(entry);
                }
                ZipFileIndex.access$802(ZipFileIndex.this, arrayList.toArray(new Entry[arrayList.size()]));
                Arrays.sort(ZipFileIndex.this.entries);
            } else {
                ZipFileIndex.this.cleanupState();
            }
        }

        private int readEntry(int n, java.util.List<Entry> list, Map<RelativePath.RelativeDirectory, DirectoryEntry> map) throws IOException {
            int n2;
            int n3;
            if (ZipFileIndex.get4ByteLittleEndian(this.zipDir, n) != 33639248) {
                throw new ZipException("cannot read zip file entry");
            }
            int n4 = n3 = n + 46;
            int n5 = n4 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28);
            if (this.zipFileIndex.symbolFilePrefixLength != 0 && n5 - n4 >= ZipFileIndex.this.symbolFilePrefixLength) {
                n3 += this.zipFileIndex.symbolFilePrefixLength;
                n4 += this.zipFileIndex.symbolFilePrefixLength;
            }
            for (int i = n4; i < n5; ++i) {
                n2 = this.zipDir[i];
                if (n2 == 92) {
                    this.zipDir[i] = 47;
                    n4 = i + 1;
                    continue;
                }
                if (n2 != 47) continue;
                n4 = i + 1;
            }
            RelativePath.RelativeDirectory relativeDirectory = null;
            if (n4 == n3) {
                relativeDirectory = ZipFileIndex.this.getRelativeDirectory("");
            } else if (this.lastDir != null && this.lastLen == n4 - n3 - 1) {
                n2 = this.lastLen - 1;
                while (this.zipDir[this.lastStart + n2] == this.zipDir[n3 + n2]) {
                    if (n2 == 0) {
                        relativeDirectory = this.lastDir;
                        break;
                    }
                    --n2;
                }
            }
            if (relativeDirectory == null) {
                this.lastStart = n3;
                this.lastLen = n4 - n3 - 1;
                this.lastDir = relativeDirectory = ZipFileIndex.this.getRelativeDirectory(new String(this.zipDir, n3, this.lastLen, "UTF-8"));
                RelativePath.RelativeDirectory relativeDirectory2 = relativeDirectory;
                while (map.get(relativeDirectory2) == null) {
                    map.put(relativeDirectory2, new DirectoryEntry(relativeDirectory2, this.zipFileIndex));
                    if (relativeDirectory2.path.indexOf("/") != relativeDirectory2.path.length() - 1) {
                        relativeDirectory2 = ZipFileIndex.this.getRelativeDirectory(relativeDirectory2.dirname().getPath());
                        continue;
                    }
                    break;
                }
            } else if (map.get(relativeDirectory) == null) {
                map.put(relativeDirectory, new DirectoryEntry(relativeDirectory, this.zipFileIndex));
            }
            if (n4 != n5) {
                Entry entry = new Entry(relativeDirectory, new String(this.zipDir, n4, n5 - n4, "UTF-8"));
                entry.setNativeTime(ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 12));
                entry.compressedSize = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 20);
                entry.size = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 24);
                entry.offset = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 42);
                list.add(entry);
            }
            return n + 46 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 30) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 32);
        }
    }
}

