/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_CL)


#include "iclshell.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "iinteractoreventrecorder.h"
#include "ioutputchannel.h"
#include "iviewmodule.h"

#include "iclcommandinterpreter.h"

#include <vtkToolkits.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>


class iclOutputChannel : public iOutputChannel
{

public:

	iclOutputChannel(iShell *s) : iOutputChannel(s)
	{
	}

protected:

	virtual void DisplayBody(iConsole::MessageType type, const iString &message, const char *file, int line)
	{
		iString text = this->FormPlainTextMessage(type,message,file,line);

		switch(type)
		{
		case iConsole::_Info:
			{
				cout << text.ToCharPointer();
				break;
			}
		case iConsole::_Warning:
		case iConsole::_LowError:
		case iConsole::_HighError:
		case iConsole::_FatalError:
			{
				cerr << text.ToCharPointer();
				break;
			}
		case iConsole::_Notification:
			{
				char c;
				cout << text.ToCharPointer() << endl;
				cout << "Proceed? (y/n)" << endl;
				c = getchar();
				if(c != 'y') exit(0);
				break;
			}
		}
	}
};


iclShell::iclShell(int argc, char **argv) : iShell("cl",argc,argv)
{
	mInterpreter = 0; // must be constructed when the shell is complete.
	mContinue = false;
}


iclShell::~iclShell()
{
}


void iclShell::DefineSpecificCommandLineOptions()
{
}


void iclShell::PrepareForConstruction()
{
	cout << "IFrIT is being initialized...\r";
	cout.flush();
}


void iclShell::ConstructorBody()
{
	mInterpreter = new iclCommandInterpreter(this); IERROR_ASSERT(mInterpreter);
	iOutputChannel::SetInstance(new iclOutputChannel(this));
}

  
void iclShell::DestructorBody()
{
	mInterpreter->Stop();
	mInterpreter->Delete();
}


void iclShell::PrepareToLoadStateFile()
{
}


void iclShell::Start()
{
	int i;
	for(i=0; i<this->ControlModule()->GetNumberOfViewModules(); i++)
	{
		this->ControlModule()->GetViewModule(i)->GetInteractor()->Disable();
		this->ControlModule()->GetViewModule(i)->SetAntialiasing(true);
	}
	this->ControlModule()->Render();  // render all windows
	mInterpreter->Start();

	mContinue = true;
}


void iclShell::Exit()
{
	mContinue = false;
}


void iclShell::RunBody()
{
	//
	//  This is our event loop
	//
	while(mContinue && mInterpreter->Exec()==0)
	{
		this->ControlModule()->GetViewModule()->GetInteractor()->Enable();
		this->ControlModule()->GetViewModule()->GetEventRecorder()->SetInteractor(0); // does not work with this shell
		this->ControlModule()->GetViewModule()->GetInteractor()->Start();
		this->ControlModule()->GetViewModule()->GetInteractor()->Disable();
	}
}


bool iclShell::AnalyseOneExtendedCommandLineOption(const struct Option&)
{
	return false;
}


//
//  State saving
//
bool iclShell::LoadShellStateFromFileBody(iFile &)
{
	//
	//  Nothing to do here
	//
	return true;
}


bool iclShell::SaveShellStateToFileBody(iFile &) const
{
	//
	//  Nothing to do here
	//
	return true;
}

#endif
