/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __GUI_USER_H__
#define __GUI_USER_H__

#include <qstring.h>


class FileInfos
   {
   public:
      FileInfos() : sub_file_tree(NULL), ftype(-1), fsize(0), fprocessed(0) { }
      FileInfos(const QString& filename, int filetype, int filesize, void *context)
         : sub_file_tree(NULL), fname(filename), ftype(filetype), fsize(filesize), fprocessed(0), cntx(context)
      { }

      void setValues(const QString& filename, int filetype, int filesize, void *context)
         {
         fname = filename;
         ftype = filetype;
         fsize = filesize;
         cntx  = context;
         };
      void setValues(const QString& filename, int filetype, int filesize)
         {
         fname = filename;
         ftype = filetype;
         fsize = filesize;
         };
      void setValues(int filetype, int filesize)
         {
         ftype = filetype;
         fsize = filesize;
         };
      void copy(const FileInfos *fi_to_copy)
         {
         fname = fi_to_copy->FileName();
         ftype = fi_to_copy->FileType();
         fsize = fi_to_copy->FileSize();
         cntx = fi_to_copy->Context();
         }
      void setProcessed(int value) { fprocessed = value; }

      QString FileName() const { return fname; }
      int     FileType() const { return ftype; }
      int     FileSize() const { return fsize; }
      int     Processed() const { return fprocessed; }
      void *  Context() const { return cntx; }
      QPtrList<FileInfos> *sub_file_tree;

   private:
      QString fname;
      int ftype;
      int fsize;
      int fprocessed;
      void *cntx;
   };

#ifdef __cplusplus
extern "C" {
#endif

extern QPtrList<FileInfos> new_ifp_file_tree;
extern QString iFPNotConnectedMsg;
extern int ifp_get_info(QString filename, FileInfos **finfo);
extern int ifp_get_dir_size(QString filename, int *filecnt);

extern int ifp_get_file_list(struct ifp_device * dev, QString& filename, QPtrList<FileInfos> *list);
extern int ifp_read_file_tree();

extern int iFPgetFileList(const QString& filename, QPtrList<FileInfos> *list);
extern int iFPdownloadFile(const QString& sfilename, const QString& destDir, void* fn_context);
extern int iFPdownloadDirectory(const QString& sdirname, const QString& destDir, void* fn_context);
extern int iFPuploadFile(const QString& sfilename, const QString& destDir, void* fn_context);
extern int iFPuploadDirectory(const QString& sdirname, const QString& destDir, void* fn_context);

extern int showYesNoAllMsgBox(const QString& msgH, const QString& msgB);
extern void showInfoMsgBox(const QString& msgH, const QString& msgB);
extern void backslash2slash(QString& str);
extern void slash2backslash(QString& str);

extern int local_get_dir_size(QString dirName, int *filecnt);
#ifdef __cplusplus
}
#endif

#endif //__GUI_USER_H__
