package CParse::Parser::Token::Keyword;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $string = shift;
    my $line = shift;
    my $pos = shift;

    if ($string eq '__const' or $string eq '__restrict' or $string eq '__volatile')
      {
        $string =~ s/^__//;
      }
    if ($string eq '__const__' or $string eq '__restrict__' or $string eq '__volatile__')
      {
        $string =~ s/^__//;
        $string =~ s/__$//;
      }
    if ($string eq '__inline')
      {
        $string = 'inline';
      }
    if ($string eq '__inline__')
      {
        $string = 'inline';
      }
    if ($string eq '__attribute')
      {
        $string = '__attribute__';
      }
    if ($string eq 'asm')
      {
        $string = '__asm__';
      }

    my $self = {string => $string,
                line => $line,
                pos => $pos,
               };
    bless $self, $class;
    return $self;
  }

sub line
  {
    my $self = shift;
    return $self->{line};
  }

sub pos
  {
    my $self = shift;
    return $self->{pos};
  }

sub string
  {
    my $self = shift;
    return $self->{string};
  }

sub dump_c
  {
    my $self = shift;

    return $self->{string};
  }

1;
