///////
   //    _Url.h
   //    _Url Class declaration
   //
   //    Class to interface with Url table of mysql Database
   //    This inherits from the Url class.
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Url.h,v 1.22 2004/05/26 08:34:10 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.07.1999
///////

#ifndef __URL_H
#define __URL_H

#include "_Server.h"
#include "URL.h"
#include "HtDateTime.h"

class _Url : public URL
{
   public:
   
      // Construction / Destruction
      _Url();
      _Url(const String &url);
      _Url(const _Url &url);
      _Url(const String &ref, _Url &parent);
      virtual ~_Url();

      enum Url_ConnStatus
      {
         Url_OK,
         Url_NoHeader,
         Url_NoHost,
         Url_NoPort,
         Url_NoConnection,
         Url_ConnectionDown,
         Url_ServiceNotValid,
         Url_ServerError,
         Url_OtherError
      };

      enum Url_DocType
      {
            Url_Undefined,
            Url_Not_Public,
            Url_Not_Html,
            Url_XHtml_11_Strict,
            Url_XHtml_10_Strict,
            Url_XHtml_10_Transitional,
            Url_XHtml_10_Frameset,
            Url_Html_401_Strict,
            Url_Html_401_Transitional,
            Url_Html_401_Frameset,
            Url_Html_40_Strict,
            Url_Html_40_Transitional,
            Url_Html_40_Frameset,
			Url_Html_ISO_IEC_15445_2000,
			Url_Html_32,
			Url_Html_20,
			Url_Html_20_Level2,
			Url_Html_20_Level1,
			Url_Html_20_Strict,
			Url_Html_20_Strict_Level1,
            Url_Unknown
      };

///////
   //    Public Interface
///////

      void Reset();
      
///////
   //    Interface with protected methods
///////

      void SetID (unsigned int ID) { IDUrl = ID; }
      void SetIDServer (unsigned int ID) { IDServer = ID; }
      void SetContentType (const String &Ct);
      void SetTransferEncoding (const String &Te) { TransferEncoding = Te; }
      void SetLastModified (HtDateTime *d);
      void SetLastAccess (HtDateTime *d) { LastAccess = d; }
      void SetSize (long s) { Size = s; }
      void SetStatusCode (unsigned int sc) { StatusCode = sc; }
      void SetReasonPhrase (const String &rp) { ReasonPhrase = rp; }
      void SetLocation (const String &l) { Location = l; }
      void SetContentLanguage (const String &cl) { ContentLanguage = cl; }
      void SetServer (_Server *s) { pServer = s; }
      void SetConnStatus (Url_ConnStatus s) { ConnStatus = s; }

      void RetrieveConnStatus (String &) const; // Insert into a string the value
                                          // for the ConnStatus
                                          // (converts a Url_ConnStatus
                                          // value into a String).

                                       
      void RetrieveDocType (String &) const; // Insert into a string the value
                                          // for the DocType
                                          // (converts a Url_DocType
                                          // value into a String).

                                       
      int SetConnStatus (const String &Status);   // Set the Url_ConnStatus value
                                          // depending on the Status value
      
      int SetDocType (const String &DocType);   // Set the Url_DocType value
                                          // depending on the DocType value
      

      // Info regarding the web page
      void SetTitle (const String &t) { Title = t; }
      void SetContents (const String* const c) { Contents = c; }
      void SetCharset (const String &c) { Charset = c; }
      void SetDocType (Url_DocType d) { DocType = d; }
      void SetDescription (const String &d) { Description = d; }
      void SetKeywords (const String &k) { Keywords = k; }
      
      unsigned int GetID () const { return IDUrl; }
      unsigned int GetIDServer () const { return IDServer; }
      const String &GetContentType () const { return ContentType; }
      const String &GetTransferEncoding () const { return TransferEncoding; }
      const HtDateTime *GetLastModified () const;
      const HtDateTime *GetLastAccess () const { return LastAccess; }
      long GetSize() const { return Size; }
      unsigned int GetStatusCode() const { return StatusCode; }
      const String &GetReasonPhrase() const { return ReasonPhrase; }
      const String &GetLocation() const { return Location; }
      const String &GetContentLanguage() const { return ContentLanguage; }
      const _Server *GetServer() const { return pServer; }
      const String &GetTitle() const { return Title; }
      const String* const GetContents() const { return Contents; }
      const String &GetCharset() const { return Charset; }
      Url_DocType GetDocType() const { return DocType; }
      Url_ConnStatus GetConnStatus() const { return ConnStatus; }
      void HideLastModified() { _HideLastModified = true; }
      const String &GetDescription() const { return Description; }
      const String &GetKeywords() const { return Keywords; }



///////
   //    Static Methods
///////

      static unsigned int GetTotUrls () { return TotUrls; }
      static unsigned int IncrementTotUrls () { return ++TotUrls; }
      
   protected:
   
      // It inherits every attribute from the Url class

      unsigned int      IDUrl;
      unsigned int      IDServer;
      String            ContentType;
      String            TransferEncoding;
      HtDateTime        *LastModified;
      HtDateTime        *LastAccess;
      long              Size;
      unsigned int      StatusCode;
      String            ReasonPhrase;
      String            Location;
      _Server           *pServer;
      String            Title;      // Web Page title
      Url_ConnStatus    ConnStatus;
      String            ContentLanguage;  // Language code given by the server
      const String*     Contents;   // Contents of the retrieved URL
      String            Charset;
      Url_DocType       DocType;
      String            Description;
      String            Keywords;

      // In certain cases it is useful to hide the LastModified value
      // like for not found documents, etc ...
      bool              _HideLastModified;

///////
   //    Static variable storing the number of Url "crawled"
   //    It's designed for assigning the IDUrl, in a incremental way
///////

      static unsigned int TotUrls;
};

#endif
