/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <clutter/clutter.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "hrn.h"
#include "hrn-button.h"

G_DEFINE_TYPE (HrnButton, hrn_button, NBTK_TYPE_BUTTON);

#define HRN_BUTTON_GET_PRIVATE(obj)                 \
  (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                                HRN_TYPE_BUTTON, \
                                HrnButtonPrivate))


static gboolean
hrn_button_release_event (ClutterActor *actor, ClutterButtonEvent *event)
{
  if (event->modifier_state &
      (CLUTTER_SHIFT_MASK | CLUTTER_CONTROL_MASK))
    return FALSE;

  return CLUTTER_ACTOR_CLASS (hrn_button_parent_class)->button_release_event
                        (actor, event);
}

static gboolean
hrn_button_press_event (ClutterActor *actor, ClutterButtonEvent *event)
{
  if (event->modifier_state &
      (CLUTTER_SHIFT_MASK | CLUTTER_CONTROL_MASK))
    return FALSE;

  return CLUTTER_ACTOR_CLASS (hrn_button_parent_class)->button_press_event (
           actor, event);
}

static void
hrn_button_class_init (HrnButtonClass *klass)
{
  ClutterActorClass *actor_class = CLUTTER_ACTOR_CLASS (klass);

  actor_class->button_release_event = hrn_button_release_event;
  actor_class->button_press_event   = hrn_button_press_event;
}

static void
hrn_button_init (HrnButton *self)
{
}

NbtkWidget *
hrn_button_new (void)
{
  return NBTK_WIDGET (g_object_new (HRN_TYPE_BUTTON, NULL));
}
