{- This module was generated from data in the Kate syntax
   highlighting file mandoc.xml, version 0.11, by Matthew Woehlke (mw_triad@users.sourceforge.net) -}

module Text.Highlighting.Kate.Syntax.Mandoc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Troff Mandoc"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.1;*.2;*.3;*.4;*.5;*.6;*.7;*.8;*.1m;*.3x;*.tmac"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Troff Mandoc" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Troff Mandoc",["Normal"])], synStLanguage = "Troff Mandoc", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "DetectDirective" -> (popContext) >> pEndLine
    "Directive" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_headings = Set.fromList $ words $ "SH SS TH"
list_paragraph = Set.fromList $ words $ "HP IP LP P PD PP RE RS TP"
list_formatting = Set.fromList $ words $ "B BI BR I IB IR RB RI SM SB"
list_others = Set.fromList $ words $ "DT"


defaultAttributes = [("Normal",NormalTok),("DetectDirective",FunctionTok),("Directive",StringTok)]

parseRules "Normal" =
  (((parseRules "DetectComments##Roff"))
   <|>
   ((pColumn 0 >> pDetectChar False '.' >>= withAttribute FunctionTok) >>~ pushContext "DetectDirective")
   <|>
   ((parseRules "DetectOthers##Roff")))

parseRules "DetectDirective" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_headings >>= withAttribute KeywordTok) >>~ pushContext "Directive")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_paragraph >>= withAttribute DataTypeTok) >>~ pushContext "Directive")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_formatting >>= withAttribute KeywordTok) >>~ pushContext "Directive")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_others >>= withAttribute FunctionTok) >>~ pushContext "Directive")
   <|>
   ((parseRules "DetectDirective##Roff")))

parseRules "Directive" =
  ((parseRules "Directive##Roff"))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
