{- This module was generated from data in the Kate syntax highlighting file xorg.xml, version 1.01,
   by  Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Xorg ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "x.org Configuration"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "xorg.conf"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "x.org Configuration" }
  context <- currentContext <|> (pushContext "xorg" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("x.org Configuration",["xorg"])], synStLanguage = "x.org Configuration", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "xorg" -> return () >> pHandleEndLine
    "Section" -> return () >> pHandleEndLine
    "Section Content" -> return () >> pHandleEndLine
    "Keyword" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Section","fu"),("Section Name","st"),("Value","dt"),("Keyword","kw"),("Alert","er"),("Int","dv"),("Value2","ot"),("Float","fl"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'5cb'5cw'2b'5cb = compileRegex "\\b\\w+\\b"
regex_'5b'5cw'5cd'5d'2b = compileRegex "[\\w\\d]+"

defaultAttributes = [("xorg","Normal Text"),("Section","Normal Text"),("Section Content","Normal Text"),("Keyword","Keyword"),("Comment","Comment")]

parseRules "xorg" = 
  do (attr, result) <- (((pString False "Section" >>= withAttribute "Section") >>~ pushContext "Section")
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Normal Text") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Section" = 
  do (attr, result) <- (((pRangeDetect '"' '"' >>= withAttribute "Section Name") >>~ pushContext "Section Content")
                        <|>
                        ((pRangeDetect '\'' '\'' >>= withAttribute "Section Name") >>~ pushContext "Section Content")
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Alert"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Normal Text") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Section Content" = 
  do (attr, result) <- (((pString False "EndSection" >>= withAttribute "Section") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "EndSubSection" >>= withAttribute "Section") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "SubSection" >>= withAttribute "Section") >>~ pushContext "Section")
                        <|>
                        ((pRegExpr regex_'5cb'5cw'2b'5cb >>= withAttribute "Normal Text") >>~ pushContext "Keyword")
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Normal Text") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Keyword" = 
  do (attr, result) <- (((pRangeDetect '"' '"' >>= withAttribute "Value"))
                        <|>
                        ((pRangeDetect '\'' '\'' >>= withAttribute "Value"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Int"))
                        <|>
                        ((pRegExpr regex_'5b'5cw'5cd'5d'2b >>= withAttribute "Value2"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Keyword") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Comment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
