{- This module was generated from data in the Kate syntax highlighting file gdb.xml, version 1.0,
   by  Milian Wolff (mail@milianw.de) -}

module Text.Highlighting.Kate.Syntax.Gdb ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "GDB Backtrace"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.kcrash;*.crash;*.bt"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "GDB Backtrace" }
  context <- currentContext <|> (pushContext "apache" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("GDB Backtrace",["apache"])], synStLanguage = "GDB Backtrace", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "apache" -> return () >> pHandleEndLine
    "oneliners" -> (popContext) >> pEndLine
    "stackframe" -> return () >> pHandleEndLine
    "identifier" -> return () >> pHandleEndLine
    "file" -> (popContext >> popContext) >> pEndLine
    "thread" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Crash","er"),("QualifiedIdentifier","ot"),("Function","fu"),("File","dt"),("Thread","bn")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'28'28'3f'3a'5b'5e_'5d'7c'3c'2e'2b'3e'29'2b'3a'3a'29'3f'28'5b'5e_'3a'5d'2b'29'5cs'2a'5c'28 = compileRegex "((?:[^ ]|<.+>)+::)?([^ :]+)\\s*\\("
regex_'5cb0x0'5cb = compileRegex "\\b0x0\\b"

defaultAttributes = [("apache","Normal"),("oneliners","Normal"),("stackframe","Normal"),("identifier","Normal"),("file","File"),("thread","Thread")]

parseRules "apache" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Normal") >>~ pushContext "stackframe")
                        <|>
                        ((parseRules "oneliners")))
     return (attr, result)

parseRules "oneliners" = 
  do (attr, result) <- (((pString False "[KCrash Handler]" >>= withAttribute "Crash"))
                        <|>
                        ((pFirstNonSpace >> pString False "Thread" >>= withAttribute "Normal") >>~ pushContext "thread")
                        <|>
                        ((pFirstNonSpace >> pString False "[Current thread" >>= withAttribute "Normal") >>~ pushContext "thread"))
     return (attr, result)

parseRules "stackframe" = 
  do (attr, result) <- (((lookAhead (pRegExpr regex_'28'28'3f'3a'5b'5e_'5d'7c'3c'2e'2b'3e'29'2b'3a'3a'29'3f'28'5b'5e_'3a'5d'2b'29'5cs'2a'5c'28) >> return ([],"") ) >>~ pushContext "identifier")
                        <|>
                        ((pString False "at" >>= withAttribute "Normal") >>~ pushContext "file")
                        <|>
                        ((pString False "from" >>= withAttribute "Normal") >>~ pushContext "file")
                        <|>
                        ((parseRules "oneliners")))
     return (attr, result)

parseRules "identifier" = 
  do (attr, result) <- (((pString True "%1" >>= withAttribute "QualifiedIdentifier"))
                        <|>
                        ((pString True "%2" >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'5cb0x0'5cb >>= withAttribute "Crash"))
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Normal") >>~ (popContext)))
     return (attr, result)

parseRules "file" = 
  do (attr, result) <- ((pDetectChar False ':' >>= withAttribute "Normal") >>~ (popContext >> popContext))
     return (attr, result)

parseRules "thread" = 
  pzero

parseRules x = fail $ "Unknown context" ++ x
