{- This module was generated from data in the Kate syntax highlighting file erlang.xml, version 1.02,
   by  Bill Ross (bill@emailme.net.au) -}

module Text.Highlighting.Kate.Syntax.Erlang ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Erlang"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.erl"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Erlang" }
  context <- currentContext <|> (pushContext "Normal Text" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Erlang",["Normal Text"])], synStLanguage = "Erlang", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal Text" -> (popContext >> return ())
    "isfunction" -> (popContext >> return ())
    "atomquote" -> (popContext >> return ())
    "stringquote" -> (popContext >> return ())
    "comment" -> (popContext >> return ())
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Pragma","kw"),("Function","fu"),("Separator","fu"),("Operator","kw"),("Variable","dt"),("Integer","dv"),("Number","bn"),("Float","fl"),("Atom","ch"),("String","st"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "after begin case catch cond end fun if let of query receive all_true some_true"
list_operators = Set.fromList $ words $ "div rem or xor bor bxor bsl bsr and band not bnot"
list_functions = Set.fromList $ words $ "abs accept alarm apply atom_to_list binary_to_list binary_to_term check_process_code concat_binary date delete_module disconnect_node element erase exit float float_to_list garbage_collect get get_keys group_leader halt hd integer_to_list is_alive is_atom is_binary is_boolean is_float is_function is_integer is_list is_number is_pid is_port is_process_alive is_record is_reference is_tuple length link list_to_atom list_to_binary list_to_float list_to_integer list_to_pid list_to_tuple load_module loaded localtime make_ref module_loaded node nodes now open_port pid_to_list port_close port_command port_connect port_control ports pre_loaded process_flag process_info processes purge_module put register registered round self setelement size spawn spawn_link spawn_opt split_binary statistics term_to_binary throw time tl trunc tuple_to_list unlink unregister whereis"

regex_'28'3f'3a'2dmodule'7c'2dexport'7c'2ddefine'7c'2dundef'7c'2difdef'7c'2difndef'7c'2delse'7c'2dendif'7c'2dinclude'7c'2dinclude'5flib'29 = compileRegex "(?:-module|-export|-define|-undef|-ifdef|-ifndef|-else|-endif|-include|-include_lib)"
regex_'28'3f'3a'5c'2b'7c'2d'7c'5c'2a'7c'5c'2f'7c'3d'3d'7c'5c'2f'3d'7c'3d'3a'3d'7c'3d'5c'2f'3d'7c'3c'7c'3d'3c'7c'3e'7c'3e'3d'7c'5c'2b'5c'2b'7c'2d'2d'7c'3d'7c'21'7c'3c'2d'29 = compileRegex "(?:\\+|-|\\*|\\/|==|\\/=|=:=|=\\/=|<|=<|>|>=|\\+\\+|--|=|!|<-)"
regex_'28'3f'3a'5c'28'7c'5c'29'7c'5c'7b'7c'5c'7d'7c'5c'5b'7c'5c'5d'7c'5c'2e'7c'5c'3a'7c'5c'7c'7c'5c'7c'5c'7c'7c'3b'7c'5c'2c'7c'5c'3f'7c'2d'3e'7c'5c'23'29 = compileRegex "(?:\\(|\\)|\\{|\\}|\\[|\\]|\\.|\\:|\\||\\|\\||;|\\,|\\?|->|\\#)"
regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29'3a'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 = compileRegex "\\b[a-z][_a-z@-Z0-9]*(?:(?=[^_a-z@-Z0-9])|$):\\b[a-z][_a-z@-Z0-9]*(?:(?=[^_a-z@-Z0-9])|$)"
regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29'5c'28 = compileRegex "\\b[a-z][_a-z@-Z0-9]*(?:(?=[^_a-z@-Z0-9])|$)\\("
regex_'5cb'5b'5fA'2dZ'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 = compileRegex "\\b[_A-Z][_a-z@-Z0-9]*(?:(?=[^_a-z@-Z0-9])|$)"
regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 = compileRegex "\\b[a-z][_a-z@-Z0-9]*(?:(?=[^_a-z@-Z0-9])|$)"
regex_'5b0'2d9'5d'2b'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f = compileRegex "[0-9]+\\.[0-9]+(?:[eE][+-]?[0-9]+)?"
regex_'5cd'2b'23'5ba'2dzA'2dZ0'2d9'5d'2b = compileRegex "\\d+#[a-zA-Z0-9]+"
regex_'5c'24'5cS = compileRegex "\\$\\S"
regex_'5b0'2d9'5d'2b = compileRegex "[0-9]+"
regex_'28'3f'3a'28'3f'3a'5c'5c'27'29'3f'5b'5e'27'5d'2a'29'2a'27 = compileRegex "(?:(?:\\\\')?[^']*)*'"
regex_'28'3f'3a'28'3f'3a'5c'5c'22'29'3f'5b'5e'22'5d'2a'29'2a'22 = compileRegex "(?:(?:\\\\\")?[^\"]*)*\""

defaultAttributes = [("Normal Text","Normal Text"),("isfunction","Function"),("atomquote","Atom"),("stringquote","String"),("comment","Comment")]

parseRules "Normal Text" = 
  do (attr, result) <- (((pColumn 0 >> pRegExpr regex_'28'3f'3a'2dmodule'7c'2dexport'7c'2ddefine'7c'2dundef'7c'2difdef'7c'2difndef'7c'2delse'7c'2dendif'7c'2dinclude'7c'2dinclude'5flib'29 >>= withAttribute "Pragma"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_operators >>= withAttribute "Operator"))
                        <|>
                        ((pRegExpr regex_'28'3f'3a'5c'2b'7c'2d'7c'5c'2a'7c'5c'2f'7c'3d'3d'7c'5c'2f'3d'7c'3d'3a'3d'7c'3d'5c'2f'3d'7c'3c'7c'3d'3c'7c'3e'7c'3e'3d'7c'5c'2b'5c'2b'7c'2d'2d'7c'3d'7c'21'7c'3c'2d'29 >>= withAttribute "Operator"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'28'3f'3a'5c'28'7c'5c'29'7c'5c'7b'7c'5c'7d'7c'5c'5b'7c'5c'5d'7c'5c'2e'7c'5c'3a'7c'5c'7c'7c'5c'7c'5c'7c'7c'3b'7c'5c'2c'7c'5c'3f'7c'2d'3e'7c'5c'23'29 >>= withAttribute "Separator"))
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '%' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29'3a'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 >>= withAttribute "Function") >>~ (popContext >> return ()))
                        <|>
                        ((lookAhead (pRegExpr regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29'5c'28) >> return ([],"") ) >>~ pushContext "isfunction")
                        <|>
                        ((pRegExpr regex_'5cb'5b'5fA'2dZ'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 >>= withAttribute "Variable") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Atom") >>~ pushContext "atomquote")
                        <|>
                        ((pRegExpr regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 >>= withAttribute "Atom") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "stringquote")
                        <|>
                        ((pRegExpr regex_'5b0'2d9'5d'2b'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute "Float") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5cd'2b'23'5ba'2dzA'2dZ0'2d9'5d'2b >>= withAttribute "Number") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5c'24'5cS >>= withAttribute "Integer") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute "Integer") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "isfunction" = 
  do (attr, result) <- ((pRegExpr regex_'5cb'5ba'2dz'5d'5b'5fa'2dz'40'2dZ0'2d9'5d'2a'28'3f'3a'28'3f'3d'5b'5e'5fa'2dz'40'2dZ0'2d9'5d'29'7c'24'29 >>= withAttribute "Function") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "atomquote" = 
  do (attr, result) <- ((pRegExpr regex_'28'3f'3a'28'3f'3a'5c'5c'27'29'3f'5b'5e'27'5d'2a'29'2a'27 >>= withAttribute "Atom") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "stringquote" = 
  do (attr, result) <- ((pRegExpr regex_'28'3f'3a'28'3f'3a'5c'5c'22'29'3f'5b'5e'22'5d'2a'29'2a'22 >>= withAttribute "String") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "comment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
