/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.Book;
import org.dbdoclet.trafo.tag.docbook.Chapter;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Entry;
import org.dbdoclet.trafo.tag.docbook.Para;
import org.dbdoclet.trafo.tag.docbook.Part;
import org.dbdoclet.trafo.tag.docbook.RefEntry;
import org.dbdoclet.trafo.tag.docbook.RefNameDiv;
import org.dbdoclet.trafo.tag.docbook.RefSection;
import org.dbdoclet.trafo.tag.docbook.Reference;
import org.dbdoclet.trafo.tag.docbook.SectionElement;
import org.dbdoclet.trafo.tag.html.P;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.TextImpl;

public class PEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		P p = (P) getHtmlElement();
		DocBookElement parent = getParent();

		String styleCode = p.getStyle();

		if (styleCode != null) {

		}

		Para candidate = dbfactory.createPara();
		copyCommonAttributes(p, candidate);
		candidate.setParentNode(parent);

		if (parent instanceof Entry) {
			candidate.setFormatType(ElementImpl.FORMAT_INLINE);
		}

		if (candidate.validate()) {

			setCurrent(candidate);
			parent.appendChild(getCurrent());

		} else {

			setCurrent(parent);

			if (parent instanceof Para && (parent.getParentNode() != null)) {

				parent.appendChild(new TextImpl(" "));
				setParent((DocBookElement) parent.getParentNode());
			}

			if (parent.isSection()) {

				if (parent instanceof Book || parent instanceof Part) {

					Chapter chapter = dbfactory
							.createChapter("Automatically inserted chapter");
					parent.appendChild(chapter);
					setCurrent(candidate);
					chapter.appendChild(getCurrent());

				} else if (parent instanceof Reference) {

					setCurrent(candidate);

					RefEntry refEntry = dbfactory.createRefEntry();
					parent.appendChild(refEntry);

					RefNameDiv refNameDiv = dbfactory.createRefNameDiv();
					refNameDiv.appendChild(dbfactory
							.createRefName(AUTOMATICALLY_INSERTED));
					refNameDiv.appendChild(dbfactory.createRefPurpose());
					refEntry.appendChild(refNameDiv);

					RefSection refSection = dbfactory.createRefSection();
					refEntry.appendChild(refSection);

					refSection.appendChild(getCurrent());

				} else {

					SectionElement sect = (SectionElement) parent;
					SectionElement firstSectionChild = sect
							.getFirstSectionChild();

					if (firstSectionChild != null) {
						setCurrent(candidate);
						parent.insertBefore(getCurrent(), firstSectionChild);
					}
				}
			}
		}

		traverse(true);

		return finalizeValues();
	}
}
