/* CODEPAGE.C   (c) Copyright Jan Jaeger, 1999-2007                  */
/*              Code Page conversion                                 */

// $Id: codepage.c,v 1.25 2008/01/14 17:25:16 rbowler Exp $
//
// $Log: codepage.c,v $
// Revision 1.25  2008/01/14 17:25:16  rbowler
// Additional ISO-8859-1 to European EBCDIC codepages
//
// Revision 1.24  2007/06/23 00:04:04  ivan
// Update copyright notices to include current year (2007)
//
// Revision 1.23  2006/12/08 09:43:18  jj
// Add CVS message log
//

#include "hstdinc.h"

#define _CODEPAGE_C_
#define _HUTIL_DLL_

#include "hercules.h"


static unsigned char
ascii_to_ebcdic[] = {
    "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x1A\x27\x22\x1D\x35\x1F"
    "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
    "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
    "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
    "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xAD\xE0\xBD\x5F\x6D"
    "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
    "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x6A\xD0\xA1\x07"
    "\x68\xDC\x51\x42\x43\x44\x47\x48\x52\x53\x54\x57\x56\x58\x63\x67"
    "\x71\x9C\x9E\xCB\xCC\xCD\xDB\xDD\xDF\xEC\xFC\xB0\xB1\xB2\xB3\xB4"
    "\x45\x55\xCE\xDE\x49\x69\x04\x06\xAB\x08\xBA\xB8\xB7\xAA\x8A\x8B"
    "\x09\x0A\x14\xBB\x15\xB5\xB6\x17\x1B\xB9\x1C\x1E\xBC\x20\xBE\xBF"
    "\x21\x23\x24\x28\x29\x2A\x2B\x2C\x30\x31\xCA\x33\x34\x36\x38\xCF"
    "\x39\x3A\x3B\x3E\x41\x46\x4A\x4F\x59\x62\xDA\x64\x65\x66\x70\x72"
    "\x73\xE1\x74\x75\x76\x77\x78\x80\x8C\x8D\x8E\xEB\x8F\xED\xEE\xEF"
    "\x90\x9A\x9B\x9D\x9F\xA0\xAC\xAE\xAF\xFD\xFE\xFB\x3F\xEA\xFA\xFF"
};


static unsigned char
ebcdic_to_ascii[] = {
    "\x00\x01\x02\x03\xA6\x09\xA7\x7F\xA9\xB0\xB1\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\xB2\x0A\x08\xB7\x18\x19\x1A\xB8\xBA\x1D\xBB\x1F"
    "\xBD\xC0\x1C\xC1\xC2\x0A\x17\x1B\xC3\xC4\xC5\xC6\xC7\x05\x06\x07"
    "\xC8\xC9\x16\xCB\xCC\x1E\xCD\x04\xCE\xD0\xD1\xD2\x14\x15\xD3\xFC"
    "\x20\xD4\x83\x84\x85\xA0\xD5\x86\x87\xA4\xD6\x2E\x3C\x28\x2B\xD7"
    "\x26\x82\x88\x89\x8A\xA1\x8C\x8B\x8D\xD8\x21\x24\x2A\x29\x3B\x5E"
    "\x2D\x2F\xD9\x8E\xDB\xDC\xDD\x8F\x80\xA5\x7C\x2C\x25\x5F\x3E\x3F"
    "\xDE\x90\xDF\xE0\xE2\xE3\xE4\xE5\xE6\x60\x3A\x23\x40\x27\x3D\x22"
    "\xE7\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\xE8\xE9\xEA\xEC"
    "\xF0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xF1\xF2\x91\xF3\x92\xF4"
    "\xF5\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xA8\xF6\x5B\xF7\xF8"
    "\x9B\x9C\x9D\x9E\x9F\xB5\xB6\xAC\xAB\xB9\xAA\xB3\xBC\x5D\xBE\xBF"
    "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xCA\x93\x94\x95\xA2\xCF"
    "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xDA\x96\x81\x97\xA3\x98"
    "\x5C\xE1\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\xEB\x99\xED\xEE\xEF"
    "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xFE\xFB\x9A\xF9\xFA\xFF"
};


static unsigned char
cp_437_to_037[] = {
    "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x22\x1D\x1E\x1F"
    "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
    "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
    "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
    "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xBA\xE0\xBB\xB0\x6D"
    "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
    "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xA1\x07"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x59\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x90\x3F\x3F\x3F\x3F\xEA\x3F\xFF"
};


static unsigned char
cp_037_to_437[] = {
    "\x00\x01\x02\x03\x07\x09\x07\x7F\x07\x07\x07\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x07\x0A\x08\x07\x18\x19\x07\x07\x07\x07\x07\x07"
    "\x07\x07\x1C\x07\x07\x0A\x17\x1B\x07\x07\x07\x07\x07\x05\x06\x07"
    "\x07\x07\x16\x07\x07\x07\x07\x04\x07\x07\x07\x07\x14\x15\x07\x1A"
    "\x20\xFF\x83\x84\x85\xA0\x07\x86\x87\xA4\x9B\x2E\x3C\x28\x2B\x7C"
    "\x26\x82\x88\x89\x8A\xA1\x8C\x07\x8D\xE1\x21\x24\x2A\x29\x3B\xAA"
    "\x2D\x2F\x07\x8E\x07\x07\x07\x8F\x80\xA5\x07\x2C\x25\x5F\x3E\x3F"
    "\x07\x90\x07\x07\x07\x07\x07\x07\x70\x60\x3A\x23\x40\x27\x3D\x22"
    "\x07\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\x07\x07\x07\xF1"
    "\xF8\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xA6\xA7\x91\x07\x92\x07"
    "\xE6\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xAB\x07\x07\x07\x07"
    "\x5E\x9C\x9D\xFA\x07\x07\x07\xAC\xAB\x07\x5B\x5D\x07\x07\x07\x07"
    "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\x07\x93\x94\x95\xA2\x07"
    "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\x07\x96\x81\x97\xA3\x98"
    "\x5C\xF6\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\x07\x99\x07\x07\x07"
    "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x07\x07\x9A\x07\x07\x07"
};


static unsigned char
cp_437_to_500[] = {
    "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x22\x1D\x1E\x1F"
    "\x40\x4F\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
    "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
    "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
    "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x4A\xE0\x5A\x5F\x6D"
    "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
    "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\xBB\xD0\xA1\x07"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x59\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
    "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x90\x3F\x3F\x3F\x3F\xEA\x3F\xFF"
};


static unsigned char
cp_500_to_437[] = {
    "\x00\x01\x02\x03\x07\x09\x07\x7F\x07\x07\x07\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x07\x0A\x08\x07\x18\x19\x07\x07\x07\x07\x07\x07"
    "\x07\x07\x1C\x07\x07\x0A\x17\x1B\x07\x07\x07\x07\x07\x05\x06\x07"
    "\x07\x07\x16\x07\x07\x07\x07\x04\x07\x07\x07\x07\x14\x15\x07\x1A"
    "\x20\xFF\x83\x84\x85\xA0\x07\x86\x87\xA4\x5B\x2E\x3C\x28\x2B\x21"
    "\x26\x82\x88\x89\x8A\xA1\x8C\x07\x8D\xE1\x5D\x24\x2A\x29\x3B\x5E"
    "\x2D\x2F\x07\x8E\x07\x07\x07\x8F\x80\xA5\x07\x2C\x25\x5F\x3E\x3F"
    "\x07\x90\x07\x07\x07\x07\x07\x07\x70\x60\x3A\x23\x40\x27\x3D\x22"
    "\x07\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\x07\x07\x07\xF1"
    "\xF8\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xA6\xA7\x91\x07\x92\x07"
    "\xE6\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xAB\x07\x07\x07\x07"
    "\x9B\x9C\x9D\xFA\x07\x07\x07\xAC\xAB\x07\xAA\x7C\x07\x07\x07\x07"
    "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\x07\x93\x94\x95\xA2\x07"
    "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\x07\x96\x81\x97\xA3\x98"
    "\x5C\xF6\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\x07\x99\x07\x07\x07"
    "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x07\x07\x9A\x07\x07\x07"
};


static unsigned char
cp_850_to_273[] = {
    "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"
    "\x40\x4F\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
    "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
    "\xB5\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
    "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x63\xEC\xFC\x5F\x6D"
    "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
    "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x43\xBB\xDC\x59\x07"
    "\x68\xD0\x51\x42\xC0\x44\x47\x48\x52\x53\x54\x57\x56\x58\x4A\x67"
    "\x71\x9C\x9E\xCB\x6A\xCD\xDB\xDD\xDF\xE0\x5A\x70\xB1\x80\xBF\xFF"
    "\x45\x55\xCE\xDE\x49\x69\x9A\x9B\xAB\xAF\xBA\xB8\xB7\xAA\x8A\x8B"
    "\x2B\x2C\x09\x21\x28\x65\x62\x64\xB4\x38\x31\x34\x33\xB0\xB2\x24"
    "\x22\x17\x29\x06\x20\x2A\x46\x66\x1A\x35\x08\x39\x36\x30\x3A\x9F"
    "\x8C\xAC\x72\x73\x74\x0A\x75\x76\x77\x23\x15\x14\x04\xCC\x78\x3B"
    "\xEE\xA1\xEB\xED\xCF\xEF\xA0\x8E\xAE\xFE\xFB\xFD\x8D\xAD\xBC\xBE"
    "\xCA\x8F\x1B\xB9\xB6\x7C\xE1\x9D\x90\xBD\xB3\xDA\xFA\xEA\x3E\x41"
    };


static unsigned char
cp_273_to_850[] = {
    "\x00\x01\x02\x03\xDC\x09\xC3\x7F\xCA\xB2\xD5\x0B\x0C\x0D\x0E\x0F"
    "\x10\x11\x12\x13\xDB\xDA\x08\xC1\x18\x19\xC8\xF2\x1C\x1D\x1E\x1F"
    "\xC4\xB3\xC0\xD9\xBF\x0A\x17\x1B\xB4\xC2\xC5\xB0\xB1\x05\x06\x07"
    "\xCD\xBA\x16\xBC\xBB\xC9\xCC\x04\xB9\xCB\xCE\xDF\x14\x15\xFE\x1A"
    "\x20\xFF\x83\x7B\x85\xA0\xC6\x86\x87\xA4\x8E\x2E\x3C\x28\x2B\x21"
    "\x26\x82\x88\x89\x8A\xA1\x8C\x8B\x8D\x7E\x9A\x24\x2A\x29\x3B\x5E"
    "\x2D\x2F\xB6\x5B\xB7\xB5\xC7\x8F\x80\xA5\x94\x2C\x25\x5F\x3E\x3F"
    "\x9B\x90\xD2\xD3\xD4\xD6\xD7\xD8\xDE\x60\x3A\x23\xF5\x27\x3D\x22"
    "\x9D\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\xD0\xEC\xE7\xF1"
    "\xF8\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xA6\xA7\x91\xF7\x92\xCF"
    "\xE6\xE1\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xA8\xD1\xED\xE8\xA9"
    "\xBD\x9C\xBE\xFA\xB8\x40\xF4\xAC\xAB\xF3\xAA\x7C\xEE\xF9\xEF\x9E"
    "\x84\x41\x42\x43\x44\x45\x46\x47\x48\x49\xF0\x93\xDD\x95\xA2\xE4"
    "\x81\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xFB\x96\x7D\x97\xA3\x98"
    "\x99\xF6\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\xE2\x5C\xE3\xE0\xE5"
    "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xFC\xEA\x5D\xEB\xE9\x9F"
    };


 /* 819 (ISO-8859-1 Latin-1) to 273 (EBCDIC CECP Germany) */
static unsigned char
cp_819_to_273[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                                                                                                                                                                                   
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                                                                                                                                                                                   
 /* 2x */ "\x40\x4F\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                                                                                                                                                                                   
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                                                                                                                                                                                   
 /* 4x */ "\xB5\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                                                                                                                                                                                   
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x63\xEC\xFC\x5F\x6D"                                                                                                                                                                                   
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                                                                                                                                                                                   
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x43\xBB\xDC\x59\x07"                                                                                                                                                                                   
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                                                                                                                                                                                   
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                                                                                                                                                                                   
 /* Ax */ "\x41\xAA\xB0\xB1\x9F\xB2\xCC\x7C\xBD\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                                                                                                                                                                                   
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                                                                                                                                                                                   
 /* Cx */ "\x64\x65\x62\x66\x4A\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                                                                                                                                                                                   
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xE0\xBF\x80\xFD\xFE\xFB\x5A\xAD\xAE\xA1"                                                                                                                                                                                   
 /* Ex */ "\x44\x45\x42\x46\xC0\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"                                                                                                                                                                                   
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\x6A\xE1\x70\xDD\xDE\xDB\xD0\x8D\x8E\xDF"                                                                                                                                                                                   
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
static unsigned char
cp_273_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\x7B\xE0\xE1\xE3\xE5\xE7\xF1\xC4\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\x7E\xDC\x24\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\x5B\xC0\xC1\xC3\xC5\xC7\xD1\xF6\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\x23\xA7\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\xB5\xDF\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\xA3\xA5\xB7\xA9\x40\xB6\xBC\xBD\xBE\xAC\x7C\xAF\xA8\xB4\xD7"                          
 /* Cx */ "\xE4\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xA6\xF2\xF3\xF5"                          
 /* Dx */ "\xFC\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\x7D\xF9\xFA\xFF"                          
 /* Ex */ "\xD6\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\x5C\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\x5D\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 277 (EBCDIC CECP Denmark, Norway) */
static unsigned char
cp_819_to_277[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x4F\x7F\x4A\x67\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\x80\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x9E\xE0\x9F\x5F\x6D"                          
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x9C\xBB\x47\xDC\x07"                          
 /* 8x */ "\x20\x21\x22\x23\x24\x15\x06\x17\x28\x29\x2A\x2B\x2C\x09\x0A\x1B"                          
 /* 9x */ "\x30\x31\x1A\x33\x34\x35\x36\x08\x38\x39\x3A\x3B\x04\x14\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\xB1\x5A\xB2\x70\xB5\xBD\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                          
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x5B\x7B\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x7C\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x44\x45\x42\x46\x43\xD0\xC0\x48\x54\x51\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x6A\xDD\xDE\xDB\xA1\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_277_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x9C\x09\x86\x7F\x97\x8D\x8E\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x9D\x85\x08\x87\x18\x19\x92\x8F\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x80\x81\x82\x83\x84\x0A\x17\x1B\x88\x89\x8A\x8B\x8C\x05\x06\x07"                          
 /* 3x */ "\x90\x91\x16\x93\x94\x95\x96\x04\x98\x99\x9A\x9B\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\x7D\xE7\xF1\x23\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\xA4\xC5\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\x24\xC7\xD1\xF8\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xA6\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\xC6\xD8\x27\x3D\x22"                          
 /* 8x */ "\x40\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\x7B\xB8\x5B\x5D"                          
 /* Ax */ "\xB5\xFC\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\xA3\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\xAC\x7C\xAF\xA8\xB4\xD7"                          
 /* Cx */ "\xE6\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"                          
 /* Dx */ "\xE5\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\x7E\xF9\xFA\xFF"                          
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 278 (EBCDIC CECP Finland, Sweden) */
static unsigned char
cp_819_to_278[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x4F\x7F\x63\x67\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\xEC\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xB5\x71\x9F\x5F\x6D"                          
 /* 6x */ "\x51\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x43\xBB\x47\xDC\x07"                          
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                          
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\xB1\x5A\xB2\xCC\x4A\xBD\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                          
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x7B\x5B\x9E\x68\x74\xE0\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\x7C\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x44\x45\x42\x46\xC0\xD0\x9C\x48\x54\x79\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\x6A\xE1\x70\xDD\xDE\xDB\xA1\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_278_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\x7B\xE0\xE1\xE3\x7D\xE7\xF1\xA7\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\x60\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\xA4\xC5\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\x23\xC0\xC1\xC3\x24\xC7\xD1\xF6\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\x5C\xCA\xCB\xC8\xCD\xCE\xCF\xCC\xE9\x3A\xC4\xD6\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\x5D"                          
 /* Ax */ "\xB5\xFC\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\xA3\xA5\xB7\xA9\x5B\xB6\xBC\xBD\xBE\xAC\x7C\xAF\xA8\xB4\xD7"                          
 /* Cx */ "\xE4\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xA6\xF2\xF3\xF5"                          
 /* Dx */ "\xE5\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\x7E\xF9\xFA\xFF"                          
 /* Ex */ "\xC9\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\x40\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 280 (EBCDIC CECP Italy) */
static unsigned char
cp_819_to_280[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x4F\x7F\xB1\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\xB5\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x90\x48\x51\x5F\x6D"                          
 /* 6x */ "\xDD\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x44\xBB\x54\x58\x07"                          
 /* 8x */ "\x20\x21\x22\x23\x24\x15\x06\x17\x28\x29\x2A\x2B\x2C\x09\x0A\x1B"                          
 /* 9x */ "\x30\x31\x1A\x33\x34\x35\x36\x08\x38\x39\x3A\x3B\x04\x14\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\x7B\x9F\xB2\xCD\x7C\xBD\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                          
 /* Bx */ "\x4A\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\xC0\x45\x42\x46\x43\x47\x9C\xE0\xD0\x5A\x52\x53\xA1\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\x6A\xCE\xCB\xCF\xCC\xE1\x70\x79\xDE\xDB\xDC\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_280_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x9C\x09\x86\x7F\x97\x8D\x8E\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x9D\x85\x08\x87\x18\x19\x92\x8F\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x80\x81\x82\x83\x84\x0A\x17\x1B\x88\x89\x8A\x8B\x8C\x05\x06\x07"                          
 /* 3x */ "\x90\x91\x16\x93\x94\x95\x96\x04\x98\x99\x9A\x9B\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\x7B\xE1\xE3\xE5\x5C\xF1\xB0\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\x5D\xEA\xEB\x7D\xED\xEE\xEF\x7E\xDF\xE9\x24\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xF2\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\xF9\x3A\xA3\xA7\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\x5B\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\xB5\xEC\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\x23\xA5\xB7\xA9\x40\xB6\xBC\xBD\xBE\xAC\x7C\xAF\xA8\xB4\xD7"                          
 /* Cx */ "\xE0\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xA6\xF3\xF5"                          
 /* Dx */ "\xE8\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\x60\xFA\xFF"                          
 /* Ex */ "\xE7\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 284 (EBCDIC CECP Spain) */
static unsigned char
cp_819_to_284[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\xBB\x7F\x69\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x4A\xE0\x5A\xBA\x6D"                          
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xBD\x07"                          
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                          
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\xB1\x9F\xB2\x49\xB5\xA1\xB4\x9A\x8A\x5F\xCA\xAF\xBC"                          
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x7B\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x44\x45\x42\x46\x43\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x6A\xCD\xCE\xCB\xCF\xCC\xE1\x70\xDD\xDE\xDB\xDC\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_284_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\xE5\xE7\xA6\x5B\x2E\x3C\x28\x2B\x7C"                          
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\x5D\x24\x2A\x29\x3B\xAC"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\x23\xF1\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\xD1\x40\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\xB5\xA8\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\xA3\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\x5E\x21\xAF\x7E\xB4\xD7"                          
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"                          
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xF9\xFA\xFF"                          
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 285 (EBCDIC CECP UK) */
static unsigned char
cp_819_to_285[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x5A\x7F\x7B\x4A\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xB1\xE0\xBB\xBA\x6D"                          
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xBC\x07"                          
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                          
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\x5B\x9F\xB2\x6A\xB5\xBD\xB4\x9A\x8A\x5F\xCA\xAF\xA1"                          
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x44\x45\x42\x46\x43\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x70\xDD\xDE\xDB\xDC\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_285_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\xE5\xE7\xF1\x24\x2E\x3C\x28\x2B\x7C"                          
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\x21\xA3\x2A\x29\x3B\xAC"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xA6\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\x23\x40\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\xB5\xAF\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\x5B\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\x5E\x5D\x7E\xA8\xB4\xD7"                          
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"                          
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xF9\xFA\xFF"                          
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 297 (EBCDIC CECP France) */
static unsigned char
cp_819_to_297[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x4F\x7F\xB1\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\x44\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x90\x48\xB5\x5F\x6D"                          
 /* 6x */ "\xA0\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\x51\xBB\x54\xBD\x07"                          
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                          
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\x7B\x9F\xB2\xDD\x5A\xA1\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                          
 /* Bx */ "\x4A\x8F\xEA\xFA\xBE\x79\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x7C\x45\x42\x46\x43\x47\x9C\xE0\xD0\xC0\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x70\x6A\xDE\xDB\xDC\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_297_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\x40\xE1\xE3\xE5\x5C\xF1\xB0\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\x7B\xEA\xEB\x7D\xED\xEE\xEF\xEC\xDF\xA7\x24\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xF9\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\xB5\x3A\xA3\xE0\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\x5B\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\x60\xA8\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\x23\xA5\xB7\xA9\x5D\xB6\xBC\xBD\xBE\xAC\x7C\xAF\x7E\xB4\xD7"                          
 /* Cx */ "\xE9\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"                          
 /* Dx */ "\xE8\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xA6\xFA\xFF"                          
 /* Ex */ "\xE7\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 819 (ISO-8859-1 Latin-1) to 500 (EBCDIC CECP International) */
static unsigned char
cp_819_to_500[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x15\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x40\x4F\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"                          
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"                          
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"                          
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\x4A\xE0\x5A\x5F\x6D"                          
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"                          
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\xBB\xD0\xA1\x07"                          
 /* 8x */ "\x04\x06\x08\x09\x0A\x14\x17\x1A\x1B\x20\x21\x22\x23\x24\x25\x28"                          
 /* 9x */ "\x29\x2A\x2B\x2C\x30\x31\x33\x34\x35\x36\x38\x39\x3A\x3B\x3E\xFF"                          
 /* Ax */ "\x41\xAA\xB0\xB1\x9F\xB2\x6A\xB5\xBD\xB4\x9A\x8A\xBA\xCA\xAF\xBC"                          
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"                          
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"                          
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xAD\xAE\x59"                          
 /* Ex */ "\x44\x45\x42\x46\x43\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"                          
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x70\xDD\xDE\xDB\xDC\x8D\x8E\xDF"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  
static unsigned char
cp_500_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x80\x09\x81\x7F\x82\x83\x84\x0B\x0C\x0D\x0E\x0F"                          
 /* 1x */ "\x10\x11\x12\x13\x85\x0A\x08\x86\x18\x19\x87\x88\x1C\x1D\x1E\x1F"                          
 /* 2x */ "\x89\x8A\x8B\x8C\x8D\x8E\x17\x1B\x8F\x90\x91\x92\x93\x05\x06\x07"                          
 /* 3x */ "\x94\x95\x16\x96\x97\x98\x99\x04\x9A\x9B\x9C\x9D\x14\x15\x9E\x1A"                          
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\xE5\xE7\xF1\x5B\x2E\x3C\x28\x2B\x21"                          
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\x5D\x24\x2A\x29\x3B\x5E"                          
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xA6\x2C\x25\x5F\x3E\x3F"                          
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\x23\x40\x27\x3D\x22"                          
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"                          
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"                          
 /* Ax */ "\xB5\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\xDD\xDE\xAE"                          
 /* Bx */ "\xA2\xA3\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\xAC\x7C\xAF\xA8\xB4\xD7"                          
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"                          
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xF9\xFA\xFF"                          
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"                          
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"                          
 };       /* x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */  


 /* 437 to 1047 */
static unsigned char
cp_437_to_1047[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x1C\x27\x07\x1D\x1E\x1F"
 /* 2x */ "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xAD\xE0\xBD\x5F\x6D"
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xA1\x3F"
 /* 8x */ "\x68\xDC\x51\x42\x43\x44\x47\x48\x52\x53\x54\x57\x56\x58\x63\x67"
 /* 9x */ "\x71\x9C\x9E\xCB\xCC\xCD\xDB\xDD\xDF\xEC\xFC\x4A\xB1\xB2\x3F\x3F"
 /* Ax */ "\x45\x55\xCE\xDE\x49\x69\x9A\x9B\xAB\x3F\xB0\xB8\xB7\xAA\x8A\x8B"
 /* Bx */ "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* Cx */ "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* Dx */ "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* Ex */ "\x3F\x59\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* Fx */ "\x3F\x8F\x3F\x3F\x3F\x3F\xE1\x3F\x90\x3F\xB3\x3F\x3F\xEA\x3F\x41"
    };


 /* 1047 to 437 */
static unsigned char
cp_1047_to_437[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x07\x09\x07\x1C\x07\x07\x07\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x07\x07\x08\x07\x18\x19\x07\x07\x1A\x1D\x1E\x1F"
 /* 2x */ "\x07\x07\x07\x07\x07\x0A\x17\x1B\x07\x07\x07\x07\x07\x05\x06\x07"
 /* 3x */ "\x07\x07\x16\x07\x07\x07\x07\x04\x07\x07\x07\x07\x14\x15\x07\x7F"
 /* 4x */ "\x20\xFF\x83\x84\x85\xA0\x07\x86\x87\xA4\x9B\x2E\x3C\x28\x2B\x7C"
 /* 5x */ "\x26\x82\x88\x89\x8A\xA1\x8C\x8B\x8D\xE1\x21\x24\x2A\x29\x3B\x5E"
 /* 6x */ "\x2D\x2F\x07\x8E\x07\x07\x07\x8F\x80\xA5\x07\x2C\x25\x5F\x3E\x3F"
 /* 7x */ "\x07\x90\x07\x07\x07\x07\x07\x07\x07\x60\x3A\x23\x40\x27\x3D\x22"
 /* 8x */ "\x07\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\x07\x07\x07\xF1"
 /* 9x */ "\xF8\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xA6\xA7\x91\x07\x92\x07"
 /* Ax */ "\x07\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xA8\x07\x5B\x07\x07"
 /* Bx */ "\xAA\x9C\x9D\xFA\x07\x07\x07\xAC\xAB\x07\x07\x07\x07\x5D\x07\x07"
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\x07\x93\x94\x95\xA2\x07"
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\x07\x96\x81\x97\xA3\x98"
 /* Ex */ "\x5C\xF6\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\x07\x99\x07\x07\x07"
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x07\x07\x9A\x07\x07\x07"
    };


 /* 819 to 1047 */
static unsigned char
cp_819_to_1047[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"
 /* 2x */ "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xAD\xE0\xBD\x5F\x6D"
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xA1\x07"
 /* 8x */ "\x20\x21\x22\x23\x24\x15\x06\x17\x28\x29\x2A\x2B\x2C\x09\x0A\x1B"
 /* 9x */ "\x30\x31\x1A\x33\x34\x35\x36\x08\x38\x39\x3A\x3B\x04\x14\x3E\xFF"
 /* Ax */ "\x41\xAA\x4A\xB1\x9F\xB2\x6A\xB5\xBB\xB4\x9A\x8A\xB0\xCA\xAF\xBC"
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xBA\xAE\x59"
 /* Ex */ "\x44\x45\x42\x46\x43\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x70\xDD\xDE\xDB\xDC\x8D\x8E\xDF"
};


 /* 1047 to 819 */
static unsigned char
cp_1047_to_819[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x9C\x09\x86\x7F\x97\x8D\x8E\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x9D\x85\x08\x87\x18\x19\x92\x8F\x1C\x1D\x1E\x1F"
 /* 2x */ "\x80\x81\x82\x83\x84\x0A\x17\x1B\x88\x89\x8A\x8B\x8C\x05\x06\x07"
 /* 3x */ "\x90\x91\x16\x93\x94\x95\x96\x04\x98\x99\x9A\x9B\x14\x15\x9E\x1A"
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\xE5\xE7\xF1\xA2\x2E\x3C\x28\x2B\x7C"
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\x21\x24\x2A\x29\x3B\x5E"
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xA6\x2C\x25\x5F\x3E\x3F"
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\x23\x40\x27\x3D\x22"
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"
 /* Ax */ "\xB5\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\x5B\xDE\xAE"
 /* Bx */ "\xAC\xA3\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\xDD\xA8\xAF\x5D\xB4\xD7"
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xF9\xFA\xFF"
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x9F"
};


 /* 1252 to 1047 */
static unsigned char
cp_1252_to_1047[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"
 /* 2x */ "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xAD\xE0\xBD\x5F\x6D"
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xA1\x07"
 /* 8x */ "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* 9x */ "\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x3F"
 /* Ax */ "\x41\xAA\x4A\xB1\x9F\xB2\x6A\xB5\xBB\xB4\x9A\x8A\xB0\xCA\xAF\xBC"
 /* Bx */ "\x90\x8F\xEA\xFA\xBE\xA0\xB6\xB3\x9D\xDA\x9B\x8B\xB7\xB8\xB9\xAB"
 /* Cx */ "\x64\x65\x62\x66\x63\x67\x9E\x68\x74\x71\x72\x73\x78\x75\x76\x77"
 /* Dx */ "\xAC\x69\xED\xEE\xEB\xEF\xEC\xBF\x80\xFD\xFE\xFB\xFC\xBA\xAE\x59"
 /* Ex */ "\x44\x45\x42\x46\x43\x47\x9C\x48\x54\x51\x52\x53\x58\x55\x56\x57"
 /* Fx */ "\x8C\x49\xCD\xCE\xCB\xCF\xCC\xE1\x70\xDD\xDE\xDB\xDC\x8D\x8E\xDF"
    };


 /* 1047 to 1252 */
static unsigned char
cp_1047_to_1252[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x07\x09\x07\x7F\x07\x07\x07\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x07\x07\x08\x07\x18\x19\x07\x07\x1C\x1D\x1E\x1F"
 /* 2x */ "\x07\x07\x07\x07\x07\x0A\x17\x1B\x07\x07\x07\x07\x07\x05\x06\x07"
 /* 3x */ "\x07\x07\x16\x07\x07\x07\x07\x04\x07\x07\x07\x07\x14\x15\x07\x1A"
 /* 4x */ "\x20\xA0\xE2\xE4\xE0\xE1\xE3\xE5\xE7\xF1\xA2\x2E\x3C\x28\x2B\x7C"
 /* 5x */ "\x26\xE9\xEA\xEB\xE8\xED\xEE\xEF\xEC\xDF\x21\x24\x2A\x29\x3B\x5E"
 /* 6x */ "\x2D\x2F\xC2\xC4\xC0\xC1\xC3\xC5\xC7\xD1\xA6\x2C\x25\x5F\x3E\x3F"
 /* 7x */ "\xF8\xC9\xCA\xCB\xC8\xCD\xCE\xCF\xCC\x60\x3A\x23\x40\x27\x3D\x22"
 /* 8x */ "\xD8\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAB\xBB\xF0\xFD\xFE\xB1"
 /* 9x */ "\xB0\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xAA\xBA\xE6\xB8\xC6\xA4"
 /* Ax */ "\xB5\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xA1\xBF\xD0\x5B\xDE\xAE"
 /* Bx */ "\xAC\xA3\xA5\xB7\xA9\xA7\xB6\xBC\xBD\xBE\xDD\xA8\xAF\x5D\xB4\xD7"
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xAD\xF4\xF6\xF2\xF3\xF5"
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xB9\xFB\xFC\xF9\xFA\xFF"
 /* Ex */ "\x5C\xF7\x53\x54\x55\x56\x57\x58\x59\x5A\xB2\xD4\xD6\xD2\xD3\xD5"
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xB3\xDB\xDC\xD9\xDA\x07"
    };


 /* 850 to 1047 */
static unsigned char
cp_850_to_1047[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x37\x2D\x2E\x2F\x16\x05\x25\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x3C\x3D\x32\x26\x18\x19\x3F\x27\x1C\x1D\x1E\x1F"
 /* 2x */ "\x40\x5A\x7F\x7B\x5B\x6C\x50\x7D\x4D\x5D\x5C\x4E\x6B\x60\x4B\x61"
 /* 3x */ "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\x7A\x5E\x4C\x7E\x6E\x6F"
 /* 4x */ "\x7C\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xD1\xD2\xD3\xD4\xD5\xD6"
 /* 5x */ "\xD7\xD8\xD9\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xAD\xE0\xBD\x5F\x6D"
 /* 6x */ "\x79\x81\x82\x83\x84\x85\x86\x87\x88\x89\x91\x92\x93\x94\x95\x96"
 /* 7x */ "\x97\x98\x99\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xC0\x4F\xD0\xA1\x07"
 /* 8x */ "\x68\xDC\x51\x42\x43\x44\x47\x48\x52\x53\x54\x57\x56\x58\x63\x67"
 /* 9x */ "\x71\x9C\x9E\xCB\xCC\xCD\xDB\xDD\xDF\xEC\xFC\x70\xB1\x80\xBF\x3F"
 /* Ax */ "\x45\x55\xCE\xDE\x49\x69\x9A\x9B\xAB\xAF\xB0\xB8\xB7\xAA\x8A\x8B"
 /* Bx */ "\x3F\x3F\x3F\x3F\x3F\x65\x62\x64\xB4\x3F\x3F\x3F\x3F\x4A\xB2\x3F"
 /* Cx */ "\x3F\x3F\x3F\x3F\x3F\x3F\x46\x66\x3F\x3F\x3F\x3F\x3F\x3F\x3F\x9F"
 /* Dx */ "\x8C\xAC\x72\x73\x74\x3F\x75\x76\x77\x3F\x3F\x3F\x3F\x6A\x78\x3F"
 /* Ex */ "\xEE\x59\xEB\xED\xCF\xEF\xA0\x8E\xAE\xFE\xFB\xFD\x8D\xBA\xBC\xBE"
 /* Fx */ "\xCA\x8F\x3F\xB9\xB6\xB5\xE1\x9D\x90\xBB\xB3\xDA\xFA\xEA\x3F\x41"
    };


 /* 1047 to 850 */
static unsigned char
cp_1047_to_850[] = {
 /*          x0  x1  x2  x3  x4  x5  x6  x7  x8  x9  xA  xB  xC  xD  xE  xF */
 /* 0x */ "\x00\x01\x02\x03\x07\x09\x07\x7F\x07\x07\x07\x0B\x0C\x0D\x0E\x0F"
 /* 1x */ "\x10\x11\x12\x13\x07\x07\x08\x07\x18\x19\x07\x07\x1C\x1D\x1E\x1F"
 /* 2x */ "\x07\x07\x07\x07\x07\x0A\x17\x1B\x07\x07\x07\x07\x07\x05\x06\x07"
 /* 3x */ "\x07\x07\x16\x07\x07\x07\x07\x04\x07\x07\x07\x07\x14\x15\x07\x1A"
 /* 4x */ "\x20\xFF\x83\x84\x85\xA0\xC6\x86\x87\xA4\xBD\x2E\x3C\x28\x2B\x7C"
 /* 5x */ "\x26\x82\x88\x89\x8A\xA1\x8C\x8B\x8D\xE1\x21\x24\x2A\x29\x3B\x5E"
 /* 6x */ "\x2D\x2F\xB6\x8E\xB7\xB5\xC7\x8F\x80\xA5\xDD\x2C\x25\x5F\x3E\x3F"
 /* 7x */ "\x9B\x90\xD2\xD3\xD4\xD6\xD7\xD8\xDE\x60\x3A\x23\x40\x27\x3D\x22"
 /* 8x */ "\x9D\x61\x62\x63\x64\x65\x66\x67\x68\x69\xAE\xAF\xD0\xEC\xE7\xF1"
 /* 9x */ "\xF8\x6A\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\xA6\xA7\x91\xF7\x92\xCF"
 /* Ax */ "\xE6\x7E\x73\x74\x75\x76\x77\x78\x79\x7A\xAD\xA8\xD1\x5B\xE8\xA9"
 /* Bx */ "\xAA\x9C\xBE\xFA\xB8\xF5\xF4\xAC\xAB\xF3\xED\xF9\xEE\x5D\xEF\x9E"
 /* Cx */ "\x7B\x41\x42\x43\x44\x45\x46\x47\x48\x49\xF0\x93\x94\x95\xA2\xE4"
 /* Dx */ "\x7D\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x52\xFB\x96\x81\x97\xA3\x98"
 /* Ex */ "\x5C\xF6\x53\x54\x55\x56\x57\x58\x59\x5A\xFD\xE2\x99\xE3\xE0\xE5"
 /* Fx */ "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\xFC\xEA\x9A\xEB\xE9\x07"
    };


typedef struct _CPCONV {
    char *name;
    unsigned char *h2g;
    unsigned char *g2h;
} CPCONV;


static CPCONV cpconv[] = {
    { "default",  ascii_to_ebcdic, ebcdic_to_ascii },
    { "437/037",  cp_437_to_037, cp_037_to_437 },
    { "437/500",  cp_437_to_500, cp_500_to_437 },
    { "850/273",  cp_850_to_273, cp_273_to_850 },
    { "819/273",  cp_819_to_273, cp_273_to_819 },
    { "819/277",  cp_819_to_277, cp_277_to_819 },
    { "819/278",  cp_819_to_278, cp_278_to_819 },
    { "819/280",  cp_819_to_280, cp_280_to_819 },
    { "819/284",  cp_819_to_284, cp_284_to_819 },
    { "819/285",  cp_819_to_285, cp_285_to_819 },
    { "819/297",  cp_819_to_297, cp_297_to_819 },
    { "819/500",  cp_819_to_500, cp_500_to_819 },
    { "437/1047",  cp_437_to_1047,  cp_1047_to_437  },
    { "819/1047",  cp_819_to_1047,  cp_1047_to_819  },
    { "1252/1047", cp_1252_to_1047, cp_1047_to_1252 },
    { "850/1047",  cp_850_to_1047,  cp_1047_to_850  },
    { NULL,       ascii_to_ebcdic, ebcdic_to_ascii } };


static CPCONV *codepage_conv = cpconv;

#if defined(HAVE_ICONV)
static iconv_t codepage_g2h = NULL;
static iconv_t codepage_h2g = NULL;

static int set_iconv_cp(char *name)
{
char *codepage;
char *fcp, *tcp;
char *strtok_str;

char ibyte, obyte;
char *ibytes ,*obytes;
size_t nibytes, nobytes;

    if(codepage_g2h)
        iconv_close(codepage_g2h);
    if(codepage_h2g)
        iconv_close(codepage_h2g);

    codepage_g2h = codepage_h2g = NULL;

    codepage = strdup(name);

    if(!(fcp = strtok_r(codepage,"/,:",&strtok_str)))
    {
        free(codepage);
        return -1;
    }
    if(!(tcp = strtok_r(NULL,"/,:",&strtok_str)))
    {
        free(codepage);
        return -1;
    }

    if((codepage_g2h = iconv_open (fcp,tcp)) == (iconv_t)(-1))
    {
        codepage_g2h = NULL;
        free(codepage);
        return -1;
    }
    if((codepage_h2g = iconv_open (tcp,fcp)) == (iconv_t)(-1))
    {
        iconv_close(codepage_g2h);
        codepage_g2h = codepage_h2g = NULL;
        free(codepage);
        return -1;
    }

    free(codepage);

    ibytes = &ibyte; obytes = &obyte;
    nibytes = nobytes = 1;
    if(iconv(codepage_g2h, (char**)&ibytes, &nibytes, &obytes, &nobytes) == (size_t)(-1) )
    
    {
        iconv_close(codepage_g2h);
        iconv_close(codepage_h2g);
        codepage_g2h = codepage_h2g = NULL;
        return -1;
    }

    ibytes = &ibyte; obytes = &obyte;
    nibytes = nobytes = 1;
    if(iconv(codepage_h2g, (char**)&ibytes, &nibytes, &obytes, &nobytes) == (size_t)(-1) )
    
    {
        iconv_close(codepage_g2h);
        iconv_close(codepage_h2g);
        codepage_g2h = codepage_h2g = NULL;
        return -1;
    }
   
    return 0;
}
#endif /*defined(HAVE_ICONV)*/


DLL_EXPORT void set_codepage(char *name)
{
    if(name == NULL)
        if(!(name = getenv("HERCULES_CP")))
             name = "default";

    for(codepage_conv = cpconv; 
        codepage_conv->name && strcasecmp(codepage_conv->name,name);
        codepage_conv++);

    if(codepage_conv->name)
    {
#if 0
        logmsg(_("HHCCF072I Using internal codepage conversion table %s\n"),
                 name);
#endif
    }
    else
    {
#if defined(HAVE_ICONV)
        if(!set_iconv_cp(name))
        {
#if 0
            logmsg(_("HHCCF072I Using external codepage conversion table %s\n"),
                 name);
#endif
        }
        else
#endif /*defined(HAVE_ICONV)*/
            logmsg(_("HHCCF051E Codepage conversion table %s is not defined\n"),
                 name);
    }
}


DLL_EXPORT unsigned char host_to_guest (unsigned char byte)
{
#if defined(HAVE_ICONV)
char obyte;
char *gbyte = &obyte;
char *hbyte = (char *)&byte;
size_t inbytes = 1, outbytes = 1;

    if(codepage_h2g)
    {
        iconv(codepage_h2g, (char**)&hbyte, &inbytes, &gbyte, &outbytes);
        return obyte;
    }
    else
#endif /*defined(HAVE_ICONV)*/
        return (unsigned char)codepage_conv->h2g[(unsigned int)byte];
}


DLL_EXPORT unsigned char guest_to_host (unsigned char byte)
{
#if defined(HAVE_ICONV)
char obyte;
char *hbyte = &obyte;
char *gbyte = (char *)&byte;
size_t inbytes = 1, outbytes = 1;

    if(codepage_g2h)
    {
        iconv(codepage_g2h, (char**)&gbyte, &inbytes, &hbyte, &outbytes);
        return obyte;
    }
    else
#endif /*defined(HAVE_ICONV)*/
        return codepage_conv->g2h[byte];
}
