/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sitetran.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _TRANSITIONS_H_
#define _TRANSITIONS_H_

#include "region.h"

struct LineSegment
{
	HXxPoint	start;
	HXxPoint	finish;

    LineSegment(){}
    LineSegment(const LineSegment& ls);

    void operator=(const LineSegment& right);

    BOOL Clip(int left, int top, int right, int bottom);
};

struct tranLines
{
	INT32			m_nLines;
	LineSegment*	m_pLines;

    tranLines();
    tranLines(const tranLines& tl);
    virtual ~tranLines();

    void Copy(const tranLines& tl);

    void operator+=(const tranLines& right);
    void operator+=(const LineSegment& right);
    void operator=(const tranLines& right);

    void Destroy();
    void Offset(int x, int y);
    void Clip(int left, int top, int right, int bottom);
};

tranLines* operator+(const tranLines& left, const tranLines& right);

typedef HXREGION* (*TransitionType)(int left, int top, int right, int bottom, int completeness, tranLines* lines /* = NULL */); 

#define MATRIX_TRANSITION_INIT		-1
#define MATRIX_TRANSITION_DELETE	-2

struct tranStruct
{
    TransitionType  m_fpTranFunction;
	int			m_SMPTE;
    char*	    m_pTranName;
};

struct tranType
{
    tranStruct* m_pSubTypes;
    char* m_pName;
    int m_nNum;
};

HXREGION* InvertRGN(HXREGION* in, int x, int y, int x1, int y1);
HXREGION* MirrorHorizontal(HXREGION* in, int y);
HXREGION* MirrorVertical(HXREGION* in, int x);

HXREGION* DefaultTransition(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* EdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* IrisWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SlideVerticalEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopLeftEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopRightEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BottomRightEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BottomLeftEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FourCornerEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FourBoxEdgeWipe (int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BarnVerticalEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BarnHorizontalEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopCenterEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CenterRightEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BottomCenterEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* LeftCenterEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonalLeftDownEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonalRightDownEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalBowTieEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalBowTieEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonaLeftOutEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonaRightOutEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonaCrossEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiagonalBoxEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FilledVEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FilledVRightEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FilledVBottomEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FilledVLeftEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HollowVEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HollowVRightEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HollowVBottomEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HollowVLeftEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalZigZagEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalZigZagEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalBarnZigZagEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalBarnZigZagEdgeWipe(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingLeftRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingQuadrantRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopBottom180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RightToLeft180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* topBottom90Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RightToLeft90Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* Top180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* Right180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* Bottom180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* Left180Radial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterRotatingTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterRotatingLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleRotatingTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleRotatingLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVTopRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVLeftRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OpenVLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopLeftRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingBottomLeftRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingBottomRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopLeftBottomRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingBottomLeftTopRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingTopLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingLeftTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingBottomLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingRightTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingDoubleCenterRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingDoubleCenterTopRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingDoubleCenterTopBottomRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RotatingDoubleCenterLeftRightRadial(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* PentagonIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RectangleIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DiamondIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TriangleIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TriangleRightIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TriangleUpsideDownIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TriangleLeftIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* PentagonUpsideDownLeftIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HexagonIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HexagonSideIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CircleIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OvalIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* OvalSideIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FourPointStarIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FivePointStarIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SixPointStarIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ArrowHeadIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ArrowHeadRightIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ArrowHeadUpsideDownIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ArrowHeadLeftIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HeartIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CatEyeIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CatEyeSideIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RoundRectHorizontal(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* RoundRectVeritical(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* KeyHoleIris(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalStartLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopLeftDiagonalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* TopRightDiagonalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BottomRightDiagonalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* BottomLeftDiagonalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ClockwiseTopLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ClockwiseBottomRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ClockwiseTopRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* ClockwiseBottomLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterClockwiseTopLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterClockwiseTopRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterClockwiseBottomRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* CounterClockwiseBottomLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalStartTopMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalStartBottomMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalStartTopOppositeMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalStartBottomOppositeMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalStartRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalStartLeftOppositeMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalStartRightOppositeMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalLeftOppositeRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalRightOppositeRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleSpiralTopMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleSpiralBottomMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleSpiralLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleSpiralRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* QuadSpiralVerticalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* QuadSpiralHorizontalMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalWaterfallLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* VerticalWaterfallRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalWaterfallLeftMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* HorizontalWaterfallRightMatrix(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleDiagonalTop(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* DoubleDiagonalBottom(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SlideFromLeft(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SlideFromTop(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SlideFromRight(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* SlideFromBottom(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* Crossfade(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FadeToColor(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
HXREGION* FadeFromColor(int left, int top, int right, int bottom, int completeness, tranLines* lines = NULL);
#endif
