/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: siteplug.cpp,v 1.10.4.1 2004/07/09 01:59:40 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#if defined(_UNIX) && !defined(_MAC_UNIX)
//XXXSMJ This INITGUID probably needs to go
#  define INITGUID

# if !defined(QWS)
#include "hlxclib/string.h"
#   include <X11/Xlib.h>
#   include <X11/Xutil.h>
#   include <X11/Xos.h>
#endif /* !defined(QWS) */
#endif //_UNIX

#ifdef _SYMBIAN
# define INITGUID
#endif

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"

#include "hxplugn.h"
#include "hxmap.h"
#include "hxslist.h"
#include "ihxpckts.h"
#include "hxwin.h"
#include "hxvsurf.h"
#include "chxpckts.h"
#include "siteplug.h"
#include "dllpath.h"
#include "hxfiles.h"
#include "hxmon.h"
#include "hxver.h"
#include "hxprefs.h"
#include "hxcore.h"
#include "hxupgrd.h"

#if defined (HELIX_FEATURE_MINI_SITE)
# include "minisite.h"
#else //HELIX_FEATURE_MINI_SITE
# include "basesite.h"
# if defined(_UNIX) && !defined(_MAC_UNIX)
#  include "hxcmenu.h"
#  include "unixsite.h"
# endif
# if defined(_MACINTOSH) || defined(_MAC_UNIX)
#  include "platform/mac/macsite.h"
# endif
# ifdef _WINDOWS
#  include "winsite.h"
# endif
#endif //HELIX_FEATURE_MINI_SITE

#include "site.ver"
#include "hxassert.h"
#include "hxheap.h"

#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif


const char* const SiteSurfFactory::zm_pDescription = "Surface/Site Window Factory Plugin";
const char* const SiteSurfFactory::zm_pCopyright   = HXVER_COPYRIGHT;
const char* const SiteSurfFactory::zm_pMoreInfoURL  = "http://www.real.com";


ENABLE_DLLACCESS_PATHS(SiteSurf);


/****************************************************************************
 * 
 *  Function:
 * 
 *	HXCreateInstance()
 * 
 *  Purpose:
 * 
 *	Function implemented by all plugin DLL's to create an instance of 
 *	any of the objects supported by the DLL. This method is similar to 
 *	Window's CoCreateInstance() in its purpose, except that it only 
 *	creates objects from this plugin DLL.
 *
 *	NOTE: Aggregation is never used. Therefore and outer unknown is
 *	not passed to this function, and you do not need to code for this
 *	situation.
 * 
 */

STDAPI ENTRYPOINT(HXCREATEINSTANCE)
(
    IUnknown**  /*OUT*/	ppIUnknown
)
{
    *ppIUnknown = (IUnknown*)(IHXPlugin*)new SiteSurfFactory();
    if (*ppIUnknown)
    {
	(*ppIUnknown)->AddRef();
	return HXR_OK;
    }
    return HXR_OUTOFMEMORY;
}

SiteSurfFactory::SiteSurfFactory()
    : m_pContext(NULL)
{
    m_lRefCount = 0;
}

SiteSurfFactory::~SiteSurfFactory()
{
    if (m_pContext)
    {
	m_pContext->Release();
	m_pContext = NULL;
    }
}

STDMETHODIMP
SiteSurfFactory::QueryInterface(REFIID riid, void** ppvObj)
{
    if(IsEqualIID(riid, IID_IUnknown))
    {
	AddRef();
	*ppvObj = (IUnknown*)(IHXCommonClassFactory*)this;
	return HXR_OK;
    }
    else if(IsEqualIID(riid, IID_IHXPlugin))
    {
	AddRef();
	*ppvObj = (IHXPlugin*)this;
	return HXR_OK;
    }
    else if(IsEqualIID(riid, IID_IHXCommonClassFactory))
    {
	AddRef();
	*ppvObj = (IHXCommonClassFactory*)this;
	return HXR_OK;
    }

    *ppvObj = NULL;
    return HXR_NOINTERFACE;
}

STDMETHODIMP_(ULONG32)
SiteSurfFactory::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32)
SiteSurfFactory::Release()
{ 
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;
    return 0;
}
    
STDMETHODIMP
SiteSurfFactory::InitPlugin(IUnknown* pContext)
{
    m_pContext = pContext;
    if(m_pContext)
	m_pContext->AddRef();

    return HXR_OK;
}

STDMETHODIMP
SiteSurfFactory::GetPluginInfo(REF(BOOL) bMultipleLoad,
			       REF(const char*) pDescription,
			       REF(const char*) pCopyright,
			       REF(const char*) pMoreInfoURL,
			       REF(ULONG32)     ulVersionNumber)
{
    pDescription = zm_pDescription;
    pCopyright   = zm_pCopyright;
    pMoreInfoURL = zm_pMoreInfoURL;
    ulVersionNumber = TARVER_ULONG32_VERSION;

    return HXR_OK;
}

STDMETHODIMP
SiteSurfFactory::CreateInstance(REFCLSID rclsid,
				void** ppUnknown)
{
    if(IsEqualIID(rclsid, CLSID_IHXSiteWindowed))
    {
        *ppUnknown = (IUnknown*)(IHXSiteWindowed*)(
#if defined (HELIX_FEATURE_MINI_SITE)	    
            CMiniBaseSite::CreateSite(m_pContext));
#else
            CHXBaseSite::CreateSite(m_pContext));
#endif //HELIX_FEATURE_MINI_SITE

	return ((IUnknown*)*ppUnknown)->QueryInterface(IID_IHXSiteWindowed,
						       (void**)ppUnknown);
    }
#if defined(_UNIX) && !defined(_MAC_UNIX) && !defined(HELIX_FEATURE_MINI_SITE)
    else if(IsEqualIID(rclsid, CLSID_IHXSiteEventHandler))
    {
	*ppUnknown = (IUnknown*)(IHXSiteEventHandler*)(
	    new CHXSiteEventHandler(m_pContext));
	return ((IUnknown*)*ppUnknown)->QueryInterface(IID_IHXSiteEventHandler,
						       (void**)ppUnknown);
    }
#endif

    *ppUnknown = NULL;
    return HXR_NOINTERFACE;
}

STDMETHODIMP SiteSurfFactory::CreateInstanceAggregatable( REFCLSID rclsid,
                                                          REF(IUnknown*) ppUnknown,
                                                          IUnknown* pUnkOuter)
{
   HX_ASSERT( "This isn't implemented\n" );
   return HXR_FAIL;
}

STDAPI ENTRYPOINT(CanUnload2)(void)
{
    return (CHXBaseCountingObject::ObjectsActive() ? HXR_FAIL : HXR_OK);
}

