/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: upgrade.cpp,v 1.5.2.5 2004/10/18 18:53:31 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "upgrade.h"
#include "commonapp.h"
#include "hxplayer-i18n.h"

#include "hlxclib/ctype.h"

#include <string.h>

typedef struct
{
    GladeXML* xml;
    
} HXUpgradeRequestDialog;

/* glade callbacks for the common dialogs */
extern "C"
{
    void hud_show_details(GtkWidget* widget);
    void hud_check_for_updates(GtkWidget* widget);
}


/* Handler for the "Details..." button on the component
   missing/upgrade dialog */
void
hud_show_details(GtkWidget* widget)
{
    GladeXML* xml;
    GtkWidget* vbox;
    GtkWidget* toplevel;

    toplevel = gtk_widget_get_toplevel(widget);
    
    xml = (GladeXML*)g_object_get_data(G_OBJECT(toplevel), "xml");

    vbox = glade_xml_get_widget(xml, "hud_details_vbox");
    if(vbox)
    {
        gtk_widget_show(vbox);
    }    
}

void
hud_check_for_updates(GtkWidget* widget)
{
    hxcommon_launch_upgrade_with_widget_name(widget);
}


static void
hxplay_request_upgrade_dialog_destroy(GtkWidget* /* widget */,
                                      HXUpgradeRequestDialog* dialog)
{
    glade_xml_destroy (dialog->xml);

    g_free(dialog);
}

#ifndef HELIX_FEATURE_REAL_BRANDING
static gboolean
has_real_player_only_components(GList* components_list)
{
    static const gchar* realplayer_only_components[] =
    {
        "audio/x-pn-realaudio",
        "audio/mpeg",
        "audio/mp3",
        "mp3",
        "swf",
        "aac",
        "mp4",

        /* XXXRGG: These will be in a future version of the Helix Player */
        "wav",
        "aiff",
        "au",
        
        "protocol_rtsp_rdt", // synthesized by the player.
        "protocol_pnm"       // synthesized by the player.
    };    

    gboolean rp_only = FALSE;
    guint i;
    GList* iter;

    iter = components_list;
    while(iter && !rp_only)
    {        
        gchar* component = (gchar*)iter->data;
        for(i = 0; i < sizeof(realplayer_only_components) / sizeof(*realplayer_only_components); i++)
        {
            if(strcasecmp(realplayer_only_components[i], component) == 0)
            {
                rp_only = TRUE;
                break;
            }
        }
        iter = g_list_next(iter);
    }

    return rp_only;
}
#endif

static gboolean
has_obsolete_components(GList* components_list)
{
   static const gchar* obsolete_components[] = { "DNET" };
   gboolean obsolete = FALSE;
   GList* iter = NULL;
   guint i;

   iter = components_list;
   while(iter && !obsolete)
   {        
       gchar* component = (gchar*)iter->data;
       for(i = 0; i < sizeof(obsolete_components) / sizeof(*obsolete_components); i++)
       {
           if(strcasecmp(obsolete_components[i], component) == 0)
           {
               obsolete = TRUE;
               break;
           }
       }
       iter = g_list_next(iter);
   }

   return obsolete;
}


GtkDialog*
hxplay_request_upgrade_dialog_new (const gchar* url,
                                   GList*       components_list,
                                   gboolean     blocking)
{
    GladeXML *xml;
    GtkWidget *dialog;
    gchar *filename;
    GtkWidget* label;
    GtkWidget* url_label;
    GString* str;
    GString* uri_str;
    GList* iter;
    gboolean first_component = TRUE;
    HXUpgradeRequestDialog* info = NULL;
    gboolean is_obsolete = FALSE;
    
    is_obsolete = has_obsolete_components(components_list);
        
    if(is_obsolete)
    {
        dialog = gtk_message_dialog_new(NULL,
                                        GTK_DIALOG_MODAL,
                                        GTK_MESSAGE_ERROR,
                                        GTK_BUTTONS_OK,
                                        _("The content you are trying to play uses an audio codec that is obsolete and no longer supported. Please contact the content provider about using a supported codec."));

        return GTK_DIALOG(dialog);
    }

    str = g_string_new("");
    uri_str = g_string_new("");
    
    iter = components_list;
    while(iter)
    {
        gchar* pos = (gchar*)iter->data; 

        if(!first_component)
        {
            g_string_append_c(uri_str, ',');
        }
        
        while(*pos)
        {
            if(isalnum(*pos))
            {
                g_string_append_c(uri_str, *pos);
            }
            else
            {
                g_string_append_printf(uri_str, "%%%02x", (guint)(*pos));
            }
            
            pos++;
        }        
        
        g_string_append(str, (gchar*)iter->data);
        g_string_append_c(str, '\n');
        
        first_component = FALSE;
        iter = g_list_next(iter);
    }                                              

    filename = hxcommon_locate_file("upgrade.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    dialog = glade_xml_get_widget (xml, "hxplayer_upgrade_dialog");
    label = glade_xml_get_widget (xml, "hud_upgrade_label");    
    url_label = glade_xml_get_widget (xml, "hud_uri_label");

    g_return_val_if_fail(dialog != NULL && label != NULL && url_label != NULL,
                         NULL);

    g_object_set_data(G_OBJECT(dialog), "xml", xml);
    g_object_set_data(G_OBJECT(dialog), "components", uri_str->str);

    gtk_label_set_text(GTK_LABEL(label), str->str);
    gtk_label_set_text(GTK_LABEL(url_label), url);
        
    g_string_free(str, TRUE);
    g_string_free(uri_str, TRUE);

    info = g_new0(HXUpgradeRequestDialog, 1);
    info->xml = xml;

#ifndef HELIX_FEATURE_REAL_BRANDING
    gboolean is_rp_only = FALSE;
    GtkWidget* upgrade_description_label;
    GtkWidget* check_for_updates_button;
    
    is_rp_only = has_real_player_only_components(components_list);

    if(is_rp_only)
    {
        /* Switch the "Check for updates..." button to "Get RealPlayer...",
           and the description to emphasize that this functionality is RealPlayer
           only. */
        check_for_updates_button = glade_xml_get_widget(xml, "hud_check_for_updates_button");
        upgrade_description_label = glade_xml_get_widget(xml, "hud_upgrade_description_label");

        if(upgrade_description_label)
        {
            gtk_label_set_markup(GTK_LABEL(upgrade_description_label),
                                 _("<b>"
                                   "The player does not have the\n"
                                   "capabilities to play back this content\n"
                                   "\n"
                                   "This content is supported by RealPlayer.\n"
                                   "</b>"));
        }

        if(check_for_updates_button)
        {
            gtk_button_set_label(GTK_BUTTON(check_for_updates_button), _("Get RealPlayer..."));
        }
    }
#endif    
    
    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hxplay_request_upgrade_dialog_destroy),
                      info);
    
    return GTK_DIALOG(dialog);
}

