/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rtrender.h,v 1.1.2.1 2004/07/09 01:50:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#ifndef _RTRENDER_H_
#define _RTRENDER_H_


#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#endif

/* The following allows rt to play "brush" elements in a SMIL 2.0+
 * presentation with animation of the RT window's background color
 * on the fly:
 */

class CRealTextStatusCallback;
class CResourceLoader;

/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//	CRealTextRenderer
//
//  Purpose:
//
//	RealText implementation of a basic renderer.
//

class CRealTextRenderer :   public IHXPlugin
			    , public IHXRenderer
			    , public IHXSiteUser
			    , public RealTextRenderer
			    , public IHXStatistics
			    , public IHXCallback
			    , public IHXUpdateProperties
			    , public IHXValues
{
private:

    HXxSize		m_lastKnownSize;
    TextWindow		m_txtWin;
    BOOL		m_bPriorPacketWasLostOrWeJustSeeked;
	
    LONG32		m_lRefCount;
    IUnknown*		m_pContext;
    IHXStream*		m_pStream;
    IHXPlayer*		m_pPlayer;
    IHXValues*		m_pHeader;
    IHXPacket*		m_pLastPacket;
    IHXScheduler*	m_pScheduler;

    HXMutex*		m_pMutex;

    // IHXScheduler / IHXCallback support
    CallbackHandle	    m_PendingHandle;
    BOOL		    m_bPendingCallback;
    BOOL		    m_bInCallback;
    IHXOptimizedScheduler* m_pOptimizedScheduler;

    ULONG32		m_ulLastTime;
    ULONG32		m_ulLastTimeSyncPlayerTimeIeNoOffset;
    LONG32		m_lTimeOffset;
    BOOL		m_bTimeOffsetHasBeenInitialized;
    LONG32		m_lCumulativeUpdatedTimeOffset;
    ULONG32		m_ulDuration;

    //This is 0 for non-live streams, t for live streams where
    // t is the system wallclock time when the live text encoder started up:
    ULONG32		m_ulStreamStartTime;

    ULONG32		m_ulLastTimeSyncWorkTime;
    ULONG32		m_ulTimeAtPriorTimeSyncEntrance;
    ULONG32		m_ulTimeAtPriorTimeSyncExit;

    IHXMultiInstanceSiteUserSupplier*	m_pMISUS;
    IHXSite*				m_pMISUSSite;
    IHXCommonClassFactory*		m_pCommonClassFactory;
    IHXHyperNavigate*			m_pHyperNavigate;
    IHXPreferences*			m_pPreferences;
    IHXStatusMessage*			m_pStatusMessage;
    IHXValues*                         m_pValues;

    ULONG32		m_ulGranularity;
    ULONG32		m_ulFrameRate;

    CHXString		m_urlPrefix;

    BOOL		m_bIsPaused;

    BOOL		m_bNoPacketsArrivedYet;

    BOOL		m_bSeekJustFinished;

    ULONG32		m_ulTimeOfPriorDraw;
    ULONG32		m_ulTimeOfCurrentDraw;
    ULONG32		m_ulTimeOfLastNonScrollWindowDraw;

    ULONG32		m_ulCurFrameTime;

    BOOL		m_bNoPacketsYetSinceLastSeek;

    BOOL		m_bLastDrawWasAFullWindowRefresh;

    HXxEvent*		m_pEvent;

    BOOL		m_bNeedToSetHyperlinkHandCursor;
    BOOL		m_bStatusMsgWillNeedErasing;

#if defined(_WINDOWS)
    HCURSOR		m_hPreHyperlinkCursor;
    HCURSOR		m_hHyperlinkCursor;
    HWND		m_hWnd;
#elif defined(_MACINTOSH) || defined(_MAC_UNIX)
    CursHandle		m_hHyperlinkCursor;
    typedef enum
    {
        CURSOR_ARROW,
        CURSOR_HYPERLINK
    }
    CursorShapes;
    CursorShapes	m_CurrentCursor;
    CResourceLoader*	m_pResourceLoader;
#elif defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    Cursor              m_hHyperlinkCursor;
    BOOL                m_bHandActivated;
#endif

    BOOL		m_bInSeekMode;

    ULONG32		m_ulLastSeekedToTime;

    BOOL		m_bEndStreamJustOccurred;

    BOOL		m_bLatePacketNotYetDrawn;

#define RT_OUTPUT_LOGFILE
#if !defined(RT_RENDER_DEBUG_FLAGS_MASK)
#define RT_RENDER_DEBUG_FLAGS_MASK	0x0000FFFF
#endif

#ifdef _DEBUG
#if defined(RT_OUTPUT_LOGFILE)
    FILE*		m_logfile;
#endif
#endif

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    Window m_lastWindow;
    UINT32 m_nBitsPerPixel;
    XVisualInfo* m_pVisualInfo;


    HXBitmapInfoHeader m_BitmapInfoHeader;
    Pixmap m_Pixmap;
    Display *m_pPixmapDisplay;
#endif

    static const char*	zm_pName;
    static const char*	zm_pDescription;
    static const char*	zm_pCopyright;
    static const char*	zm_pMoreInfoURL;
    static const char*	zm_pStreamMimeTypes[];

    typedef enum { Stopped, Buffering, Playing, Paused, Seeking } PlayState;
    PlayState	m_PlayState;

    ~CRealTextRenderer			();
    CHXString GetURLString		(TextContainer* pTextContainer);
    HX_RESULT GetCurrentMousePos	(INT16& uXPos,
					INT16& uYPos);

    TextContainer* GetTextContainerAt	(INT16 xPos, 
					INT16 yPos);
    HX_RESULT PropertyUpdated(const char* pszStr,
			      BOOL bPropertyIsULONG32);

    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

public:

    CRealTextRenderer();

    //For adding the protocol & path to <A >-tag URLs that are relative
    // to the rtx file's location:
    void generatePreFix(void);

    CHXString& getURLPrefix() { return m_urlPrefix; }

    BOOL	ShouldKickStartScheduler();
    HX_RESULT	ScheduleCallback(UINT32 ulRelativeTime, UINT32 ulTicksTime);
    //The following is a helper function for SchedulerCallback() calculations:
    ULONG32	GetNextFrameTime(ULONG32 ulCurStreamTime);
    void	SchedulerCallback();

    inline void RemoveCallback(CallbackHandle &hCallback);

    inline ULONG32  StreamTime() const
    {
	return ((m_ulTimeAtPriorTimeSyncEntrance != 0)?((HX_GET_BETTERTICKCOUNT() -
		m_ulTimeAtPriorTimeSyncEntrance) + m_ulLastTime) :
		(m_ulLastTime));
    }

    HX_RESULT HandleStatusCallback	();

    HX_RESULT adjustForUserTextSizeSetting(); // /Handles user pref setting
    // /Gets value of player registry, pPrefName key; returns addref'd pBuf:
    HX_RESULT GetUserPref(const char* pPrefName, IHXBuffer*& pBuf /*OUT*/);


    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)	 /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXRenderer methods ***

    /************************************************************************
     *	Method:
     *	    IHXRenderer::GetRendererInfo
     *	Purpose:
     *	    Returns information vital to the instantiation of rendering 
     *	    plugins.
     */
    STDMETHOD(GetRendererInfo)	(THIS_
				REF(const char**) /*OUT*/ pStreamMimeTypes,
				REF(UINT32)      /*OUT*/ unInitialGranularity
				);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::StartStream
    //	Purpose:
    //	    Called by client engine to inform the renderer of the stream it
    //	    will be rendering. The stream interface can provide access to
    //	    its source or player. This method also provides access to the 
    //	    primary client controller interface.
    //
    STDMETHOD (StartStream)	(THIS_
				IHXStream*	    pStream,
				IHXPlayer*	    pPlayer);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::EndStream
    //	Purpose:
    //	    Called by client engine to inform the renderer that the stream
    //	    is was rendering is closed.
    //
    STDMETHOD (EndStream)	(THIS);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnHeader
    //	Purpose:
    //		Called by client engine when a header for this renderer is 
    //		available. The header will arrive before any packets.
    //
    STDMETHOD (OnHeader)	(THIS_
				IHXValues*	    pHeader);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPacket
    //	Purpose:
    //	    Called by client engine when a packet for this renderer is 
    //	    due.
    //
    STDMETHOD (OnPacket)	(THIS_
				IHXPacket*	    pPacket,
				LONG32 		    lTimeOffset);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnTimeSync
    //	Purpose:
    //	    Called by client engine to inform the renderer of the current
    //	    time relative to the streams synchronized time-line. The 
    //	    renderer should use this time value to update its display or
    //	    render it's stream data accordingly.
    //
    STDMETHOD (OnTimeSync)	(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //  Method:
    //	    IHXRenderer::OnPreSeek
    //  Purpose:
    //	    Called by client engine to inform the renderer that a seek is
    //	    about to occur. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek will be completed.
    //
    STDMETHOD (OnPreSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPostSeek
    //	Purpose:
    //	    Called by client engine to inform the renderer that a seek has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the seek, as well as the first new
    //	    time for the stream's time line after the seek.
    //
    STDMETHOD (OnPostSeek)	(THIS_
				ULONG32		    ulOldTime,
				ULONG32		    ulNewTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //	    IHXRenderer::OnPause
    //	Purpose:
    //	    Called by client engine to inform the renderer that a pause has
    //	    just occured. The render is informed the last time for the 
    //	    stream's time line before the pause.
    //
    STDMETHOD (OnPause)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBegin
    //	Purpose:
    //		Called by client engine to inform the renderer that a begin or
    //		resume has just occured. The render is informed the first time 
    //		for the stream's time line after the resume.
    //
    STDMETHOD (OnBegin)		(THIS_
				ULONG32		    ulTime);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::OnBuffering
    //	Purpose:
    //		Called by client engine to inform the renderer that buffering
    //		of data is occuring. The render is informed of the reason for
    //		the buffering (start-up of stream, seek has occured, network
    //		congestion, etc.), as well as percentage complete of the 
    //		buffering process.
    //
    STDMETHOD (OnBuffering)	(THIS_
				ULONG32		    ulFlags,
				UINT16		    unPercentComplete);

    /////////////////////////////////////////////////////////////////////////
    //	Method:
    //		IHXRenderer::GetDisplayType
    //	Purpose:
    //		Called by client engine to ask the renderer for it's preferred
    //		display type. When layout information is not present, the 
    //		renderer will be asked for it's prefered display type. Depending
    //		on the display type a buffer of additional information may be 
    //		needed. This buffer could contain information about preferred
    //		window size.
    //
    STDMETHOD (GetDisplayType)	(THIS_
				REF(HX_DISPLAY_TYPE)	ulFlags,
				REF(IHXBuffer*)	pBuffer);

    /************************************************************************
     *	Method:
     *	    IHXRenderer::OnEndofPackets
     *	Purpose:
     *	    Called by client engine to inform the renderer that all the
     *	    packets have been delivered. However, if the user seeks before
     *	    EndStream() is called, renderer may start getting packets again
     *	    and the client engine will eventually call this function again.
     */
    STDMETHOD(OnEndofPackets)	(THIS);

    /*
     * IHXSiteUser methods usually called by the "context" to 
     * associate users with the site.
     */
    STDMETHOD(AttachSite)	(THIS_
				IHXSite*	/*IN*/ pSite);

    STDMETHOD(DetachSite)	(THIS);

    /*
     * IHXSiteUser methods called to inform user of an event.
     */
    STDMETHOD(HandleEvent)	(THIS_
				HXxEvent*	/*IN*/ pEvent);

    STDMETHOD_(BOOL,NeedsWindowedSites)	(THIS);


    /************************************************************************
     *  Method:
     *      IHXStatistics::InitializeStatistics
     *  Purpose:
     *      Pass registry ID to the caller
     */
    STDMETHOD (InitializeStatistics)
				(THIS_
				UINT32		    /*IN*/ ulRegistryID);

    /************************************************************************
     *  Method:
     *      IHXStatistics::UpdateStatistics
     *  Purpose:
     *      Notify the client to update its statistics stored in the registry
     */
    STDMETHOD (UpdateStatistics)(THIS);


    /*
     * IHXCallback methods:
     */

     /************************************************************************
     *	Method:
     *	    IHXCallback::Func
     *	Purpose:
     *	    This is the function that will be called when a callback is
     *	    to be executed.
     */
    STDMETHOD(Func)		(THIS);


    /************************************************************************
     *	Method:
     *	    IHXUpdateProperties::UpdatePacketTimeOffset
     *	Purpose:
     *	    Call this method to update the timestamp offset of cached packets
     */
    STDMETHOD(UpdatePacketTimeOffset) (THIS_
				       INT32 lTimeOffset);

    /************************************************************************
     *	Method:
     *	    IHXUpdateProperties::UpdatePlayTimes
     *	Purpose:
     *	    Call this method to update the playtime attributes
     */
    STDMETHOD(UpdatePlayTimes)	      (THIS_
				       IHXValues* pProps);
    
    /************************************************************************
     *
     *	IHXValues methods
     */
    /*
     * Note: That strings returned as references should be copied or
     * 	     used immediately because their lifetime is only as long as the
     * 	     IHXValues's objects lifetime.
     *
     * Note: Your iterator will be reset once you give up control to the
     *	     Helix core (i.e. you exit whatever function gave you a time slice).
     */

    STDMETHOD(SetPropertyULONG32)	(THIS_
					const char*      pPropertyName,
					ULONG32          uPropertyValue);
    STDMETHOD(GetPropertyULONG32)	(THIS_
					const char*      pPropertyName,
					REF(ULONG32)     uPropertyName);
    STDMETHOD(GetFirstPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)     uPropertyValue);
    STDMETHOD(GetNextPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)     uPropertyValue);
    STDMETHOD(SetPropertyBuffer)	(THIS_
					const char*      pPropertyName,
					IHXBuffer*      pPropertyValue);
    STDMETHOD(GetPropertyBuffer)	(THIS_
					const char*      pPropertyName,
					REF(IHXBuffer*) pPropertyValue);
    STDMETHOD(GetFirstPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);
    STDMETHOD(GetNextPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);
    STDMETHOD(SetPropertyCString)	(THIS_
					const char*      pPropertyName,
					IHXBuffer*      pPropertyValue);
    STDMETHOD(GetPropertyCString)	(THIS_
					const char*      pPropertyName,
					REF(IHXBuffer*) pPropertyValue);
    STDMETHOD(GetFirstPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);
    STDMETHOD(GetNextPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);


    /************************************************************************
     *	Method:
     *	    HXxSubclassingWindow::Draw
     *	Purpose:
     *	    TBD
     */
    virtual void Draw();

    void OnLbuttonUp(INT16 fwKeys, INT16 xPos, INT16 yPos);

    BOOL OnMouseMove(INT16 fwKeys, INT16 xPos, INT16 yPos);

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    /************************************************************************
     * X11 member access
     */
    inline Pixmap GetPixmap() { return m_Pixmap; }
    inline Display* GetPixmapDisplay() { return m_pPixmapDisplay; }
#endif
};

#endif // ndef _RTRENDER_H_

