/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: evnthook.cpp,v 1.3.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxwin.h"
#include "hxevent.h"
// pncont
#include "hxstring.h"
#include "hxmap.h"
// smlrendr
#include "evnthook.h"
// pndebug
#include "debugout.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

CSmilEventHook::CSmilEventHook(CSmilEventHookResponse* pResponse,
                               const char*             pRegionName,
                               const char*             pChannelName,
                               BOOL                    bNoRegion,
                               const char*             pszMediaID)
{
    m_lRefCount    = 0;
    m_pResponse    = pResponse;
    m_bNoRegion    = bNoRegion;
    m_pSiteMap     = NULL;
    m_pRegionName  = new CHXString(pRegionName);
    HX_ASSERT(m_pRegionName);
    m_pChannelName = new CHXString(pChannelName);
    HX_ASSERT(m_pChannelName);
    m_pMediaID     = new CHXString(pszMediaID);
    HX_ASSERT(m_pMediaID);
    if (m_pResponse)
    {
        m_pResponse->AddRef();
    }
}

CSmilEventHook::~CSmilEventHook()
{
    HX_DELETE(m_pRegionName);
    HX_DELETE(m_pChannelName);
    HX_DELETE(m_pMediaID);
    // Release the response interface
    if (m_pResponse)
    {
        m_pResponse->Release();
        m_pResponse = NULL;
    }
    // Release any remaining sites
    if (m_pSiteMap)
    {
        POSITION pos = m_pSiteMap->GetStartPosition();
        while (pos)
        {
            void* pKey = NULL;
            void* pPtr = NULL;
            m_pSiteMap->GetNextAssoc(pos, pKey, pPtr);
            IHXSite* pSite = (IHXSite*) pKey;
            HX_RELEASE(pSite);
        }
        m_pSiteMap->RemoveAll();
    }
    HX_DELETE(m_pSiteMap);
}

STDMETHODIMP CSmilEventHook::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        if(IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXEventHook*) this;
        }
        else if(IsEqualIID(riid, IID_IHXEventHook))
        {
            AddRef();
            *ppvObj = (IHXEventHook*) this;
        }
        else
        {
            *ppvObj = NULL;
            retVal  = HXR_NOINTERFACE;
        }
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) CSmilEventHook::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) CSmilEventHook::Release()
{
    if(InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP CSmilEventHook::HandleEvent(IHXSite* pSite, HXxEvent* pEvent)
{
    HX_RESULT rc = HXR_OK;

    void* pVoid = NULL;
    if(m_pResponse &&
       m_pSiteMap &&
       m_pSiteMap->Lookup((void*) pSite, pVoid))
    {
        switch(pEvent->event)
        {
            case HX_MOUSE_MOVE:
            case HX_MOUSE_ENTER:
            case HX_MOUSE_LEAVE:
                {
		    BOOL bIsMouseLeaveEvent =
			    (HX_MOUSE_LEAVE == pEvent->event);
		    BOOL bHandleSetCursor = FALSE;
                    HXxPoint* mousePt = (HXxPoint*) pEvent->param1;
                    rc = m_pResponse->HandleMouseMove(pEvent->window,
                                                      GetRegionName(),
                                                      GetMediaID(),
                                                      (INT16) mousePt->x,
                                                      (INT16) mousePt->y,
						      (UINT32)pEvent->event,
						      bHandleSetCursor);
		    // /In case we moved off of a hyperlink and onto an area
		    // not covered by media, we need to update the cursor:
		    if (bHandleSetCursor)
		    {
			m_pResponse->HandleSetCursor();
		    }
                    if (SUCCEEDED(rc))
                    {
                        pEvent->handled = TRUE;
                    }
		    // /Fixes PR 62047; if we return anything else, then the
		    // event doesn't get passed along to media, below, which
		    // it needs to in the case where we didn't handle this:
		    rc = HXR_OK;
                }
                break;

            case HX_PRIMARY_BUTTON_UP:
                {
                    HXxPoint* mousePt = (HXxPoint*) pEvent->param1;
                    BOOL      bHandled = FALSE;
                    rc = m_pResponse->HandleLButtonUp(GetRegionName(),
                                                      GetMediaID(),
                                                      (INT16) mousePt->x,
                                                      (INT16) mousePt->y,
                                                      bHandled);
                    if (SUCCEEDED(rc))
                    {
                        pEvent->handled = bHandled;
                    }
		    rc = HXR_OK; // /Fixes PR 62047 (see above).
                }
                break;

            case HX_SET_FOCUS:
                {
                    rc = m_pResponse->HandleGotFocus(GetRegionName(),
                                                     GetMediaID());
                    if (SUCCEEDED(rc))
                    {
                        pEvent->handled = TRUE;
                    }
                }
                break;
            case HX_LOSE_FOCUS:
                {
                    rc = m_pResponse->HandleLostFocus(GetRegionName(),
                                                      GetMediaID());
                    if (SUCCEEDED(rc))
                    {
                        pEvent->handled = TRUE;
                    }
                }
                break;

                // Translated key event (already accounts for shift+, CTRL+, etc.):            
#if defined(_WINDOWS)
                // XXXEH- Old site implementation passes WM_CHAR message only;
                // we should remove this after HX_CHAR is being sent properly:
                // XXXMEH - Since we are going to stop claiming that
                // we handled keystrokes, then we need to only listen
                // on either WM_CHAR OR HX_CHAR, but not both. If we
                // were listening on both and not claiming that we 
                // handled the keystroke, then we would get both of
                // them and potentially try to start foo.accesskey()
                // elements twice. So we will only listen for HX_CHAR
//            case WM_CHAR:
#endif
            case HX_CHAR:
            {
                UINT16 uCharPressed = (UINT16) (UINT32)pEvent->param1;
                // XXXEH: TODO: Handle this: "The character is a single
                // character from [[ISO10646]]."
                rc = m_pResponse->HandleCharEvent(uCharPressed);
                if (SUCCEEDED(rc))
                {
                    // XXXMEH - we will no longer claim that we handle
                    // keystrokes. This will allow renderers such as 
                    // flash to get the keystrokes for forms, etc.
                    pEvent->handled = FALSE;
                }
		rc = HXR_OK; // /Fixes PR 62248 (see PR 62047 note, above).
            }
            break;

#ifdef _WINDOWS
            case WM_SETCURSOR:
            {
                pEvent->handled = m_pResponse->HandleSetCursor();
            }
            break;
#endif  
            default:
                break;
        }
    }

    return rc;
}

STDMETHODIMP CSmilEventHook::SiteAdded(IHXSite* pSite)
{
    HX_RESULT retVal = HXR_OK;

    if (pSite)
    {
        // Create the site map if necessary
        if (!m_pSiteMap)
        {
            m_pSiteMap = new CHXMapPtrToPtr();
        }
        if (m_pSiteMap)
        {
            // AddRef the site before adding it
            pSite->AddRef();
            // Add this site to the site map
            m_pSiteMap->SetAt((void*) pSite, (void*) 0);
            // Add how events if necessary
            if(m_bNoRegion && m_pResponse)
            {
                m_pResponse->AddShowEvents(GetRegionName(), pSite);
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP CSmilEventHook::SiteRemoved(IHXSite* pSite)
{
    HX_RESULT retVal = HXR_OK;

    // Check to see if this site is in the map
    void* pVoid = NULL;
    if (m_pSiteMap && m_pSiteMap->Lookup((void*) pSite, pVoid))
    {
        // Remove this site from the map
        m_pSiteMap->RemoveKey((void*) pSite);
        // Release our ref on the site
        HX_RELEASE(pSite);
    }

    return retVal;
}

const char* CSmilEventHook::GetRegionName() const
{
    const char* pRet = NULL;

    if (m_pRegionName)
    {
        pRet = (const char*) *m_pRegionName;
    }

    return pRet;
}

const char* CSmilEventHook::GetChannelName() const
{
    const char* pRet = NULL;

    if (m_pChannelName)
    {
        pRet = (const char*) *m_pChannelName;
    }

    return pRet;
}

const char* CSmilEventHook::GetMediaID() const
{
    const char* pRet = NULL;

    if (m_pMediaID)
    {
        pRet = (const char*) *m_pMediaID;
    }

    return pRet;
}

