/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: animsand.h,v 1.2.18.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef ANIMSAND_H
#define ANIMSAND_H

// Forward declarations
class CSmilAnimateElement;
class CAttr;
class CHXString;
class CHXSimpleList;
class CSmilParser;

#if defined(HELIX_FEATURE_SMIL2_ANIMATION)

class CAnimationSandwichLayer
{
public:
    CAnimationSandwichLayer(CSmilAnimateElement* pElement,
                            UINT32               ulAttrName,
                            CSmilParser*         pParser);
    virtual ~CAnimationSandwichLayer();

    const char*          GetTargetElementID() const;
    const char*          GetAnimationElementID() const;
    SMILNodeTag          GetTargetElementTag() const;
    SMILNodeTag          GetAnimationElementTag() const;
    UINT32               GetAttributeName() const { return m_ulAttrName; }
    BOOL                 IsActive(UINT32 ulTime) const;
    BOOL                 IsFrozen(UINT32 ulTime) const;
    BOOL                 IsActiveZeroBased(UINT32 ulTime) const;
    BOOL                 IsFrozenZeroBased(UINT32 ulTime) const;
    BOOL                 IsAdditive() const;
    BOOL                 IsToAnimation() const;
    CAttr                AnimationEffectFunction(UINT32 ulTime, CAttr* pUnder,
                                                 CAttr* pDepend = NULL);
    BOOL                 HigherPriority(CAnimationSandwichLayer* pLayer);
    void                 AdjustActiveDuration(UINT32 ulTime);
protected:
    CSmilAnimateElement* m_pElement;
    UINT32               m_ulAttrName;
    double*              m_pdPacedDist;
    double*              m_pdPacedTime;
    CSmilParser*         m_pSmilParser;
    UINT32               m_ulLastTime;
    UINT32               m_ulDelay;
    UINT32               m_ulActiveDuration;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD          m_bRecomputePace : 1;
    HX_BITFIELD          m_bFirstTime : 1;

    CAttr  SimpleAnimationFunction(UINT32 ulTime, CAttr* pUnder, CAttr* pDepend);
    CAttr  CumulativeAnimationFunction(UINT32 ulTime, CAttr* pUnder, CAttr* pDepend);
    void   RecomputePace(CAttr* pDepend);
    UINT32 ComputeFilteredSimpleTime(UINT32 ulUnfilteredActiveTime);
    double ComputeRunRate(double dT, double dAccel, double dDecel, double dDur);
#if defined(XXXMEH_SPLINE_ANIMATION)
    double ComputeSpline(double t,  double t1, double t2,
                         double v1, double v2,
                         double x1, double y1, double x2, double y2);
    double ComputeBezierOutputTime(double t, double x1, double y1,
                                   double x2, double y2);
    double SolveForBezierT(double x, double x1, double x2, double tol);
    double ComputeBezier(double t, double a1, double a2);
#endif
};

class CAnimationSandwich
{
public:
    CAnimationSandwich(const char* pszTargetElementID,
                       SMILNodeTag eTargetElementTag,
                       UINT32      ulAttrName);
    virtual ~CAnimationSandwich();

    const char* GetTargetElementID() const;
    SMILNodeTag GetTargetElementTag() const { return m_eTargetElementTag; }
    UINT32      GetAttributeName() const    { return m_ulAttrName; }
    HX_RESULT   AddLayer(CAnimationSandwichLayer* pLayer);
    void        RemoveLayer(const char* pszAnimID);
    void        FreezeLayers(const char* pszAnimID, UINT32 ulCurTime);
    CAttr       GetValue(UINT32 ulTime, CAttr* pUnder, CAttr* pDepend = NULL);
    void        AdjustLayers(UINT32 ulTime);
    UINT32      GetNumLayers() const;
    BOOL        MatchingSandwich(CSmilAnimateElement* pAnim);
    BOOL        AtLeastOneActiveLayer(UINT32 ulTime);
protected:
    CHXString*     m_pTargetElementID;
    SMILNodeTag    m_eTargetElementTag;
    UINT32         m_ulAttrName;
    CHXSimpleList* m_pLayerList;

    void ClearAllLayers();
};

class CSmilAnimateInfo
{
public:
    CSmilAnimateInfo();
    virtual ~CSmilAnimateInfo();

    CAnimationSandwich* m_pSandwich;
    CAttr*              m_pUnder;
    CAttr*              m_pDepend;
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */

#endif
